<?php

namespace App\Domain\Admin;

use App\Models\AdminActionsAudit;
use App\Models\User;

class AdminAuditService
{
    public function log(User $admin, ?User $target, string $action, ?string $reason = null, array $meta = []): void
    {
        AdminActionsAudit::query()->create([
            'admin_user_id' => $admin->id,
            'target_user_id' => $target?->id,
            'action' => $action,
            'reason' => $reason,
            'meta_jsonb' => $meta,
        ]);
    }
}
