<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Transfer;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\View\View;

class TransactionLogController extends Controller
{
    public function index(Request $request): View
    {
        $query = Transfer::query()->with(['sender', 'receiver'])->latest();

        if ($request->filled('status')) {
            $query->where('status', $request->string('status')->toString());
        }

        if ($request->filled('public_id')) {
            $publicId = $request->string('public_id')->toString();
            $userId = User::query()->where('public_id', $publicId)->value('id');
            if ($userId) {
                $query->where(function ($q) use ($userId): void {
                    $q->where('sender_user_id', $userId)
                        ->orWhere('receiver_user_id', $userId);
                });
            } else {
                $query->whereRaw('1 = 0');
            }
        }

        if ($request->filled('date_from')) {
            $query->whereDate('created_at', '>=', $request->string('date_from')->toString());
        }

        if ($request->filled('date_to')) {
            $query->whereDate('created_at', '<=', $request->string('date_to')->toString());
        }

        return view('admin.transactions', [
            'transfers' => $query->paginate(30)->withQueryString(),
        ]);
    }
}
