<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\LedgerEntry;
use Illuminate\Http\JsonResponse;

class MeController extends Controller
{
    public function balance(): JsonResponse
    {
        $user = auth()->user();

        return response()->json([
            'public_id' => $user->public_id,
            'currency' => $user->wallet->currency,
            'available_balance' => $user->wallet->available_balance,
            'held_balance' => $user->wallet->held_balance,
        ]);
    }

    public function transactions(): JsonResponse
    {
        $user = auth()->user();

        $items = LedgerEntry::query()
            ->whereHas('wallet', fn ($query) => $query->where('user_id', $user->id))
            ->latest()
            ->paginate(30);

        return response()->json($items);
    }
}
