<?php

namespace App\Http\Controllers\Api\V1;

use App\Http\Controllers\Controller;
use App\Models\FeatureFlag;
use Illuminate\Http\JsonResponse;

class SettingsController extends Controller
{
    public function features(): JsonResponse
    {
        $user = auth()->user();

        $global = FeatureFlag::query()
            ->where('scope', 'global')
            ->pluck('is_enabled', 'feature_key');

        $userFlags = FeatureFlag::query()
            ->where('scope', 'user')
            ->where('user_id', $user->id)
            ->pluck('is_enabled', 'feature_key');

        return response()->json([
            'global' => $global,
            'user' => $userFlags,
        ]);
    }
}
