<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class EnsureApplicationInstalled
{
    public function handle(Request $request, Closure $next): Response
    {
        if (app()->runningInConsole() || app()->environment('testing')) {
            return $next($request);
        }

        $installed = (bool) env('APP_INSTALLED', false) || file_exists(storage_path('app/installed.lock'));
        if (! $installed) {
            if ($request->is('api/*') || $request->expectsJson()) {
                return response()->json(['message' => 'Application is not installed yet. Visit /install.'], 503);
            }

            if (! $request->is('install*')) {
                return redirect('/install');
            }
        }

        return $next($request);
    }
}
