<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class StorePaymentLinkRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'title' => ['required', 'string', 'max:120'],
            'description' => ['nullable', 'string'],
            'fixed_amount' => ['nullable', 'integer', 'min:1'],
            'allow_custom_amount' => ['required', 'boolean'],
            'expires_at' => ['nullable', 'date'],
            'single_use' => ['required', 'boolean'],
            'confirm' => ['required', 'accepted'],
        ];
    }
}
