<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ApiCredential extends Model
{
    protected $fillable = [
        'user_id',
        'key_id',
        'secret_enc',
        'last_used_at',
        'is_active',
        'rotated_at',
    ];

    protected function casts(): array
    {
        return [
            'last_used_at' => 'datetime',
            'rotated_at' => 'datetime',
            'is_active' => 'boolean',
            'secret_enc' => 'encrypted',
        ];
    }
}
