<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BusinessProfile extends Model
{
    protected $primaryKey = 'user_id';

    public $incrementing = false;

    protected $keyType = 'string';

    protected $fillable = [
        'user_id',
        'business_name',
        'is_business_enabled',
        'kyc_status',
        'kyc_data_jsonb',
    ];

    protected function casts(): array
    {
        return [
            'is_business_enabled' => 'boolean',
            'kyc_data_jsonb' => 'array',
        ];
    }
}
