<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PaymentLink extends Model
{
    protected $fillable = [
        'merchant_user_id',
        'code',
        'title',
        'description',
        'fixed_amount',
        'allow_custom_amount',
        'expires_at',
        'single_use',
        'status',
    ];

    protected function casts(): array
    {
        return [
            'allow_custom_amount' => 'boolean',
            'single_use' => 'boolean',
            'expires_at' => 'datetime',
        ];
    }

    public function merchant(): BelongsTo
    {
        return $this->belongsTo(User::class, 'merchant_user_id');
    }
}
