<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Wallet extends Model
{
    protected $fillable = [
        'user_id',
        'currency',
        'available_balance',
        'held_balance',
        'can_send',
        'can_receive',
        'daily_send_limit',
        'monthly_send_limit',
        'velocity_limit_per_minute',
    ];

    protected function casts(): array
    {
        return [
            'can_send' => 'boolean',
            'can_receive' => 'boolean',
        ];
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
