<?php

namespace App\Providers;

use App\Models\SmtpSetting;
use App\Services\SystemSettingsService;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        if (! env('APP_INSTALLED', false) && ! file_exists(storage_path('app/installed.lock'))) {
            return;
        }

        try {
            if (Schema::hasTable('system_settings')) {
                $settings = app(SystemSettingsService::class);
                $systemName = $settings->get('system.name');
                if (! empty($systemName)) {
                    Config::set('app.name', $systemName);
                }
            }

            if (Schema::hasTable('smtp_settings')) {
                $smtp = SmtpSetting::query()->latest()->first();
                if ($smtp) {
                    Config::set('mail.mailers.smtp.host', $smtp->host);
                    Config::set('mail.mailers.smtp.port', $smtp->port);
                    Config::set('mail.mailers.smtp.username', $smtp->username_enc);
                    Config::set('mail.mailers.smtp.password', $smtp->password_enc);
                    Config::set('mail.mailers.smtp.encryption', $smtp->encryption ?: null);
                    Config::set('mail.from.address', $smtp->from_email);
                    Config::set('mail.from.name', $smtp->from_name);
                    Config::set('mail.default', 'smtp');
                }
            }
        } catch (\Throwable) {
            // ignore during partial installs/migrations
        }
    }
}
