<?php

namespace App\Services;

use App\Models\Transfer;
use App\Models\User;
use Illuminate\Validation\ValidationException;

class TransferLimitService
{
    public function assertWithinLimits(User $sender, int $amount): void
    {
        $wallet = $sender->wallet;

        $dailySent = (int) Transfer::query()
            ->where('sender_user_id', $sender->id)
            ->where('status', 'completed')
            ->where('created_at', '>=', now()->startOfDay())
            ->sum('amount');

        if (($dailySent + $amount) > $wallet->daily_send_limit) {
            throw ValidationException::withMessages(['amount' => 'Daily transfer limit exceeded.']);
        }

        $monthlySent = (int) Transfer::query()
            ->where('sender_user_id', $sender->id)
            ->where('status', 'completed')
            ->where('created_at', '>=', now()->startOfMonth())
            ->sum('amount');

        if (($monthlySent + $amount) > $wallet->monthly_send_limit) {
            throw ValidationException::withMessages(['amount' => 'Monthly transfer limit exceeded.']);
        }

        $perMinute = (int) Transfer::query()
            ->where('sender_user_id', $sender->id)
            ->where('created_at', '>=', now()->subMinute())
            ->count();

        if ($perMinute >= $wallet->velocity_limit_per_minute) {
            throw ValidationException::withMessages(['amount' => 'Transfer velocity limit exceeded.']);
        }
    }
}
