<?php

namespace App\Support\Security;

class ApiSignatureService
{
    public function buildPayload(string $method, string $path, string $body, string $timestamp, string $nonce): string
    {
        return strtoupper($method)."\n".$path."\n".$body."\n".$timestamp."\n".$nonce;
    }

    public function sign(string $secret, string $payload): string
    {
        return hash_hmac('sha256', $payload, $secret);
    }

    public function verify(string $secret, string $payload, string $signature): bool
    {
        $calculated = $this->sign($secret, $payload);

        return hash_equals($calculated, strtolower($signature));
    }
}
