<?php

namespace App\Support\Security;

use App\Models\User;
use PragmaRX\Google2FA\Google2FA;

class TotpService
{
    public function __construct(private readonly Google2FA $google2FA)
    {
    }

    public function verify(User $user, ?string $code): bool
    {
        if (! $user->security || ! $user->security->totp_enabled) {
            return true;
        }

        if (! $code) {
            return false;
        }

        return $this->google2FA->verifyKey($user->security->totp_secret_enc ?? '', $code);
    }
}
