<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->id();
            $table->uuid('user_id')->unique();
            $table->char('currency', 3)->default('USD');
            $table->bigInteger('available_balance')->default(0);
            $table->bigInteger('held_balance')->default(0);
            $table->boolean('can_send')->default(true);
            $table->boolean('can_receive')->default(true);
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
            $table->index(['currency', 'updated_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('wallets');
    }
};
