<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('business_profiles', function (Blueprint $table) {
            $table->uuid('user_id')->primary();
            $table->string('business_name', 120)->nullable();
            $table->boolean('is_business_enabled')->default(false);
            $table->enum('kyc_status', ['pending', 'approved', 'rejected'])->default('pending');
            $table->json('kyc_data_jsonb')->nullable();
            $table->timestamps();

            $table->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('business_profiles');
    }
};
