<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('feature_flags', function (Blueprint $table) {
            $table->id();
            $table->enum('scope', ['global', 'user'])->default('user');
            $table->uuid('user_id')->nullable();
            $table->string('feature_key', 100);
            $table->boolean('is_enabled')->default(true);
            $table->uuid('updated_by')->nullable();
            $table->timestamps();

            $table->index(['scope', 'feature_key']);
            $table->unique(['scope', 'user_id', 'feature_key']);
            $table->foreign('user_id')->references('id')->on('users')->nullOnDelete();
            $table->foreign('updated_by')->references('id')->on('users')->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('feature_flags');
    }
};
