<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('admin_actions_audits', function (Blueprint $table) {
            $table->id();
            $table->uuid('admin_user_id');
            $table->uuid('target_user_id')->nullable();
            $table->string('action', 100);
            $table->text('reason')->nullable();
            $table->json('meta_jsonb')->nullable();
            $table->timestamps();

            $table->foreign('admin_user_id')->references('id')->on('users');
            $table->foreign('target_user_id')->references('id')->on('users')->nullOnDelete();
            $table->index(['action', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('admin_actions_audits');
    }
};
