<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('wallets', function (Blueprint $table) {
            $table->bigInteger('daily_send_limit')->default(500000)->after('can_receive');
            $table->bigInteger('monthly_send_limit')->default(5000000)->after('daily_send_limit');
            $table->unsignedInteger('velocity_limit_per_minute')->default(10)->after('monthly_send_limit');
        });
    }

    public function down(): void
    {
        Schema::table('wallets', function (Blueprint $table) {
            $table->dropColumn(['daily_send_limit', 'monthly_send_limit', 'velocity_limit_per_minute']);
        });
    }
};
