<?php

namespace Database\Seeders;

use App\Models\SystemSetting;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class SystemBootstrapSeeder extends Seeder
{
    public function run(): void
    {
        $systemName = env('BOOTSTRAP_SYSTEM_NAME', env('APP_NAME', 'Secure Wallet'));
        $copyright = env('BOOTSTRAP_SYSTEM_COPYRIGHT', env('APP_COPYRIGHT', ''));

        SystemSetting::setValue('system.name', $systemName);
        SystemSetting::setValue('system.copyright', $copyright);

        $adminEmail = env('BOOTSTRAP_ADMIN_EMAIL');
        $adminUsername = env('BOOTSTRAP_ADMIN_USERNAME');
        $adminPassword = env('BOOTSTRAP_ADMIN_PASSWORD');

        if (! $adminEmail || ! $adminUsername || ! $adminPassword) {
            return;
        }

        $admin = User::query()->firstOrCreate(
            ['email' => $adminEmail],
            [
                'username' => $adminUsername,
                'password' => Hash::make($adminPassword),
                'status' => 'active',
                'email_verified_at' => now(),
            ]
        );

        if (! $admin->hasRole('super_admin')) {
            $admin->assignRole('super_admin');
        }
    }
}
