# Wallet API v1

Base path: `/api/v1`

Auth headers (required on all endpoints):
- `X-API-KEY`
- `X-SIGNATURE`
- `X-TIMESTAMP` (unix seconds)
- `X-NONCE`

Signature payload:
`METHOD + "\n" + PATH + "\n" + RAW_BODY + "\n" + TIMESTAMP + "\n" + NONCE`

HMAC:
`hex(hmac_sha256(payload, api_secret))`

## Endpoints

### `GET /me/balance`
Returns wallet balance and currency.

### `GET /me/transactions`
Paginated ledger entries.

### `POST /transfers`
Body:
```json
{
  "receiver_public_id": "abc123xyz0",
  "amount": 1000,
  "idempotency_key": "uuid",
  "note": "optional",
  "totp_code": "123456",
  "confirm": true
}
```

### `POST /payment-links`
Business users only.

### `GET /payment-links/{code}`
Get payment link details.

### `POST /payment-links/{code}/pay`
Pay payment link.

### `POST /api-tokens/rotate`
Rotate API credentials (requires confirmation and optional TOTP).

### `GET /settings/features`
Fetch global/user feature flags.
