<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Admin - Settings</h2>
            <div class="space-x-2 text-sm">
                <a class="text-sky-700 underline" href="{{ route('admin.users.index') }}">Users</a>
                <a class="text-sky-700 underline" href="{{ route('admin.transactions.index') }}">Transactions</a>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-4">
            @if(session('status'))
                <div class="p-3 rounded bg-green-100 text-green-800 text-sm">{{ session('status') }}</div>
            @endif

            <div class="bg-white rounded-xl shadow p-6">
                <h3 class="font-semibold mb-3">Branding</h3>
                <form method="POST" action="{{ route('admin.settings.branding') }}" class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    @csrf
                    <input name="system_name" value="{{ $systemName }}" placeholder="System Name" class="rounded border-gray-300" required>
                    <input name="copyright" value="{{ $copyright }}" placeholder="Copyright" class="rounded border-gray-300">
                    <label class="text-sm md:col-span-2"><input type="checkbox" name="confirm" value="1" required> confirm</label>
                    <button class="bg-sky-600 text-white rounded px-3 py-2 md:col-span-2">Save Branding</button>
                </form>
            </div>

            <div class="bg-white rounded-xl shadow p-6">
                <h3 class="font-semibold mb-3">Global Feature Toggles</h3>
                <form method="POST" action="{{ route('admin.settings.features') }}" class="space-y-2">
                    @csrf
                    @foreach($featureKeys as $key)
                        <label class="block text-sm"><input type="checkbox" name="feature[{{ $key }}]" value="1" @checked(($globalFlags[$key] ?? true))> {{ $key }}</label>
                    @endforeach
                    <label class="text-sm block"><input type="checkbox" name="confirm" value="1" required> confirm</label>
                    <button class="bg-sky-600 text-white rounded px-3 py-2">Save Features</button>
                </form>
            </div>

            <div class="bg-white rounded-xl shadow p-6">
                <h3 class="font-semibold mb-3">SMTP</h3>
                <form method="POST" action="{{ route('admin.settings.smtp') }}" class="grid grid-cols-1 md:grid-cols-2 gap-3">
                    @csrf
                    <input name="host" value="{{ old('host', $smtp?->host) }}" placeholder="SMTP Host" class="rounded border-gray-300" required>
                    <input name="port" value="{{ old('port', $smtp?->port) }}" placeholder="Port" class="rounded border-gray-300" required>
                    <input name="username" value="{{ old('username', $smtp?->username_enc) }}" placeholder="Username" class="rounded border-gray-300">
                    <input name="password" type="password" placeholder="Password (leave empty to keep)" class="rounded border-gray-300">
                    <select name="encryption" class="rounded border-gray-300">
                        <option value="">None</option>
                        <option value="tls" @selected(($smtp?->encryption)==='tls')>TLS</option>
                        <option value="ssl" @selected(($smtp?->encryption)==='ssl')>SSL</option>
                    </select>
                    <input name="from_email" value="{{ old('from_email', $smtp?->from_email) }}" placeholder="From Email" class="rounded border-gray-300" required>
                    <input name="from_name" value="{{ old('from_name', $smtp?->from_name) }}" placeholder="From Name" class="rounded border-gray-300" required>
                    <label class="text-sm md:col-span-2"><input type="checkbox" name="confirm" value="1" required> confirm</label>
                    <button class="bg-sky-600 text-white rounded px-3 py-2 md:col-span-2">Save SMTP</button>
                </form>
            </div>
        </div>
    </div>
</x-app-layout>
