<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Admin - Transaction Log</h2>
            <div class="space-x-2 text-sm">
                <a class="text-sky-700 underline" href="{{ route('admin.users.index') }}">Users</a>
                <a class="text-sky-700 underline" href="{{ route('admin.settings.index') }}">Settings</a>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8 space-y-4">
            <form class="bg-white p-4 rounded-xl shadow grid grid-cols-1 md:grid-cols-5 gap-2" method="GET">
                <input name="public_id" value="{{ request('public_id') }}" placeholder="Public ID" class="rounded border-gray-300">
                <select name="status" class="rounded border-gray-300">
                    <option value="">Any status</option>
                    <option value="completed" @selected(request('status')==='completed')>completed</option>
                    <option value="pending" @selected(request('status')==='pending')>pending</option>
                    <option value="failed" @selected(request('status')==='failed')>failed</option>
                    <option value="cancelled" @selected(request('status')==='cancelled')>cancelled</option>
                </select>
                <input type="date" name="date_from" value="{{ request('date_from') }}" class="rounded border-gray-300">
                <input type="date" name="date_to" value="{{ request('date_to') }}" class="rounded border-gray-300">
                <button class="bg-sky-600 text-white rounded px-3">Filter</button>
            </form>

            <div class="bg-white rounded-xl shadow p-6 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="border-b text-left">
                            <th class="py-2">Time</th>
                            <th>ID</th>
                            <th>Sender</th>
                            <th>Receiver</th>
                            <th>Amount</th>
                            <th>Status</th>
                            <th>Idempotency</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($transfers as $t)
                            <tr class="border-b">
                                <td class="py-2">{{ $t->created_at }}</td>
                                <td>#{{ $t->id }}</td>
                                <td>{{ $t->sender?->public_id }}</td>
                                <td>{{ $t->receiver?->public_id }}</td>
                                <td>{{ number_format($t->amount / 100, 2) }}</td>
                                <td>{{ $t->status }}</td>
                                <td class="font-mono text-xs">{{ $t->idempotency_key }}</td>
                            </tr>
                        @empty
                            <tr><td colspan="7" class="py-3 text-gray-500">No transactions found.</td></tr>
                        @endforelse
                    </tbody>
                </table>
                <div class="mt-3">{{ $transfers->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
