<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Admin - Users</h2>
            <div class="space-x-2 text-sm">
                <a class="text-sky-700 underline" href="{{ route('admin.transactions.index') }}">Transactions</a>
                <a class="text-sky-700 underline" href="{{ route('admin.settings.index') }}">Settings</a>
            </div>
        </div>
    </x-slot>

    <div class="py-8">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            @if(session('status'))
                <div class="mb-4 p-3 rounded bg-green-100 text-green-800 text-sm">{{ session('status') }}</div>
            @endif

            <div class="bg-white rounded-xl shadow p-6 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="border-b text-left">
                            <th class="py-2">User</th>
                            <th>Public ID</th>
                            <th>Status</th>
                            <th>Wallet Controls</th>
                            <th>Business/API</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($users as $u)
                            @php
                                $apiFlag = $u->featureFlags->firstWhere('feature_key', 'api.access');
                            @endphp
                            <tr class="border-b align-top">
                                <td class="py-2">{{ $u->username }}<br>{{ $u->email }}</td>
                                <td>{{ $u->public_id }}</td>
                                <td>
                                    <form method="POST" action="{{ route('admin.users.update', $u) }}" class="space-y-1">
                                        @csrf
                                        <input type="hidden" name="_method" value="PATCH">
                                        <select name="status" class="rounded border-gray-300 text-xs w-full">
                                            <option value="active" @selected($u->status==='active')>active</option>
                                            <option value="blocked" @selected($u->status==='blocked')>blocked</option>
                                            <option value="suspended" @selected($u->status==='suspended')>suspended</option>
                                        </select>
                                        <input name="blocked_reason" value="{{ $u->blocked_reason }}" placeholder="block reason" class="rounded border-gray-300 text-xs w-full" />
                                </td>
                                <td>
                                        <input name="adjust_balance" placeholder="+/- cents" class="rounded border-gray-300 text-xs w-full" />
                                        <input name="daily_send_limit" value="{{ $u->wallet?->daily_send_limit }}" placeholder="daily limit" class="rounded border-gray-300 text-xs w-full" />
                                        <input name="monthly_send_limit" value="{{ $u->wallet?->monthly_send_limit }}" placeholder="monthly limit" class="rounded border-gray-300 text-xs w-full" />
                                        <input name="velocity_limit_per_minute" value="{{ $u->wallet?->velocity_limit_per_minute }}" placeholder="velocity/min" class="rounded border-gray-300 text-xs w-full" />
                                        <label class="block text-xs"><input type="checkbox" name="can_send" value="1" @checked($u->wallet?->can_send)> can_send</label>
                                        <label class="block text-xs"><input type="checkbox" name="can_receive" value="1" @checked($u->wallet?->can_receive)> can_receive</label>
                                </td>
                                <td>
                                        <input name="business_name" value="{{ $u->businessProfile?->business_name }}" placeholder="business name" class="rounded border-gray-300 text-xs w-full" />
                                        <label class="block text-xs"><input type="checkbox" name="is_business_enabled" value="1" @checked($u->businessProfile?->is_business_enabled)> business enabled</label>
                                        <label class="block text-xs"><input type="checkbox" name="can_api" value="1" @checked(!is_null($apiFlag) ? $apiFlag->is_enabled : true)> api access</label>
                                        <input name="reason" placeholder="admin reason" class="rounded border-gray-300 text-xs w-full" />
                                        <label class="block text-xs"><input type="checkbox" name="confirm" value="1" required> confirm</label>
                                        <button class="bg-sky-600 text-white rounded px-2 py-1 text-xs">Save</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <div class="mt-3">{{ $users->links() }}</div>
            </div>
        </div>
    </div>
</x-app-layout>
