<x-guest-layout>
    <x-auth-session-status class="mb-4" :status="session('status')" />

    <form method="POST" action="{{ route('login') }}" class="space-y-4">
        @csrf

        <div>
            <x-input-label for="login" value="Email or Username" />
            <x-text-input id="login" class="block mt-1 w-full" type="text" name="login" :value="old('login')" required autofocus />
            <x-input-error :messages="$errors->get('login')" class="mt-2" />
        </div>

        <div>
            <x-input-label for="password" :value="__('Password')" />
            <x-text-input id="password" class="block mt-1 w-full" type="password" name="password" required autocomplete="current-password" />
            <x-input-error :messages="$errors->get('password')" class="mt-2" />
        </div>

        <div class="flex items-center justify-between">
            <label for="remember_me" class="inline-flex items-center">
                <input id="remember_me" type="checkbox" class="rounded border-gray-300 text-sky-600 shadow-sm" name="remember">
                <span class="ms-2 text-sm text-gray-600">Remember me</span>
            </label>

            @if (Route::has('password.request'))
                <a class="underline text-sm text-gray-600 hover:text-gray-900" href="{{ route('password.request') }}">Forgot password?</a>
            @endif
        </div>

        <x-primary-button class="w-full justify-center">Log in</x-primary-button>
    </form>

    <div class="my-6 border-t pt-4">
        <p class="text-sm text-gray-600 mb-2">Or sign in with Telegram</p>
        <script async src="https://telegram.org/js/telegram-widget.js?22"
            data-telegram-login="{{ config('services.telegram.bot_username') }}"
            data-size="large"
            data-auth-url="{{ route('telegram.callback') }}"
            data-request-access="write"></script>
        <x-input-error :messages="$errors->get('telegram')" class="mt-2" />
    </div>
</x-guest-layout>
