<?php

declare(strict_types=1);

namespace Doctrine\Inflector\Rules\Portuguese;

use Doctrine\Inflector\Rules\Pattern;
use Doctrine\Inflector\Rules\Substitution;
use Doctrine\Inflector\Rules\Transformation;
use Doctrine\Inflector\Rules\Word;

class Inflectible
{
    /** @return Transformation[] */
    public static function getSingular(): iterable
    {
        yield new Transformation(new Pattern('/^(g|)ases$/i'), '\1ÃƒÂ¡s');
        yield new Transformation(new Pattern('/(japon|escoc|ingl|dinamarqu|fregu|portugu)eses$/i'), '\1ÃƒÂªs');
        yield new Transformation(new Pattern('/(ae|ao|oe)s$/'), 'ao');
        yield new Transformation(new Pattern('/(ÃƒÂ£e|ÃƒÂ£o|ÃƒÂµe)s$/'), 'ÃƒÂ£o');
        yield new Transformation(new Pattern('/^(.*[^s]s)es$/i'), '\1');
        yield new Transformation(new Pattern('/sses$/i'), 'sse');
        yield new Transformation(new Pattern('/ns$/i'), 'm');
        yield new Transformation(new Pattern('/(r|t|f|v)is$/i'), '\1il');
        yield new Transformation(new Pattern('/uis$/i'), 'ul');
        yield new Transformation(new Pattern('/ois$/i'), 'ol');
        yield new Transformation(new Pattern('/eis$/i'), 'ei');
        yield new Transformation(new Pattern('/ÃƒÂ©is$/i'), 'el');
        yield new Transformation(new Pattern('/([^p])ais$/i'), '\1al');
        yield new Transformation(new Pattern('/(r|z)es$/i'), '\1');
        yield new Transformation(new Pattern('/^(ÃƒÂ¡|gÃƒÂ¡)s$/i'), '\1s');
        yield new Transformation(new Pattern('/([^ÃƒÂª])s$/i'), '\1');
    }

    /** @return Transformation[] */
    public static function getPlural(): iterable
    {
        yield new Transformation(new Pattern('/^(alem|c|p)ao$/i'), '\1aes');
        yield new Transformation(new Pattern('/^(irm|m)ao$/i'), '\1aos');
        yield new Transformation(new Pattern('/ao$/i'), 'oes');
        yield new Transformation(new Pattern('/^(alem|c|p)ÃƒÂ£o$/i'), '\1ÃƒÂ£es');
        yield new Transformation(new Pattern('/^(irm|m)ÃƒÂ£o$/i'), '\1ÃƒÂ£os');
        yield new Transformation(new Pattern('/ÃƒÂ£o$/i'), 'ÃƒÂµes');
        yield new Transformation(new Pattern('/^(|g)ÃƒÂ¡s$/i'), '\1ases');
        yield new Transformation(new Pattern('/^(japon|escoc|ingl|dinamarqu|fregu|portugu)ÃƒÂªs$/i'), '\1eses');
        yield new Transformation(new Pattern('/m$/i'), 'ns');
        yield new Transformation(new Pattern('/([^aeou])il$/i'), '\1is');
        yield new Transformation(new Pattern('/ul$/i'), 'uis');
        yield new Transformation(new Pattern('/ol$/i'), 'ois');
        yield new Transformation(new Pattern('/el$/i'), 'eis');
        yield new Transformation(new Pattern('/al$/i'), 'ais');
        yield new Transformation(new Pattern('/(z|r)$/i'), '\1es');
        yield new Transformation(new Pattern('/(s)$/i'), '\1');
        yield new Transformation(new Pattern('/$/'), 's');
    }

    /** @return Substitution[] */
    public static function getIrregular(): iterable
    {
        yield new Substitution(new Word('abdomen'), new Word('abdomens'));
        yield new Substitution(new Word('alemÃƒÂ£o'), new Word('alemÃƒÂ£es'));
        yield new Substitution(new Word('artesÃƒÂ£'), new Word('artesÃƒÂ£os'));
        yield new Substitution(new Word('ÃƒÂ¡lcool'), new Word('ÃƒÂ¡lcoois'));
        yield new Substitution(new Word('ÃƒÂ¡rvore'), new Word('ÃƒÂ¡rvores'));
        yield new Substitution(new Word('bencÃƒÂ£o'), new Word('bencÃƒÂ£os'));
        yield new Substitution(new Word('cÃƒÂ£o'), new Word('cÃƒÂ£es'));
        yield new Substitution(new Word('campus'), new Word('campi'));
        yield new Substitution(new Word('cadÃƒÂ¡ver'), new Word('cadÃƒÂ¡veres'));
        yield new Substitution(new Word('capelÃƒÂ£o'), new Word('capelÃƒÂ£es'));
        yield new Substitution(new Word('capitÃƒÂ£o'), new Word('capitÃƒÂ£es'));
        yield new Substitution(new Word('chÃƒÂ£o'), new Word('chÃƒÂ£os'));
        yield new Substitution(new Word('charlatÃƒÂ£o'), new Word('charlatÃƒÂ£es'));
        yield new Substitution(new Word('cidadÃƒÂ£o'), new Word('cidadÃƒÂ£os'));
        yield new Substitution(new Word('consul'), new Word('consules'));
        yield new Substitution(new Word('cristÃƒÂ£o'), new Word('cristÃƒÂ£os'));
        yield new Substitution(new Word('difÃƒÂ­cil'), new Word('difÃƒÂ­ceis'));
        yield new Substitution(new Word('email'), new Word('emails'));
        yield new Substitution(new Word('escrivÃƒÂ£o'), new Word('escrivÃƒÂ£es'));
        yield new Substitution(new Word('fÃƒÂ³ssil'), new Word('fÃƒÂ³sseis'));
        yield new Substitution(new Word('gÃƒÂ¡s'), new Word('gases'));
        yield new Substitution(new Word('germens'), new Word('germen'));
        yield new Substitution(new Word('grÃƒÂ£o'), new Word('grÃƒÂ£os'));
        yield new Substitution(new Word('hÃƒÂ­fen'), new Word('hÃƒÂ­fens'));
        yield new Substitution(new Word('irmÃƒÂ£o'), new Word('irmÃƒÂ£os'));
        yield new Substitution(new Word('liquens'), new Word('liquen'));
        yield new Substitution(new Word('mal'), new Word('males'));
        yield new Substitution(new Word('mÃƒÂ£o'), new Word('mÃƒÂ£os'));
        yield new Substitution(new Word('orfÃƒÂ£o'), new Word('orfÃƒÂ£os'));
        yield new Substitution(new Word('paÃƒÂ­s'), new Word('paÃƒÂ­ses'));
        yield new Substitution(new Word('pai'), new Word('pais'));
        yield new Substitution(new Word('pÃƒÂ£o'), new Word('pÃƒÂ£es'));
        yield new Substitution(new Word('projÃƒÂ©til'), new Word('projÃƒÂ©teis'));
        yield new Substitution(new Word('rÃƒÂ©ptil'), new Word('rÃƒÂ©pteis'));
        yield new Substitution(new Word('sacristÃƒÂ£o'), new Word('sacristÃƒÂ£es'));
        yield new Substitution(new Word('sotÃƒÂ£o'), new Word('sotÃƒÂ£os'));
        yield new Substitution(new Word('tabeliÃƒÂ£o'), new Word('tabeliÃƒÂ£es'));
    }
}
