<?php

declare(strict_types=1);

namespace Doctrine\Inflector\Rules\Portuguese;

use Doctrine\Inflector\Rules\Pattern;

final class Uninflected
{
    /** @return Pattern[] */
    public static function getSingular(): iterable
    {
        yield from self::getDefault();
    }

    /** @return Pattern[] */
    public static function getPlural(): iterable
    {
        yield from self::getDefault();
    }

    /** @return Pattern[] */
    private static function getDefault(): iterable
    {
        yield new Pattern('tÃƒÂ³rax');
        yield new Pattern('tÃƒÂªnis');
        yield new Pattern('ÃƒÂ´nibus');
        yield new Pattern('lÃƒÂ¡pis');
        yield new Pattern('fÃƒÂªnix');
    }
}
