<?php

declare(strict_types=1);

namespace Doctrine\Inflector\Rules\Spanish;

use Doctrine\Inflector\Rules\Pattern;
use Doctrine\Inflector\Rules\Substitution;
use Doctrine\Inflector\Rules\Transformation;
use Doctrine\Inflector\Rules\Word;

class Inflectible
{
    /** @return Transformation[] */
    public static function getSingular(): iterable
    {
        yield new Transformation(new Pattern('/ereses$/'), 'erÃƒÂ©s');
        yield new Transformation(new Pattern('/iones$/'), 'iÃƒÂ³n');
        yield new Transformation(new Pattern('/ces$/'), 'z');
        yield new Transformation(new Pattern('/es$/'), '');
        yield new Transformation(new Pattern('/s$/'), '');
    }

    /** @return Transformation[] */
    public static function getPlural(): iterable
    {
        yield new Transformation(new Pattern('/ÃƒÂº([sn])$/i'), 'u\1es');
        yield new Transformation(new Pattern('/ÃƒÂ³([sn])$/i'), 'o\1es');
        yield new Transformation(new Pattern('/ÃƒÂ­([sn])$/i'), 'i\1es');
        yield new Transformation(new Pattern('/ÃƒÂ©([sn])$/i'), 'e\1es');
        yield new Transformation(new Pattern('/ÃƒÂ¡([sn])$/i'), 'a\1es');
        yield new Transformation(new Pattern('/z$/i'), 'ces');
        yield new Transformation(new Pattern('/([aeiou]s)$/i'), '\1');
        yield new Transformation(new Pattern('/([^aeÃƒÂ©iou])$/i'), '\1es');
        yield new Transformation(new Pattern('/$/'), 's');
    }

    /** @return Substitution[] */
    public static function getIrregular(): iterable
    {
        yield new Substitution(new Word('el'), new Word('los'));
        yield new Substitution(new Word('papÃƒÂ¡'), new Word('papÃƒÂ¡s'));
        yield new Substitution(new Word('mamÃƒÂ¡'), new Word('mamÃƒÂ¡s'));
        yield new Substitution(new Word('sofÃƒÂ¡'), new Word('sofÃƒÂ¡s'));
        yield new Substitution(new Word('mes'), new Word('meses'));
    }
}
