<?php

namespace Laravel\Prompts\Themes\Default\Concerns;

use Laravel\Prompts\Prompt;

trait DrawsBoxes
{
    use InteractsWithStrings;

    protected int $minWidth = 60;

    /**
     * Draw a box.
     *
     * @return $this
     */
    protected function box(
        string $title,
        string $body,
        string $footer = '',
        string $color = 'gray',
        string $info = '',
    ): self {
        $this->minWidth = min($this->minWidth, Prompt::terminal()->cols() - 6);

        $bodyLines = explode(PHP_EOL, $body);
        $footerLines = array_filter(explode(PHP_EOL, $footer));

        $width = $this->longest(array_merge($bodyLines, $footerLines, [$title]));

        $titleLength = mb_strwidth($this->stripEscapeSequences($title));
        $titleLabel = $titleLength > 0 ? " {$title} " : '';
        $topBorder = str_repeat('Ã¢â€â‚¬', $width - $titleLength + ($titleLength > 0 ? 0 : 2));

        $this->line("{$this->{$color}(' Ã¢â€Å’')}{$titleLabel}{$this->{$color}($topBorder.'Ã¢â€Â')}");

        foreach ($bodyLines as $line) {
            $this->line("{$this->{$color}(' Ã¢â€â€š')} {$this->pad($line, $width)} {$this->{$color}('Ã¢â€â€š')}");
        }

        if (count($footerLines) > 0) {
            $this->line($this->{$color}(' Ã¢â€Å“'.str_repeat('Ã¢â€â‚¬', $width + 2).'Ã¢â€Â¤'));

            foreach ($footerLines as $line) {
                $this->line("{$this->{$color}(' Ã¢â€â€š')} {$this->pad($line, $width)} {$this->{$color}('Ã¢â€â€š')}");
            }
        }

        $this->line($this->{$color}(' Ã¢â€â€'.str_repeat(
            'Ã¢â€â‚¬', $info ? ($width - mb_strwidth($this->stripEscapeSequences($info))) : ($width + 2)
        ).($info ? " {$info} " : '').'Ã¢â€Ëœ'));

        return $this;
    }
}
