<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Josh Soref
 * - Kunal Marwaha
 * - FranÃƒÂ§ois B
 * - JD Isaacks
 * - Orxan
 * - Ã…Å¾Ã‰â„¢hriyar Ã„Â°manov
 * - Baran Ã…Å¾engÃƒÂ¼l
 * - Novruz Rahimov
 */
return [
    'year' => ':count il',
    'a_year' => '{1}bir il|[-Inf,Inf]:count il',
    'y' => ':count il',
    'month' => ':count ay',
    'a_month' => '{1}bir ay|[-Inf,Inf]:count ay',
    'm' => ':count ay',
    'week' => ':count hÃ‰â„¢ftÃ‰â„¢',
    'a_week' => '{1}bir hÃ‰â„¢ftÃ‰â„¢|[-Inf,Inf]:count hÃ‰â„¢ftÃ‰â„¢',
    'w' => ':count h.',
    'day' => ':count gÃƒÂ¼n',
    'a_day' => '{1}bir gÃƒÂ¼n|[-Inf,Inf]:count gÃƒÂ¼n',
    'd' => ':count g.',
    'hour' => ':count saat',
    'a_hour' => '{1}bir saat|[-Inf,Inf]:count saat',
    'h' => ':count s.',
    'minute' => ':count dÃ‰â„¢qiqÃ‰â„¢',
    'a_minute' => '{1}bir dÃ‰â„¢qiqÃ‰â„¢|[-Inf,Inf]:count dÃ‰â„¢qiqÃ‰â„¢',
    'min' => ':count d.',
    'second' => ':count saniyÃ‰â„¢',
    'a_second' => '{1}birneÃƒÂ§Ã‰â„¢ saniyÃ‰â„¢|[-Inf,Inf]:count saniyÃ‰â„¢',
    's' => ':count san.',
    'ago' => ':time Ã‰â„¢vvÃ‰â„¢l',
    'from_now' => ':time sonra',
    'after' => ':time sonra',
    'before' => ':time Ã‰â„¢vvÃ‰â„¢l',
    'diff_now' => 'indi',
    'diff_today' => 'bugÃƒÂ¼n',
    'diff_today_regexp' => 'bugÃƒÂ¼n(?:\\s+saat)?',
    'diff_yesterday' => 'dÃƒÂ¼nÃ‰â„¢n',
    'diff_tomorrow' => 'sabah',
    'diff_tomorrow_regexp' => 'sabah(?:\\s+saat)?',
    'diff_before_yesterday' => 'sraÃ„Å¸agÃƒÂ¼n',
    'diff_after_tomorrow' => 'birisi gÃƒÂ¼n',
    'period_recurrences' => ':count dÃ‰â„¢fÃ‰â„¢dÃ‰â„¢n bir',
    'period_interval' => 'hÃ‰â„¢r :interval',
    'period_start_date' => ':date tarixindÃ‰â„¢n baÃ…Å¸layaraq',
    'period_end_date' => ':date tarixinÃ‰â„¢dÃ‰â„¢k',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[bugÃƒÂ¼n saat] LT',
        'nextDay' => '[sabah saat] LT',
        'nextWeek' => '[gÃ‰â„¢lÃ‰â„¢n hÃ‰â„¢ftÃ‰â„¢] dddd [saat] LT',
        'lastDay' => '[dÃƒÂ¼nÃ‰â„¢n] LT',
        'lastWeek' => '[keÃƒÂ§Ã‰â„¢n hÃ‰â„¢ftÃ‰â„¢] dddd [saat] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number) {
        if ($number === 0) { // special case for zero
            return "$number-Ã„Â±ncÃ„Â±";
        }

        static $suffixes = [
            1 => '-inci',
            5 => '-inci',
            8 => '-inci',
            70 => '-inci',
            80 => '-inci',
            2 => '-nci',
            7 => '-nci',
            20 => '-nci',
            50 => '-nci',
            3 => '-ÃƒÂ¼ncÃƒÂ¼',
            4 => '-ÃƒÂ¼ncÃƒÂ¼',
            100 => '-ÃƒÂ¼ncÃƒÂ¼',
            6 => '-ncÃ„Â±',
            9 => '-uncu',
            10 => '-uncu',
            30 => '-uncu',
            60 => '-Ã„Â±ncÃ„Â±',
            90 => '-Ã„Â±ncÃ„Â±',
        ];

        $lastDigit = $number % 10;

        return $number.($suffixes[$lastDigit] ?? $suffixes[$number % 100 - $lastDigit] ?? $suffixes[$number >= 100 ? 100 : -1] ?? '');
    },
    'meridiem' => static function ($hour) {
        if ($hour < 4) {
            return 'gecÃ‰â„¢';
        }
        if ($hour < 12) {
            return 'sÃ‰â„¢hÃ‰â„¢r';
        }
        if ($hour < 17) {
            return 'gÃƒÂ¼ndÃƒÂ¼z';
        }

        return 'axÃ…Å¸am';
    },
    'months' => ['yanvar', 'fevral', 'mart', 'aprel', 'may', 'iyun', 'iyul', 'avqust', 'sentyabr', 'oktyabr', 'noyabr', 'dekabr'],
    'months_short' => ['yan', 'fev', 'mar', 'apr', 'may', 'iyn', 'iyl', 'avq', 'sen', 'okt', 'noy', 'dek'],
    'weekdays' => ['bazar', 'bazar ertÃ‰â„¢si', 'ÃƒÂ§Ã‰â„¢rÃ…Å¸Ã‰â„¢nbÃ‰â„¢ axÃ…Å¸amÃ„Â±', 'ÃƒÂ§Ã‰â„¢rÃ…Å¸Ã‰â„¢nbÃ‰â„¢', 'cÃƒÂ¼mÃ‰â„¢ axÃ…Å¸amÃ„Â±', 'cÃƒÂ¼mÃ‰â„¢', 'Ã…Å¸Ã‰â„¢nbÃ‰â„¢'],
    'weekdays_short' => ['baz', 'bze', 'ÃƒÂ§ax', 'ÃƒÂ§Ã‰â„¢r', 'cax', 'cÃƒÂ¼m', 'Ã…Å¸Ã‰â„¢n'],
    'weekdays_min' => ['bz', 'be', 'ÃƒÂ§a', 'ÃƒÂ§Ã‰â„¢', 'ca', 'cÃƒÂ¼', 'Ã…Å¸Ã‰â„¢'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' vÃ‰â„¢ '],
];
