<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

$bengaliNumbers = ['Ã Â§Â¦', 'Ã Â§Â§', 'Ã Â§Â¨', 'Ã Â§Â©', 'Ã Â§Âª', 'Ã Â§Â«', 'Ã Â§Â¬', 'Ã Â§Â­', 'Ã Â§Â®', 'Ã Â§Â¯'];

/*
 * Authors:
 * - Josh Soref
 * - Shakib Hossain
 * - Raju
 * - Aniruddha Adhikary
 * - JD Isaacks
 * - Saiful Islam
 * - Faisal Islam
 * - Hayatunnabi Nabil
 */
return [
    'year' => ':count Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°',
    'a_year' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°|:count Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°',
    'y' => 'Ã Â§Â§ Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°|:count Ã Â¦Â¬Ã Â¦â€ºÃ Â¦Â°',
    'month' => ':count Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸',
    'a_month' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸|:count Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸',
    'm' => 'Ã Â§Â§ Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸|:count Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â¸',
    'week' => ':count Ã Â¦Â¸Ã Â¦ÂªÃ Â§ÂÃ Â¦Â¤Ã Â¦Â¾Ã Â¦Â¹',
    'a_week' => 'Ã Â§Â§ Ã Â¦Â¸Ã Â¦ÂªÃ Â§ÂÃ Â¦Â¤Ã Â¦Â¾Ã Â¦Â¹|:count Ã Â¦Â¸Ã Â¦ÂªÃ Â§ÂÃ Â¦Â¤Ã Â¦Â¾Ã Â¦Â¹',
    'w' => 'Ã Â§Â§ Ã Â¦Â¸Ã Â¦ÂªÃ Â§ÂÃ Â¦Â¤Ã Â¦Â¾Ã Â¦Â¹|:count Ã Â¦Â¸Ã Â¦ÂªÃ Â§ÂÃ Â¦Â¤Ã Â¦Â¾Ã Â¦Â¹',
    'day' => ':count Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨',
    'a_day' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨|:count Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨',
    'd' => 'Ã Â§Â§ Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨|:count Ã Â¦Â¦Ã Â¦Â¿Ã Â¦Â¨',
    'hour' => ':count Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾',
    'a_hour' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾|:count Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾',
    'h' => 'Ã Â§Â§ Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾|:count Ã Â¦ËœÃ Â¦Â¨Ã Â§ÂÃ Â¦Å¸Ã Â¦Â¾',
    'minute' => ':count Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸',
    'a_minute' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸|:count Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸',
    'min' => 'Ã Â§Â§ Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸|:count Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Å¸',
    'second' => ':count Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'a_second' => 'Ã Â¦â€¢Ã Â§Å¸Ã Â§â€¡Ã Â¦â€¢ Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡|:count Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    's' => 'Ã Â§Â§ Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡|:count Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'millisecond' => ':count Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â²Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'a_millisecond' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â²Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡|:count Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â²Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'ms' => 'Ã Â§Â§ Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â²Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡|:count Ã Â¦Â®Ã Â¦Â¿Ã Â¦Â²Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'microsecond' => ':count Ã Â¦Â®Ã Â¦Â¾Ã Â¦â€¡Ã Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â§â€¹Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'a_microsecond' => 'Ã Â¦ÂÃ Â¦â€¢ Ã Â¦Â®Ã Â¦Â¾Ã Â¦â€¡Ã Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â§â€¹Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡|:count Ã Â¦Â®Ã Â¦Â¾Ã Â¦â€¡Ã Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â§â€¹Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'Ã‚Âµs' => 'Ã Â§Â§ Ã Â¦Â®Ã Â¦Â¾Ã Â¦â€¡Ã Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â§â€¹Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡|:count Ã Â¦Â®Ã Â¦Â¾Ã Â¦â€¡Ã Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â§â€¹Ã Â¦Â¸Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¡',
    'ago' => ':time Ã Â¦â€ Ã Â¦â€”Ã Â§â€¡',
    'from_now' => ':time Ã Â¦ÂªÃ Â¦Â°Ã Â§â€¡',
    'after' => ':time Ã Â¦ÂªÃ Â¦Â°Ã Â§â€¡',
    'before' => ':time Ã Â¦â€ Ã Â¦â€”Ã Â§â€¡',
    'diff_now' => 'Ã Â¦ÂÃ Â¦â€“Ã Â¦Â¨',
    'diff_today' => 'Ã Â¦â€ Ã Â¦Å“',
    'diff_yesterday' => 'Ã Â¦â€”Ã Â¦Â¤Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²',
    'diff_tomorrow' => 'Ã Â¦â€ Ã Â¦â€”Ã Â¦Â¾Ã Â¦Â®Ã Â§â‚¬Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²',
    'diff_before_yesterday' => 'Ã Â¦â€”Ã Â¦Â¤ Ã Â¦ÂªÃ Â¦Â°Ã Â¦Â¶Ã Â§Â',
    'diff_after_tomorrow' => 'Ã Â¦â€ Ã Â¦â€”Ã Â¦Â¾Ã Â¦Â®Ã Â§â‚¬ Ã Â¦ÂªÃ Â¦Â°Ã Â¦Â¶Ã Â§Â',
    'period_recurrences' => ':count Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°|:count Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°',
    'period_interval' => 'Ã Â¦ÂªÃ Â§ÂÃ Â¦Â°Ã Â¦Â¤Ã Â¦Â¿ :interval',
    'period_start_date' => ':date Ã Â¦Â¥Ã Â§â€¡Ã Â¦â€¢Ã Â§â€¡',
    'period_end_date' => ':date Ã Â¦ÂªÃ Â¦Â°Ã Â§ÂÃ Â¦Â¯Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¤',
    'formats' => [
        'LT' => 'A Oh:Om Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸',
        'LTS' => 'A Oh:Om:Os Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸',
        'L' => 'OD/OM/OY',
        'LL' => 'OD MMMM OY',
        'LLL' => 'OD MMMM OY, A Oh:Om Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸',
        'LLLL' => 'dddd, OD MMMM OY, A Oh:Om Ã Â¦Â¸Ã Â¦Â®Ã Â§Å¸',
    ],
    'calendar' => [
        'sameDay' => '[Ã Â¦â€ Ã Â¦Å“] LT',
        'nextDay' => '[Ã Â¦â€ Ã Â¦â€”Ã Â¦Â¾Ã Â¦Â®Ã Â§â‚¬Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²] LT',
        'nextWeek' => 'dddd, LT',
        'lastDay' => '[Ã Â¦â€”Ã Â¦Â¤Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²] LT',
        'lastWeek' => '[Ã Â¦â€”Ã Â¦Â¤] dddd, LT',
        'sameElse' => 'L',
    ],
    'meridiem' => static function ($hour) {
        if ($hour < 4) {
            return 'Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤';
        }
        if ($hour < 10) {
            return 'Ã Â¦Â¸Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²';
        }
        if ($hour < 17) {
            return 'Ã Â¦Â¦Ã Â§ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°';
        }
        if ($hour < 20) {
            return 'Ã Â¦Â¬Ã Â¦Â¿Ã Â¦â€¢Ã Â¦Â¾Ã Â¦Â²';
        }

        return 'Ã Â¦Â°Ã Â¦Â¾Ã Â¦Â¤';
    },
    'months' => ['Ã Â¦Å“Ã Â¦Â¾Ã Â¦Â¨Ã Â§ÂÃ Â§Å¸Ã Â¦Â¾Ã Â¦Â°Ã Â§â‚¬', 'Ã Â¦Â«Ã Â§â€¡Ã Â¦Â¬Ã Â§ÂÃ Â¦Â°Ã Â§ÂÃ Â§Å¸Ã Â¦Â¾Ã Â¦Â°Ã Â¦Â¿', 'Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â°Ã Â§ÂÃ Â¦Å¡', 'Ã Â¦ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°Ã Â¦Â¿Ã Â¦Â²', 'Ã Â¦Â®Ã Â§â€¡', 'Ã Â¦Å“Ã Â§ÂÃ Â¦Â¨', 'Ã Â¦Å“Ã Â§ÂÃ Â¦Â²Ã Â¦Â¾Ã Â¦â€¡', 'Ã Â¦â€ Ã Â¦â€”Ã Â¦Â¸Ã Â§ÂÃ Â¦Å¸', 'Ã Â¦Â¸Ã Â§â€¡Ã Â¦ÂªÃ Â§ÂÃ Â¦Å¸Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°', 'Ã Â¦â€¦Ã Â¦â€¢Ã Â§ÂÃ Â¦Å¸Ã Â§â€¹Ã Â¦Â¬Ã Â¦Â°', 'Ã Â¦Â¨Ã Â¦Â­Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°', 'Ã Â¦Â¡Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°'],
    'months_short' => ['Ã Â¦Å“Ã Â¦Â¾Ã Â¦Â¨Ã Â§Â', 'Ã Â¦Â«Ã Â§â€¡Ã Â¦Â¬', 'Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â°Ã Â§ÂÃ Â¦Å¡', 'Ã Â¦ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°', 'Ã Â¦Â®Ã Â§â€¡', 'Ã Â¦Å“Ã Â§ÂÃ Â¦Â¨', 'Ã Â¦Å“Ã Â§ÂÃ Â¦Â²', 'Ã Â¦â€ Ã Â¦â€”', 'Ã Â¦Â¸Ã Â§â€¡Ã Â¦ÂªÃ Â§ÂÃ Â¦Å¸', 'Ã Â¦â€¦Ã Â¦â€¢Ã Â§ÂÃ Â¦Å¸Ã Â§â€¹', 'Ã Â¦Â¨Ã Â¦Â­Ã Â§â€¡', 'Ã Â¦Â¡Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡'],
    'weekdays' => ['Ã Â¦Â°Ã Â¦Â¬Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¸Ã Â§â€¹Ã Â¦Â®Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”Ã Â¦Â²Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¬Ã Â§ÂÃ Â¦Â§Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¬Ã Â§Æ’Ã Â¦Â¹Ã Â¦Â¸Ã Â§ÂÃ Â¦ÂªÃ Â¦Â¤Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¶Ã Â§ÂÃ Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°'],
    'weekdays_short' => ['Ã Â¦Â°Ã Â¦Â¬Ã Â¦Â¿', 'Ã Â¦Â¸Ã Â§â€¹Ã Â¦Â®', 'Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”Ã Â¦Â²', 'Ã Â¦Â¬Ã Â§ÂÃ Â¦Â§', 'Ã Â¦Â¬Ã Â§Æ’Ã Â¦Â¹Ã Â¦Â¸Ã Â§ÂÃ Â¦ÂªÃ Â¦Â¤Ã Â¦Â¿', 'Ã Â¦Â¶Ã Â§ÂÃ Â¦â€¢Ã Â§ÂÃ Â¦Â°', 'Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿'],
    'weekdays_min' => ['Ã Â¦Â°Ã Â¦Â¬Ã Â¦Â¿', 'Ã Â¦Â¸Ã Â§â€¹Ã Â¦Â®', 'Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”', 'Ã Â¦Â¬Ã Â§ÂÃ Â¦Â§', 'Ã Â¦Â¬Ã Â§Æ’Ã Â¦Â¹Ã Â¦Æ’', 'Ã Â¦Â¶Ã Â§ÂÃ Â¦â€¢Ã Â§ÂÃ Â¦Â°', 'Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿'],
    'ordinal' => static function ($number) use ($bengaliNumbers) {
        // Convert to Bengali numerals
        $bengaliNumber = str_replace(
            ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'],
            $bengaliNumbers,
            (string) $number
        );

        // Apply Bengali ordinal rules
        $lastDigit = $number % 10;
        $lastTwoDigits = $number % 100;

        // Special cases for teens (11-19) always use Ã Â¦Â¤Ã Â¦Â®
        if ($lastTwoDigits >= 11 && $lastTwoDigits <= 19) {
            return $bengaliNumber.'Ã Â¦Â¤Ã Â¦Â®';
        }

        // For numbers 1-10, use specific rules
        if ($number <= 10) {
            switch ($number) {
                case 1:
                case 5:
                case 7:
                case 8:
                case 9:
                case 10:
                    return $bengaliNumber.'Ã Â¦Â®';
                case 2:
                case 3:
                    return $bengaliNumber.'Ã Â¦Â¯Ã Â¦Â¼';
                case 4:
                    return $bengaliNumber.'Ã Â¦Â°Ã Â§ÂÃ Â¦Â¥';
                case 6:
                    return $bengaliNumber.'Ã Â¦Â·Ã Â§ÂÃ Â¦Â ';
                default:
                    return $bengaliNumber.'Ã Â¦Â¤Ã Â¦Â®';
            }
        }

        // For numbers > 20, all use Ã Â¦Â¤Ã Â¦Â®
        return $bengaliNumber.'Ã Â¦Â¤Ã Â¦Â®';
    },
    'list' => [', ', ' Ã Â¦ÂÃ Â¦Â¬Ã Â¦â€š '],
    'first_day_of_week' => 0,
    'day_of_first_week_of_year' => 1,
    'weekdays_standalone' => ['Ã Â¦Â°Ã Â¦Â¬Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¸Ã Â§â€¹Ã Â¦Â®Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â®Ã Â¦â„¢Ã Â§ÂÃ Â¦â€”Ã Â¦Â²Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¬Ã Â§ÂÃ Â¦Â§Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¬Ã Â§Æ’Ã Â¦Â¹Ã Â¦Â·Ã Â§ÂÃ Â¦ÂªÃ Â¦Â¤Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¶Ã Â§ÂÃ Â¦â€¢Ã Â§ÂÃ Â¦Â°Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°', 'Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿Ã Â¦Â¬Ã Â¦Â¾Ã Â¦Â°'],
    'weekdays_min_standalone' => ['Ã Â¦Â°Ã Â¦Æ’', 'Ã Â¦Â¸Ã Â§â€¹Ã Â¦Æ’', 'Ã Â¦Â®Ã Â¦Æ’', 'Ã Â¦Â¬Ã Â§ÂÃ Â¦Æ’', 'Ã Â¦Â¬Ã Â§Æ’Ã Â¦Æ’', 'Ã Â¦Â¶Ã Â§ÂÃ Â¦Æ’', 'Ã Â¦Â¶Ã Â¦Â¨Ã Â¦Â¿'],
    'months_short_standalone' => ['Ã Â¦Å“Ã Â¦Â¾Ã Â¦Â¨Ã Â§ÂÃ Â¦Â¯Ã Â¦Â¼Ã Â¦Â¾Ã Â¦Â°Ã Â§â‚¬', 'Ã Â¦Â«Ã Â§â€¡Ã Â¦Â¬Ã Â§ÂÃ Â¦Â°Ã Â§ÂÃ Â¦Â¯Ã Â¦Â¼Ã Â¦Â¾Ã Â¦Â°Ã Â§â‚¬', 'Ã Â¦Â®Ã Â¦Â¾Ã Â¦Â°Ã Â§ÂÃ Â¦Å¡', 'Ã Â¦ÂÃ Â¦ÂªÃ Â§ÂÃ Â¦Â°Ã Â¦Â¿Ã Â¦Â²', 'Ã Â¦Â®Ã Â§â€¡', 'Ã Â¦Å“Ã Â§ÂÃ Â¦Â¨', 'Ã Â¦Å“Ã Â§ÂÃ Â¦Â²Ã Â¦Â¾Ã Â¦â€¡', 'Ã Â¦â€ Ã Â¦â€”Ã Â¦Â¸Ã Â§ÂÃ Â¦Å¸', 'Ã Â¦Â¸Ã Â§â€¡Ã Â¦ÂªÃ Â§ÂÃ Â¦Å¸Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°', 'Ã Â¦â€¦Ã Â¦â€¢Ã Â§ÂÃ Â¦Å¸Ã Â§â€¹Ã Â¦Â¬Ã Â¦Â°', 'Ã Â¦Â¨Ã Â¦Â­Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°', 'Ã Â¦Â¡Ã Â¦Â¿Ã Â¦Â¸Ã Â§â€¡Ã Â¦Â®Ã Â§ÂÃ Â¦Â¬Ã Â¦Â°'],
    'alt_numbers' => $bengaliNumbers,
];
