<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Information from Michael Wolf    bug-glibc-locales@gnu.org
 */
return array_replace_recursive(require __DIR__.'/en.php', [
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'DD. MMMM YYYY',
        'LLL' => 'DD. MMMM, HH:mm [gÃƒÂ³Ã…Âº.]',
        'LLLL' => 'dddd, DD. MMMM YYYY, HH:mm [gÃƒÂ³Ã…Âº.]',
    ],
    'months' => ['januara', 'februara', 'mÃ„â€ºrca', 'apryla', 'maja', 'junija', 'julija', 'awgusta', 'septembra', 'oktobra', 'nowembra', 'decembra'],
    'months_short' => ['Jan', 'Feb', 'MÃ„â€ºr', 'Apr', 'Maj', 'Jun', 'Jul', 'Awg', 'Sep', 'Okt', 'Now', 'Dec'],
    'weekdays' => ['NjeÃ…Âºela', 'PÃƒÂ³njeÃ…Âºele', 'WaÃ…â€štora', 'Srjoda', 'StwÃƒÂ³rtk', 'PÃ„â€ºtk', 'Sobota'],
    'weekdays_short' => ['Nj', 'PÃƒÂ³', 'Wa', 'Sr', 'St', 'PÃ„â€º', 'So'],
    'weekdays_min' => ['Nj', 'PÃƒÂ³', 'Wa', 'Sr', 'St', 'PÃ„â€º', 'So'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,

    'year' => ':count lÃ„â€ºto',
    'y' => ':count lÃ„â€ºto',
    'a_year' => ':count lÃ„â€ºto',

    'month' => ':count mjasec',
    'm' => ':count mjasec',
    'a_month' => ':count mjasec',

    'week' => ':count tyÃ…ÂºeÃ…â€ž',
    'w' => ':count tyÃ…ÂºeÃ…â€ž',
    'a_week' => ':count tyÃ…ÂºeÃ…â€ž',

    'day' => ':count Ã…ÂºeÃ…â€ž',
    'd' => ':count Ã…ÂºeÃ…â€ž',
    'a_day' => ':count Ã…ÂºeÃ…â€ž',

    'hour' => ':count gÃƒÂ³Ã…Âºina',
    'h' => ':count gÃƒÂ³Ã…Âºina',
    'a_hour' => ':count gÃƒÂ³Ã…Âºina',

    'minute' => ':count minuta',
    'min' => ':count minuta',
    'a_minute' => ':count minuta',

    'second' => ':count drugi',
    's' => ':count drugi',
    'a_second' => ':count drugi',
]);
