<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Dieter Sting
 * - FranÃƒÂ§ois B
 * - Maxime VALY
 * - JD Isaacks
 * - Dieter Sting
 * - FranÃƒÂ§ois B
 * - JD Isaacks
 * - Sebastian Thierer
 * - Fastfuel
 * - Pete Scopes (pdscopes)
 */
return [
    'millennium' => ':count millÃƒÂ©naire|:count millÃƒÂ©naires',
    'a_millennium' => 'un millÃƒÂ©naire|:count millÃƒÂ©naires',
    'century' => ':count siÃƒÂ¨cle|:count siÃƒÂ¨cles',
    'a_century' => 'un siÃƒÂ¨cle|:count siÃƒÂ¨cles',
    'decade' => ':count dÃƒÂ©cennie|:count dÃƒÂ©cennies',
    'a_decade' => 'une dÃƒÂ©cennie|:count dÃƒÂ©cennies',
    'year' => ':count an|:count ans',
    'a_year' => 'un an|:count ans',
    'y' => ':count an|:count ans',
    'month' => ':count mois|:count mois',
    'a_month' => 'un mois|:count mois',
    'm' => ':count mois',
    'week' => ':count semaine|:count semaines',
    'a_week' => 'une semaine|:count semaines',
    'w' => ':count sem.',
    'day' => ':count jour|:count jours',
    'a_day' => 'un jour|:count jours',
    'd' => ':count j',
    'hour' => ':count heure|:count heures',
    'a_hour' => 'une heure|:count heures',
    'h' => ':count h',
    'minute' => ':count minute|:count minutes',
    'a_minute' => 'une minute|:count minutes',
    'min' => ':count min',
    'second' => ':count seconde|:count secondes',
    'a_second' => 'quelques secondes|:count secondes',
    's' => ':count s',
    'millisecond' => ':count milliseconde|:count millisecondes',
    'a_millisecond' => 'une milliseconde|:count millisecondes',
    'ms' => ':countms',
    'microsecond' => ':count microseconde|:count microsecondes',
    'a_microsecond' => 'une microseconde|:count microsecondes',
    'Ã‚Âµs' => ':countÃ‚Âµs',
    'ago' => 'il y a :time',
    'from_now' => 'dans :time',
    'after' => ':time aprÃƒÂ¨s',
    'before' => ':time avant',
    'diff_now' => "ÃƒÂ  l'instant",
    'diff_today' => "aujourd'hui",
    'diff_today_regexp' => "aujourd'hui(?:\s+ÃƒÂ )?",
    'diff_yesterday' => 'hier',
    'diff_yesterday_regexp' => 'hier(?:\s+ÃƒÂ )?',
    'diff_tomorrow' => 'demain',
    'diff_tomorrow_regexp' => 'demain(?:\s+ÃƒÂ )?',
    'diff_before_yesterday' => 'avant-hier',
    'diff_after_tomorrow' => 'aprÃƒÂ¨s-demain',
    'period_recurrences' => ':count fois',
    'period_interval' => 'tous les :interval',
    'period_start_date' => 'de :date',
    'period_end_date' => 'ÃƒÂ  :date',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD/MM/YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[AujourdÃ¢â‚¬â„¢hui ÃƒÂ ] LT',
        'nextDay' => '[Demain ÃƒÂ ] LT',
        'nextWeek' => 'dddd [ÃƒÂ ] LT',
        'lastDay' => '[Hier ÃƒÂ ] LT',
        'lastWeek' => 'dddd [dernier ÃƒÂ ] LT',
        'sameElse' => 'L',
    ],
    'months' => ['janvier', 'fÃƒÂ©vrier', 'mars', 'avril', 'mai', 'juin', 'juillet', 'aoÃƒÂ»t', 'septembre', 'octobre', 'novembre', 'dÃƒÂ©cembre'],
    'months_short' => ['janv.', 'fÃƒÂ©vr.', 'mars', 'avr.', 'mai', 'juin', 'juil.', 'aoÃƒÂ»t', 'sept.', 'oct.', 'nov.', 'dÃƒÂ©c.'],
    'weekdays' => ['dimanche', 'lundi', 'mardi', 'mercredi', 'jeudi', 'vendredi', 'samedi'],
    'weekdays_short' => ['dim.', 'lun.', 'mar.', 'mer.', 'jeu.', 'ven.', 'sam.'],
    'weekdays_min' => ['di', 'lu', 'ma', 'me', 'je', 've', 'sa'],
    'ordinal' => static function ($number, $period) {
        return match ($period) {
            // In French, only the first has to be ordinal, other number remains cardinal
            // @link https://fr.wikihow.com/%C3%A9crire-la-date-en-fran%C3%A7ais
            'D' => $number.($number === 1 ? 'er' : ''),
            default => $number.($number === 1 ? 'er' : 'e'),
            'w', 'W' => $number.($number === 1 ? 're' : 'e'),
        };
    },
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' et '],
    'ordinal_words' => [
        'of' => 'de',
        'first' => 'premier',
        'second' => 'deuxiÃƒÂ¨me',
        'third' => 'troisiÃƒÂ¨me',
        'fourth' => 'quatriÃƒÂ¨me',
        'fifth' => 'cinquiÃƒÂ¨me',
        'last' => 'dernier',
    ],
];
