<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - FranÃƒÂ§ois B
 * - Fidel Pita
 * - JD Isaacks
 * - Diego VilarinÃŒÆ’o
 * - Sebastian Thierer
 */

use Carbon\CarbonInterface;

return [
    'year' => ':count ano|:count anos',
    'a_year' => 'un ano|:count anos',
    'y' => ':count a.',
    'month' => ':count mes|:count meses',
    'a_month' => 'un mes|:count meses',
    'm' => ':count mes.',
    'week' => ':count semana|:count semanas',
    'a_week' => 'unha semana|:count semanas',
    'w' => ':count sem.',
    'day' => ':count dÃƒÂ­a|:count dÃƒÂ­as',
    'a_day' => 'un dÃƒÂ­a|:count dÃƒÂ­as',
    'd' => ':count d.',
    'hour' => ':count hora|:count horas',
    'a_hour' => 'unha hora|:count horas',
    'h' => ':count h.',
    'minute' => ':count minuto|:count minutos',
    'a_minute' => 'un minuto|:count minutos',
    'min' => ':count min.',
    'second' => ':count segundo|:count segundos',
    'a_second' => 'uns segundos|:count segundos',
    's' => ':count seg.',
    'ago' => 'hai :time',
    'from_now' => static function ($time) {
        if (str_starts_with($time, 'un')) {
            return "n$time";
        }

        return "en $time";
    },
    'diff_now' => 'agora',
    'diff_today' => 'hoxe',
    'diff_today_regexp' => 'hoxe(?:\\s+ÃƒÂ¡s)?',
    'diff_yesterday' => 'onte',
    'diff_yesterday_regexp' => 'onte(?:\\s+ÃƒÂ¡)?',
    'diff_tomorrow' => 'maÃƒÂ±ÃƒÂ¡',
    'diff_tomorrow_regexp' => 'maÃƒÂ±ÃƒÂ¡(?:\\s+ÃƒÂ¡s)?',
    'after' => ':time despois',
    'before' => ':time antes',
    'formats' => [
        'LT' => 'H:mm',
        'LTS' => 'H:mm:ss',
        'L' => 'DD/MM/YYYY',
        'LL' => 'D [de] MMMM [de] YYYY',
        'LLL' => 'D [de] MMMM [de] YYYY H:mm',
        'LLLL' => 'dddd, D [de] MMMM [de] YYYY H:mm',
    ],
    'calendar' => [
        'sameDay' => static function (CarbonInterface $current) {
            return '[hoxe '.($current->hour !== 1 ? 'ÃƒÂ¡s' : 'ÃƒÂ¡').'] LT';
        },
        'nextDay' => static function (CarbonInterface $current) {
            return '[maÃƒÂ±ÃƒÂ¡ '.($current->hour !== 1 ? 'ÃƒÂ¡s' : 'ÃƒÂ¡').'] LT';
        },
        'nextWeek' => static function (CarbonInterface $current) {
            return 'dddd ['.($current->hour !== 1 ? 'ÃƒÂ¡s' : 'ÃƒÂ¡').'] LT';
        },
        'lastDay' => static function (CarbonInterface $current) {
            return '[onte '.($current->hour !== 1 ? 'ÃƒÂ¡' : 'a').'] LT';
        },
        'lastWeek' => static function (CarbonInterface $current) {
            return '[o] dddd [pasado '.($current->hour !== 1 ? 'ÃƒÂ¡s' : 'ÃƒÂ¡').'] LT';
        },
        'sameElse' => 'L',
    ],
    'ordinal' => ':numberÃ‚Âº',
    'months' => ['xaneiro', 'febreiro', 'marzo', 'abril', 'maio', 'xuÃƒÂ±o', 'xullo', 'agosto', 'setembro', 'outubro', 'novembro', 'decembro'],
    'months_short' => ['xan.', 'feb.', 'mar.', 'abr.', 'mai.', 'xuÃƒÂ±.', 'xul.', 'ago.', 'set.', 'out.', 'nov.', 'dec.'],
    'weekdays' => ['domingo', 'luns', 'martes', 'mÃƒÂ©rcores', 'xoves', 'venres', 'sÃƒÂ¡bado'],
    'weekdays_short' => ['dom.', 'lun.', 'mar.', 'mÃƒÂ©r.', 'xov.', 'ven.', 'sÃƒÂ¡b.'],
    'weekdays_min' => ['do', 'lu', 'ma', 'mÃƒÂ©', 'xo', 've', 'sÃƒÂ¡'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' e '],
    'meridiem' => ['a.m.', 'p.m.'],
];
