<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Adam Brunner
 * - Brett Johnson
 * - balping
 */

use Carbon\CarbonInterface;

$huWeekEndings = ['vasÃƒÂ¡rnap', 'hÃƒÂ©tfÃ…â€˜n', 'kedden', 'szerdÃƒÂ¡n', 'csÃƒÂ¼tÃƒÂ¶rtÃƒÂ¶kÃƒÂ¶n', 'pÃƒÂ©nteken', 'szombaton'];

return [
    'year' => ':count ÃƒÂ©v',
    'y' => ':count ÃƒÂ©v',
    'month' => ':count hÃƒÂ³nap',
    'm' => ':count hÃƒÂ³nap',
    'week' => ':count hÃƒÂ©t',
    'w' => ':count hÃƒÂ©t',
    'day' => ':count nap',
    'd' => ':count nap',
    'hour' => ':count ÃƒÂ³ra',
    'h' => ':count ÃƒÂ³ra',
    'minute' => ':count perc',
    'min' => ':count perc',
    'second' => ':count mÃƒÂ¡sodperc',
    's' => ':count mÃƒÂ¡sodperc',
    'ago' => ':time',
    'from_now' => ':time mÃƒÂºlva',
    'after' => ':time kÃƒÂ©sÃ…â€˜bb',
    'before' => ':time korÃƒÂ¡bban',
    'year_ago' => ':count ÃƒÂ©ve',
    'y_ago' => ':count ÃƒÂ©ve',
    'month_ago' => ':count hÃƒÂ³napja',
    'm_ago' => ':count hÃƒÂ³napja',
    'week_ago' => ':count hete',
    'w_ago' => ':count hete',
    'day_ago' => ':count napja',
    'd_ago' => ':count napja',
    'hour_ago' => ':count ÃƒÂ³rÃƒÂ¡ja',
    'h_ago' => ':count ÃƒÂ³rÃƒÂ¡ja',
    'minute_ago' => ':count perce',
    'min_ago' => ':count perce',
    'second_ago' => ':count mÃƒÂ¡sodperce',
    's_ago' => ':count mÃƒÂ¡sodperce',
    'year_after' => ':count ÃƒÂ©vvel',
    'y_after' => ':count ÃƒÂ©vvel',
    'month_after' => ':count hÃƒÂ³nappal',
    'm_after' => ':count hÃƒÂ³nappal',
    'week_after' => ':count hÃƒÂ©ttel',
    'w_after' => ':count hÃƒÂ©ttel',
    'day_after' => ':count nappal',
    'd_after' => ':count nappal',
    'hour_after' => ':count ÃƒÂ³rÃƒÂ¡val',
    'h_after' => ':count ÃƒÂ³rÃƒÂ¡val',
    'minute_after' => ':count perccel',
    'min_after' => ':count perccel',
    'second_after' => ':count mÃƒÂ¡sodperccel',
    's_after' => ':count mÃƒÂ¡sodperccel',
    'year_before' => ':count ÃƒÂ©vvel',
    'y_before' => ':count ÃƒÂ©vvel',
    'month_before' => ':count hÃƒÂ³nappal',
    'm_before' => ':count hÃƒÂ³nappal',
    'week_before' => ':count hÃƒÂ©ttel',
    'w_before' => ':count hÃƒÂ©ttel',
    'day_before' => ':count nappal',
    'd_before' => ':count nappal',
    'hour_before' => ':count ÃƒÂ³rÃƒÂ¡val',
    'h_before' => ':count ÃƒÂ³rÃƒÂ¡val',
    'minute_before' => ':count perccel',
    'min_before' => ':count perccel',
    'second_before' => ':count mÃƒÂ¡sodperccel',
    's_before' => ':count mÃƒÂ¡sodperccel',
    'months' => ['januÃƒÂ¡r', 'februÃƒÂ¡r', 'mÃƒÂ¡rcius', 'ÃƒÂ¡prilis', 'mÃƒÂ¡jus', 'jÃƒÂºnius', 'jÃƒÂºlius', 'augusztus', 'szeptember', 'oktÃƒÂ³ber', 'november', 'december'],
    'months_short' => ['jan.', 'febr.', 'mÃƒÂ¡rc.', 'ÃƒÂ¡pr.', 'mÃƒÂ¡j.', 'jÃƒÂºn.', 'jÃƒÂºl.', 'aug.', 'szept.', 'okt.', 'nov.', 'dec.'],
    'weekdays' => ['vasÃƒÂ¡rnap', 'hÃƒÂ©tfÃ…â€˜', 'kedd', 'szerda', 'csÃƒÂ¼tÃƒÂ¶rtÃƒÂ¶k', 'pÃƒÂ©ntek', 'szombat'],
    'weekdays_short' => ['vas', 'hÃƒÂ©t', 'kedd', 'sze', 'csÃƒÂ¼t', 'pÃƒÂ©n', 'szo'],
    'weekdays_min' => ['v', 'h', 'k', 'sze', 'cs', 'p', 'sz'],
    'ordinal' => ':number.',
    'diff_now' => 'most',
    'diff_today' => 'ma',
    'diff_yesterday' => 'tegnap',
    'diff_tomorrow' => 'holnap',
    'formats' => [
        'LT' => 'H:mm',
        'LTS' => 'H:mm:ss',
        'L' => 'YYYY.MM.DD.',
        'LL' => 'YYYY. MMMM D.',
        'LLL' => 'YYYY. MMMM D. H:mm',
        'LLLL' => 'YYYY. MMMM D., dddd H:mm',
    ],
    'calendar' => [
        'sameDay' => '[ma] LT[-kor]',
        'nextDay' => '[holnap] LT[-kor]',
        'nextWeek' => static function (CarbonInterface $date) use ($huWeekEndings) {
            return '['.$huWeekEndings[$date->dayOfWeek].'] LT[-kor]';
        },
        'lastDay' => '[tegnap] LT[-kor]',
        'lastWeek' => static function (CarbonInterface $date) use ($huWeekEndings) {
            return '[mÃƒÂºlt '.$huWeekEndings[$date->dayOfWeek].'] LT[-kor]';
        },
        'sameElse' => 'L',
    ],
    'meridiem' => ['DE', 'DU'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' ÃƒÂ©s '],
];
