<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - mhamlet
 */
return [
    'year' => ':count Ã•Â¿Ã•Â¡Ã–â‚¬Ã•Â«',
    'a_year' => 'Ã•Â¿Ã•Â¡Ã–â‚¬Ã•Â«|:count Ã•Â¿Ã•Â¡Ã–â‚¬Ã•Â«',
    'y' => ':countÃ•Â¿',
    'month' => ':count Ã•Â¡Ã•Â´Ã•Â«Ã•Â½',
    'a_month' => 'Ã•Â¡Ã•Â´Ã•Â«Ã•Â½|:count Ã•Â¡Ã•Â´Ã•Â«Ã•Â½',
    'm' => ':countÃ•Â¡Ã•Â´',
    'week' => ':count Ã•Â·Ã•Â¡Ã•Â¢Ã•Â¡Ã•Â©',
    'a_week' => 'Ã•Â·Ã•Â¡Ã•Â¢Ã•Â¡Ã•Â©|:count Ã•Â·Ã•Â¡Ã•Â¢Ã•Â¡Ã•Â©',
    'w' => ':countÃ•Â·',
    'day' => ':count Ã–â€¦Ã–â‚¬',
    'a_day' => 'Ã–â€¦Ã–â‚¬|:count Ã–â€¦Ã–â‚¬',
    'd' => ':countÃ–â€¦Ã–â‚¬',
    'hour' => ':count Ã•ÂªÃ•Â¡Ã•Â´',
    'a_hour' => 'Ã•ÂªÃ•Â¡Ã•Â´|:count Ã•ÂªÃ•Â¡Ã•Â´',
    'h' => ':countÃ•Âª',
    'minute' => ':count Ã–â‚¬Ã•Â¸Ã•ÂºÃ•Â¥',
    'a_minute' => 'Ã–â‚¬Ã•Â¸Ã•ÂºÃ•Â¥|:count Ã–â‚¬Ã•Â¸Ã•ÂºÃ•Â¥',
    'min' => ':countÃ–â‚¬',
    'second' => ':count Ã•Â¾Ã•Â¡Ã•ÂµÃ–â‚¬Ã•Â¯Ã•ÂµÃ•Â¡Ã•Â¶',
    'a_second' => 'Ã•Â´Ã•Â« Ã–â€žÃ•Â¡Ã•Â¶Ã•Â« Ã•Â¾Ã•Â¡Ã•ÂµÃ–â‚¬Ã•Â¯Ã•ÂµÃ•Â¡Ã•Â¶|:count Ã•Â¾Ã•Â¡Ã•ÂµÃ–â‚¬Ã•Â¯Ã•ÂµÃ•Â¡Ã•Â¶',
    's' => ':countÃ•Â¾Ã–â‚¬Ã•Â¯',
    'ago' => ':time Ã•Â¡Ã•Â¼Ã•Â¡Ã•Â»',
    'from_now' => ':timeÃ•Â«Ã–Â',
    'after' => ':time Ã•Â°Ã•Â¥Ã•Â¿Ã•Â¸',
    'before' => ':time Ã•Â¡Ã•Â¼Ã•Â¡Ã•Â»',
    'diff_now' => 'Ã•Â°Ã•Â«Ã•Â´Ã•Â¡',
    'diff_today' => 'Ã•Â¡Ã•ÂµÃ•Â½Ã–â€¦Ã–â‚¬',
    'diff_yesterday' => 'Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯',
    'diff_tomorrow' => 'Ã•Â¾Ã•Â¡Ã•Â²Ã•Â¨',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D MMMM YYYY Ã•Â©.',
        'LLL' => 'D MMMM YYYY Ã•Â©., HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY Ã•Â©., HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Ã•Â¡Ã•ÂµÃ•Â½Ã–â€¦Ã–â‚¬] LT',
        'nextDay' => '[Ã•Â¾Ã•Â¡Ã•Â²Ã•Â¨] LT',
        'nextWeek' => 'dddd [Ã–â€¦Ã–â‚¬Ã•Â¨ Ã•ÂªÃ•Â¡Ã•Â´Ã•Â¨] LT',
        'lastDay' => '[Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯] LT',
        'lastWeek' => '[Ã•Â¡Ã•Â¶Ã–ÂÃ•Â¡Ã•Â®] dddd [Ã–â€¦Ã–â‚¬Ã•Â¨ Ã•ÂªÃ•Â¡Ã•Â´Ã•Â¨] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number, $period) {
        return match ($period) {
            'DDD', 'w', 'W', 'DDDo' => $number.($number === 1 ? '-Ã•Â«Ã•Â¶' : '-Ã–â‚¬Ã•Â¤'),
            default => $number,
        };
    },
    'meridiem' => static function ($hour) {
        if ($hour < 4) {
            return 'Ã•Â£Ã•Â«Ã•Â·Ã•Â¥Ã–â‚¬Ã•Â¾Ã•Â¡';
        }
        if ($hour < 12) {
            return 'Ã•Â¡Ã•Â¼Ã•Â¡Ã•Â¾Ã•Â¸Ã•Â¿Ã•Â¾Ã•Â¡';
        }
        if ($hour < 17) {
            return 'Ã–ÂÃ•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¾Ã•Â¡';
        }

        return 'Ã•Â¥Ã–â‚¬Ã•Â¥Ã•Â¯Ã•Â¸Ã•ÂµÃ•Â¡Ã•Â¶';
    },
    'months' => ['Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â¾Ã•Â¡Ã–â‚¬Ã•Â«', 'Ã–Æ’Ã•Â¥Ã•Â¿Ã–â‚¬Ã•Â¾Ã•Â¡Ã–â‚¬Ã•Â«', 'Ã•Â´Ã•Â¡Ã–â‚¬Ã•Â¿Ã•Â«', 'Ã•Â¡Ã•ÂºÃ–â‚¬Ã•Â«Ã•Â¬Ã•Â«', 'Ã•Â´Ã•Â¡Ã•ÂµÃ•Â«Ã•Â½Ã•Â«', 'Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â«Ã•Â½Ã•Â«', 'Ã•Â°Ã•Â¸Ã–â€šÃ•Â¬Ã•Â«Ã•Â½Ã•Â«', 'Ã–â€¦Ã•Â£Ã•Â¸Ã•Â½Ã•Â¿Ã•Â¸Ã•Â½Ã•Â«', 'Ã•Â½Ã•Â¥Ã•ÂºÃ•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«', 'Ã•Â°Ã•Â¸Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«', 'Ã•Â¶Ã•Â¸Ã•ÂµÃ•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«', 'Ã•Â¤Ã•Â¥Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬Ã•Â«'],
    'months_standalone' => ['Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â¾Ã•Â¡Ã–â‚¬', 'Ã–Æ’Ã•Â¥Ã•Â¿Ã–â‚¬Ã•Â¾Ã•Â¡Ã–â‚¬', 'Ã•Â´Ã•Â¡Ã–â‚¬Ã•Â¿', 'Ã•Â¡Ã•ÂºÃ–â‚¬Ã•Â«Ã•Â¬', 'Ã•Â´Ã•Â¡Ã•ÂµÃ•Â«Ã•Â½', 'Ã•Â°Ã•Â¸Ã–â€šÃ•Â¶Ã•Â«Ã•Â½', 'Ã•Â°Ã•Â¸Ã–â€šÃ•Â¬Ã•Â«Ã•Â½', 'Ã–â€¦Ã•Â£Ã•Â¸Ã•Â½Ã•Â¿Ã•Â¸Ã•Â½', 'Ã•Â½Ã•Â¥Ã•ÂºÃ•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬', 'Ã•Â°Ã•Â¸Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬', 'Ã•Â¶Ã•Â¸Ã•ÂµÃ•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬', 'Ã•Â¤Ã•Â¥Ã•Â¯Ã•Â¿Ã•Â¥Ã•Â´Ã•Â¢Ã•Â¥Ã–â‚¬'],
    'months_short' => ['Ã•Â°Ã•Â¶Ã•Â¾', 'Ã–Æ’Ã•Â¿Ã–â‚¬', 'Ã•Â´Ã–â‚¬Ã•Â¿', 'Ã•Â¡Ã•ÂºÃ–â‚¬', 'Ã•Â´Ã•ÂµÃ•Â½', 'Ã•Â°Ã•Â¶Ã•Â½', 'Ã•Â°Ã•Â¬Ã•Â½', 'Ã–â€¦Ã•Â£Ã•Â½', 'Ã•Â½Ã•ÂºÃ•Â¿', 'Ã•Â°Ã•Â¯Ã•Â¿', 'Ã•Â¶Ã•Â´Ã•Â¢', 'Ã•Â¤Ã•Â¯Ã•Â¿'],
    'months_regexp' => '/(D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => ['Ã•Â¯Ã•Â«Ã–â‚¬Ã•Â¡Ã•Â¯Ã•Â«', 'Ã•Â¥Ã–â‚¬Ã•Â¯Ã•Â¸Ã–â€šÃ•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«', 'Ã•Â¥Ã–â‚¬Ã•Â¥Ã–â€žÃ•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«', 'Ã•Â¹Ã•Â¸Ã–â‚¬Ã•Â¥Ã–â€žÃ•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«', 'Ã•Â°Ã•Â«Ã•Â¶Ã•Â£Ã•Â·Ã•Â¡Ã•Â¢Ã•Â©Ã•Â«', 'Ã•Â¸Ã–â€šÃ–â‚¬Ã•Â¢Ã•Â¡Ã•Â©', 'Ã•Â·Ã•Â¡Ã•Â¢Ã•Â¡Ã•Â©'],
    'weekdays_short' => ['Ã•Â¯Ã–â‚¬Ã•Â¯', 'Ã•Â¥Ã–â‚¬Ã•Â¯', 'Ã•Â¥Ã–â‚¬Ã–â€ž', 'Ã•Â¹Ã–â‚¬Ã–â€ž', 'Ã•Â°Ã•Â¶Ã•Â£', 'Ã•Â¸Ã–â€šÃ–â‚¬Ã•Â¢', 'Ã•Â·Ã•Â¢Ã•Â©'],
    'weekdays_min' => ['Ã•Â¯Ã–â‚¬Ã•Â¯', 'Ã•Â¥Ã–â‚¬Ã•Â¯', 'Ã•Â¥Ã–â‚¬Ã–â€ž', 'Ã•Â¹Ã–â‚¬Ã–â€ž', 'Ã•Â°Ã•Â¶Ã•Â£', 'Ã•Â¸Ã–â€šÃ–â‚¬Ã•Â¢', 'Ã•Â·Ã•Â¢Ã•Â©'],
    'list' => [', ', ' Ã•Â¥Ã–â€š '],
    'first_day_of_week' => 1,
];
