<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Tornike Razmadze
 * - FranÃƒÂ§ois B
 * - Lasha Dolidze
 * - Tim Fish
 * - JD Isaacks
 * - Tornike Razmadze
 * - FranÃƒÂ§ois B
 * - Lasha Dolidze
 * - JD Isaacks
 * - LONGMAN
 * - Avtandil Kikabidze (akalongman)
 * - Levan Velijanashvili (Stichoza)
 */

use Carbon\CarbonInterface;

return [
    'year' => ':count Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ',
    'y' => ':count Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ',
    'a_year' => '{1}Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ|[-Inf,Inf]:count Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ',
    'month' => ':count Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€',
    'm' => ':count Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€',
    'a_month' => '{1}Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€|[-Inf,Inf]:count Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€',
    'week' => ':count Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â',
    'w' => ':count Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â',
    'a_week' => '{1}Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â|[-Inf,Inf]:count Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â',
    'day' => ':count Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€',
    'd' => ':count Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€',
    'a_day' => '{1}Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€|[-Inf,Inf]:count Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€',
    'hour' => ':count Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ',
    'h' => ':count Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ',
    'a_hour' => '{1}Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ|[-Inf,Inf]:count Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ',
    'minute' => ':count Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ',
    'min' => ':count Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ',
    'a_minute' => '{1}Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ|[-Inf,Inf]:count Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ',
    'second' => ':count Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ',
    's' => ':count Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ',
    'a_second' => '{1}Ã¡Æ’Â Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’â€œÃ¡Æ’â€Ã¡Æ’Å“Ã¡Æ’ËœÃ¡Æ’â€ºÃ¡Æ’â€ Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ|[-Inf,Inf]:count Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ',
    'ago' => static function ($time) {
        $replacements = [
            // year
            'Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡',
            // month
            'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€' => 'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â¡',
            // week
            'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â' => 'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’ËœÃ¡Æ’Â¡',
            // day
            'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€' => 'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’ËœÃ¡Æ’Â¡',
            // hour
            'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’ËœÃ¡Æ’Â¡',
            // minute
            'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’ËœÃ¡Æ’Â¡',
            // second
            'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’ËœÃ¡Æ’Â¡',
        ];
        $time = strtr($time, array_flip($replacements));
        $time = strtr($time, $replacements);

        return "$time Ã¡Æ’Â¬Ã¡Æ’ËœÃ¡Æ’Å“";
    },
    'from_now' => static function ($time) {
        $replacements = [
            // year
            'Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€œÃ¡Æ’Â¨Ã¡Æ’Ëœ',
            // week
            'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â' => 'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’ÂÃ¡Æ’Â¨Ã¡Æ’Ëœ',
            // day
            'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€' => 'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€Ã¡Æ’Â¨Ã¡Æ’Ëœ',
            // month
            'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€' => 'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€Ã¡Æ’Â¨Ã¡Æ’Ëœ',
            // hour
            'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¨Ã¡Æ’Ëœ',
            // minute
            'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Â¨Ã¡Æ’Ëœ',
            // second
            'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Â¨Ã¡Æ’Ëœ',
        ];
        $time = strtr($time, array_flip($replacements));
        $time = strtr($time, $replacements);

        return $time;
    },
    'after' => static function ($time) {
        $replacements = [
            // year
            'Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡',
            // month
            'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€' => 'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â¡',
            // week
            'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â' => 'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’ËœÃ¡Æ’Â¡',
            // day
            'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€' => 'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’ËœÃ¡Æ’Â¡',
            // hour
            'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’ËœÃ¡Æ’Â¡',
            // minute
            'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’ËœÃ¡Æ’Â¡',
            // second
            'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’ËœÃ¡Æ’Â¡',
        ];
        $time = strtr($time, array_flip($replacements));
        $time = strtr($time, $replacements);

        return "$time Ã¡Æ’Â¨Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â€™";
    },
    'before' => static function ($time) {
        $replacements = [
            // year
            'Ã¡Æ’Â¬Ã¡Æ’â€Ã¡Æ’Å¡Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’â€”',
            // month
            'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’â€' => 'Ã¡Æ’â€”Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’â€”',
            // week
            'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â' => 'Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’ËœÃ¡Æ’â€”',
            // day
            'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€' => 'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’ËœÃ¡Æ’â€”',
            // hour
            'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’ËœÃ¡Æ’â€”',
            // minute
            'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’ËœÃ¡Æ’â€”',
            // second
            'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Ëœ' => 'Ã¡Æ’Â¬Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’ËœÃ¡Æ’â€”',
        ];
        $time = strtr($time, array_flip($replacements));
        $time = strtr($time, $replacements);

        return "$time Ã¡Æ’ÂÃ¡Æ’â€œÃ¡Æ’Â Ã¡Æ’â€";
    },
    'diff_now' => 'Ã¡Æ’ÂÃ¡Æ’Â®Ã¡Æ’Å¡Ã¡Æ’Â',
    'diff_today' => 'Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€Ã¡Æ’Â¡',
    'diff_yesterday' => 'Ã¡Æ’â€™Ã¡Æ’Â£Ã¡Æ’Â¨Ã¡Æ’ËœÃ¡Æ’Å“',
    'diff_tomorrow' => 'Ã¡Æ’Â®Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD/MM/YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Ã¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’â€Ã¡Æ’Â¡], LT[-Ã¡Æ’â€“Ã¡Æ’â€]',
        'nextDay' => '[Ã¡Æ’Â®Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡], LT[-Ã¡Æ’â€“Ã¡Æ’â€]',
        'nextWeek' => static function (CarbonInterface $current, \Carbon\CarbonInterface $other) {
            return ($current->isSameWeek($other) ? '' : '[Ã¡Æ’Â¨Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â€™] ').'dddd, LT[-Ã¡Æ’â€“Ã¡Æ’â€]';
        },
        'lastDay' => '[Ã¡Æ’â€™Ã¡Æ’Â£Ã¡Æ’Â¨Ã¡Æ’ËœÃ¡Æ’Å“], LT[-Ã¡Æ’â€“Ã¡Æ’â€]',
        'lastWeek' => '[Ã¡Æ’Â¬Ã¡Æ’ËœÃ¡Æ’Å“Ã¡Æ’Â] dddd, LT-Ã¡Æ’â€“Ã¡Æ’â€',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number) {
        if ($number === 0) {
            return $number;
        }
        if ($number === 1) {
            return $number.'-Ã¡Æ’Å¡Ã¡Æ’Ëœ';
        }
        if (($number < 20) || ($number <= 100 && ($number % 20 === 0)) || ($number % 100 === 0)) {
            return 'Ã¡Æ’â€ºÃ¡Æ’â€-'.$number;
        }

        return $number.'-Ã¡Æ’â€';
    },
    'months' => ['Ã¡Æ’ËœÃ¡Æ’ÂÃ¡Æ’Å“Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Ëœ', 'Ã¡Æ’â€”Ã¡Æ’â€Ã¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡Ã¡Æ’Ëœ', 'Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Â¢Ã¡Æ’Ëœ', 'Ã¡Æ’ÂÃ¡Æ’Å¾Ã¡Æ’Â Ã¡Æ’ËœÃ¡Æ’Å¡Ã¡Æ’Ëœ', 'Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Ëœ', 'Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å“Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Ëœ', 'Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Ëœ', 'Ã¡Æ’ÂÃ¡Æ’â€™Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¢Ã¡Æ’Â', 'Ã¡Æ’Â¡Ã¡Æ’â€Ã¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Ëœ', 'Ã¡Æ’ÂÃ¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Ëœ', 'Ã¡Æ’Å“Ã¡Æ’ÂÃ¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Ëœ', 'Ã¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Ëœ'],
    'months_standalone' => ['Ã¡Æ’ËœÃ¡Æ’ÂÃ¡Æ’Å“Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Â¡', 'Ã¡Æ’â€”Ã¡Æ’â€Ã¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’â€¢Ã¡Æ’ÂÃ¡Æ’Å¡Ã¡Æ’Â¡', 'Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Â¢Ã¡Æ’Â¡', 'Ã¡Æ’ÂÃ¡Æ’Å¾Ã¡Æ’Â Ã¡Æ’ËœÃ¡Æ’Å¡Ã¡Æ’Â¡', 'Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¡', 'Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å“Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¡', 'Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¡', 'Ã¡Æ’ÂÃ¡Æ’â€™Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â¡Ã¡Æ’Â¢Ã¡Æ’ÂÃ¡Æ’Â¡', 'Ã¡Æ’Â¡Ã¡Æ’â€Ã¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Â¡', 'Ã¡Æ’ÂÃ¡Æ’Â¥Ã¡Æ’Â¢Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Â¡', 'Ã¡Æ’Å“Ã¡Æ’ÂÃ¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Â¡', 'Ã¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€ºÃ¡Æ’â€˜Ã¡Æ’â€Ã¡Æ’Â Ã¡Æ’Â¡'],
    'months_short' => ['Ã¡Æ’ËœÃ¡Æ’ÂÃ¡Æ’Å“', 'Ã¡Æ’â€”Ã¡Æ’â€Ã¡Æ’â€˜', 'Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’Â ', 'Ã¡Æ’ÂÃ¡Æ’Å¾Ã¡Æ’Â ', 'Ã¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’Ëœ', 'Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å“', 'Ã¡Æ’ËœÃ¡Æ’â€¢Ã¡Æ’Å¡', 'Ã¡Æ’ÂÃ¡Æ’â€™Ã¡Æ’â€¢', 'Ã¡Æ’Â¡Ã¡Æ’â€Ã¡Æ’Â¥', 'Ã¡Æ’ÂÃ¡Æ’Â¥Ã¡Æ’Â¢', 'Ã¡Æ’Å“Ã¡Æ’ÂÃ¡Æ’â€', 'Ã¡Æ’â€œÃ¡Æ’â€Ã¡Æ’â„¢'],
    'months_regexp' => '/(D[oD]?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'weekdays' => ['Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’ÂÃ¡Æ’Â¡', 'Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡', 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡', 'Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â®Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡', 'Ã¡Æ’Â®Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡', 'Ã¡Æ’Å¾Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’ÂÃ¡Æ’Â¡Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€¢Ã¡Æ’Â¡', 'Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â¡'],
    'weekdays_standalone' => ['Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’ËœÃ¡Æ’Â Ã¡Æ’Â', 'Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ', 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ', 'Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â®Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ', 'Ã¡Æ’Â®Ã¡Æ’Â£Ã¡Æ’â€”Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ', 'Ã¡Æ’Å¾Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’ÂÃ¡Æ’Â¡Ã¡Æ’â„¢Ã¡Æ’â€Ã¡Æ’â€¢Ã¡Æ’Ëœ', 'Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Ëœ'],
    'weekdays_short' => ['Ã¡Æ’â„¢Ã¡Æ’â€¢Ã¡Æ’Ëœ', 'Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’Â¨', 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’â€º', 'Ã¡Æ’ÂÃ¡Æ’â€”Ã¡Æ’Â®', 'Ã¡Æ’Â®Ã¡Æ’Â£Ã¡Æ’â€”', 'Ã¡Æ’Å¾Ã¡Æ’ÂÃ¡Æ’Â ', 'Ã¡Æ’Â¨Ã¡Æ’ÂÃ¡Æ’â€˜'],
    'weekdays_min' => ['Ã¡Æ’â„¢Ã¡Æ’â€¢', 'Ã¡Æ’ÂÃ¡Æ’Â ', 'Ã¡Æ’Â¡Ã¡Æ’Â', 'Ã¡Æ’ÂÃ¡Æ’â€”', 'Ã¡Æ’Â®Ã¡Æ’Â£', 'Ã¡Æ’Å¾Ã¡Æ’Â', 'Ã¡Æ’Â¨Ã¡Æ’Â'],
    'weekdays_regexp' => '/^([^d].*|.*[^d])$/',
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' Ã¡Æ’â€œÃ¡Æ’Â '],
    'meridiem' => static function ($hour) {
        if ($hour >= 4) {
            if ($hour < 11) {
                return 'Ã¡Æ’â€œÃ¡Æ’ËœÃ¡Æ’Å¡Ã¡Æ’ËœÃ¡Æ’Â¡';
            }

            if ($hour < 16) {
                return 'Ã¡Æ’Â¨Ã¡Æ’Â£Ã¡Æ’ÂÃ¡Æ’â€œÃ¡Æ’Â¦Ã¡Æ’ËœÃ¡Æ’Â¡';
            }

            if ($hour < 22) {
                return 'Ã¡Æ’Â¡Ã¡Æ’ÂÃ¡Æ’Â¦Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’ÂÃ¡Æ’Â¡';
            }
        }

        return 'Ã¡Æ’Â¦Ã¡Æ’ÂÃ¡Æ’â€ºÃ¡Æ’ËœÃ¡Æ’Â¡';
    },
];
