<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Philippe Vaucher
 * - Martin Suja
 * - Tsutomu Kuroda
 * - tjku
 * - Max Melentiev
 * - Juanito Fatas
 * - Ivan Stana
 * - Akira Matsuda
 * - Christopher Dell
 * - James McKinney
 * - Enrique Vidal
 * - Simone Carletti
 * - Aaron Patterson
 * - Jozef Fulop
 * - NicolÃƒÂ¡s Hock Isaza
 * - Tom Hughes
 * - Simon HÃƒÂ¼rlimann (CyT)
 * - jofi
 * - Jakub ADAMEC
 * - Marek AdamickÃƒÂ½
 * - AlterwebStudio
 * - Peter Kundis
 */

use Carbon\CarbonInterface;

$fromNow = function ($time) {
    return 'o '.strtr($time, [
            'hodina' => 'hodinu',
            'minÃƒÂºta' => 'minÃƒÂºtu',
            'sekunda' => 'sekundu',
        ]);
};

$ago = function ($time) {
    $replacements = [
        '/\bhodina\b/' => 'hodinou',
        '/\bminÃƒÂºta\b/' => 'minÃƒÂºtou',
        '/\bsekunda\b/' => 'sekundou',
        '/\bdeÃ…Ë†\b/u' => 'dÃ…Ë†om',
        '/\btÃƒÂ½Ã…Â¾deÃ…Ë†\b/u' => 'tÃƒÂ½Ã…Â¾dÃ…Ë†om',
        '/\bmesiac\b/' => 'mesiacom',
        '/\brok\b/' => 'rokom',
    ];

    $replacementsPlural = [
        '/\b(?:hodiny|hodÃƒÂ­n)\b/' => 'hodinami',
        '/\b(?:minÃƒÂºty|minÃƒÂºt)\b/' => 'minÃƒÂºtami',
        '/\b(?:sekundy|sekÃƒÂºnd)\b/' => 'sekundami',
        '/\bdeÃ…Ë†\b/' => 'dÃ…Ë†om',
        '/\bdni\b/' => 'dÃ…Ë†ami',
        '/\bdnÃƒÂ­\b/u' => 'dÃ…Ë†ami',
        '/\b(?:tÃƒÂ½Ã…Â¾dne|tÃƒÂ½Ã…Â¾dÃ…Ë†ov)\b/' => 'tÃƒÂ½Ã…Â¾dÃ…Ë†ami',
        '/\b(?:mesiace|mesiacov)\b/' => 'mesiacmi',
        '/\b(?:roky|rokov)\b/' => 'rokmi',
    ];

    foreach ($replacements + $replacementsPlural as $pattern => $replacement) {
        $time = preg_replace($pattern, $replacement, $time);
    }

    return "pred $time";
};

return [
    'year' => ':count rok|:count roky|:count rokov',
    'a_year' => 'rok|:count roky|:count rokov',
    'y' => ':count r',
    'month' => ':count mesiac|:count mesiace|:count mesiacov',
    'a_month' => 'mesiac|:count mesiace|:count mesiacov',
    'm' => ':count m',
    'week' => ':count tÃƒÂ½Ã…Â¾deÃ…Ë†|:count tÃƒÂ½Ã…Â¾dne|:count tÃƒÂ½Ã…Â¾dÃ…Ë†ov',
    'a_week' => 'tÃƒÂ½Ã…Â¾deÃ…Ë†|:count tÃƒÂ½Ã…Â¾dne|:count tÃƒÂ½Ã…Â¾dÃ…Ë†ov',
    'w' => ':count t',
    'day' => ':count deÃ…Ë†|:count dni|:count dnÃƒÂ­',
    'a_day' => 'deÃ…Ë†|:count dni|:count dnÃƒÂ­',
    'd' => ':count d',
    'hour' => ':count hodina|:count hodiny|:count hodÃƒÂ­n',
    'a_hour' => 'hodina|:count hodiny|:count hodÃƒÂ­n',
    'h' => ':count h',
    'minute' => ':count minÃƒÂºta|:count minÃƒÂºty|:count minÃƒÂºt',
    'a_minute' => 'minÃƒÂºta|:count minÃƒÂºty|:count minÃƒÂºt',
    'min' => ':count min',
    'second' => ':count sekunda|:count sekundy|:count sekÃƒÂºnd',
    'a_second' => 'sekunda|:count sekundy|:count sekÃƒÂºnd',
    's' => ':count s',
    'millisecond' => ':count milisekunda|:count milisekundy|:count milisekÃƒÂºnd',
    'a_millisecond' => 'milisekunda|:count milisekundy|:count milisekÃƒÂºnd',
    'ms' => ':count ms',
    'microsecond' => ':count mikrosekunda|:count mikrosekundy|:count mikrosekÃƒÂºnd',
    'a_microsecond' => 'mikrosekunda|:count mikrosekundy|:count mikrosekÃƒÂºnd',
    'Ã‚Âµs' => ':count Ã‚Âµs',

    'ago' => $ago,
    'from_now' => $fromNow,
    'before' => ':time pred',
    'after' => ':time po',

    'hour_after' => ':count hodinu|:count hodiny|:count hodÃƒÂ­n',
    'minute_after' => ':count minÃƒÂºtu|:count minÃƒÂºty|:count minÃƒÂºt',
    'second_after' => ':count sekundu|:count sekundy|:count sekÃƒÂºnd',

    'hour_before' => ':count hodinu|:count hodiny|:count hodÃƒÂ­n',
    'minute_before' => ':count minÃƒÂºtu|:count minÃƒÂºty|:count minÃƒÂºt',
    'second_before' => ':count sekundu|:count sekundy|:count sekÃƒÂºnd',

    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' a '],
    'diff_now' => 'teraz',
    'diff_yesterday' => 'vÃ„Âera',
    'diff_tomorrow' => 'zajtra',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'DD. MMMM YYYY',
        'LLL' => 'D. M. HH:mm',
        'LLLL' => 'dddd D. MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[dnes o] LT',
        'nextDay' => '[zajtra o] LT',
        'lastDay' => '[vÃ„Âera o] LT',
        'nextWeek' => 'dddd [o] LT',
        'lastWeek' => static function (CarbonInterface $date) {
            switch ($date->dayOfWeek) {
                case 1:
                case 2:
                case 4:
                case 5:
                    return '[minulÃƒÂ½] dddd [o] LT'; //pondelok/utorok/Ã…Â¡tvrtok/piatok
                default:
                    return '[minulÃƒÂ¡] dddd [o] LT';
            }
        },
        'sameElse' => 'L',
    ],
    'weekdays' => ['nedeÃ„Â¾a', 'pondelok', 'utorok', 'streda', 'Ã…Â¡tvrtok', 'piatok', 'sobota'],
    'weekdays_short' => ['ned', 'pon', 'uto', 'str', 'Ã…Â¡tv', 'pia', 'sob'],
    'weekdays_min' => ['ne', 'po', 'ut', 'st', 'Ã…Â¡t', 'pi', 'so'],
    'months' => ['januÃƒÂ¡ra', 'februÃƒÂ¡ra', 'marca', 'aprÃƒÂ­la', 'mÃƒÂ¡ja', 'jÃƒÂºna', 'jÃƒÂºla', 'augusta', 'septembra', 'oktÃƒÂ³bra', 'novembra', 'decembra'],
    'months_standalone' => ['januÃƒÂ¡r', 'februÃƒÂ¡r', 'marec', 'aprÃƒÂ­l', 'mÃƒÂ¡j', 'jÃƒÂºn', 'jÃƒÂºl', 'august', 'september', 'oktÃƒÂ³ber', 'november', 'december'],
    'months_short' => ['jan', 'feb', 'mar', 'apr', 'mÃƒÂ¡j', 'jÃƒÂºn', 'jÃƒÂºl', 'aug', 'sep', 'okt', 'nov', 'dec'],
    'months_regexp' => '/(DD?o?\.?(\[[^\[\]]*\]|\s)+MMMM?|L{2,4}|l{2,4})/',
    'meridiem' => ['dopoludnia', 'popoludnÃƒÂ­'],
];
