<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - GlaviÃ„â€¡
 * - Milos Sakovic
 */

use Carbon\CarbonInterface;
use Symfony\Component\Translation\PluralizationRules;

// @codeCoverageIgnoreStart
if (class_exists(PluralizationRules::class)) {
    PluralizationRules::set(static function ($number) {
        return PluralizationRules::get($number, 'sr');
    }, 'sr_Cyrl_ME');
}
// @codeCoverageIgnoreEnd

return [
    'year' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂµ|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°',
    'y' => ':count ÃÂ³.',
    'month' => ':count ÃÂ¼Ã‘ËœÃÂµÃ‘ÂÃÂµÃ‘â€ |:count ÃÂ¼Ã‘ËœÃÂµÃ‘ÂÃÂµÃ‘â€ ÃÂ°|:count ÃÂ¼Ã‘ËœÃÂµÃ‘ÂÃÂµÃ‘â€ ÃÂ¸',
    'm' => ':count ÃÂ¼Ã‘Ëœ.',
    'week' => ':count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂ°|:count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂµ|:count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂ°',
    'w' => ':count ÃÂ½ÃÂµÃÂ´.',
    'day' => ':count ÃÂ´ÃÂ°ÃÂ½|:count ÃÂ´ÃÂ°ÃÂ½ÃÂ°|:count ÃÂ´ÃÂ°ÃÂ½ÃÂ°',
    'd' => ':count ÃÂ´.',
    'hour' => ':count Ã‘ÂÃÂ°Ã‘â€š|:count Ã‘ÂÃÂ°Ã‘â€šÃÂ°|:count Ã‘ÂÃÂ°Ã‘â€šÃÂ¸',
    'h' => ':count Ã‘â€¡.',
    'minute' => ':count ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€š|:count ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°|:count ÃÂ¼ÃÂ¸ÃÂ½Ã‘Æ’Ã‘â€šÃÂ°',
    'min' => ':count ÃÂ¼ÃÂ¸ÃÂ½.',
    'second' => ':count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂµ|:count Ã‘ÂÃÂµÃÂºÃ‘Æ’ÃÂ½ÃÂ´ÃÂ¸',
    's' => ':count Ã‘ÂÃÂµÃÂº.',
    'ago' => 'ÃÂ¿Ã‘â‚¬ÃÂ¸Ã‘ËœÃÂµ :time',
    'from_now' => 'ÃÂ·ÃÂ° :time',
    'after' => ':time ÃÂ½ÃÂ°ÃÂºÃÂ¾ÃÂ½',
    'before' => ':time ÃÂ¿Ã‘â‚¬ÃÂ¸Ã‘ËœÃÂµ',

    'year_from_now' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂµ|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°',
    'year_ago' => ':count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½Ã‘Æ’|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂµ|:count ÃÂ³ÃÂ¾ÃÂ´ÃÂ¸ÃÂ½ÃÂ°',

    'week_from_now' => ':count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢Ã‘Æ’|:count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂµ|:count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂ°',
    'week_ago' => ':count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢Ã‘Æ’|:count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂµ|:count ÃÂ½ÃÂµÃÂ´Ã‘ËœÃÂµÃ‘â„¢ÃÂ°',

    'diff_now' => 'Ã‘Æ’ÃÂ¿Ã‘â‚¬ÃÂ°ÃÂ²ÃÂ¾ Ã‘ÂÃÂ°ÃÂ´ÃÂ°',
    'diff_today' => 'ÃÂ´ÃÂ°ÃÂ½ÃÂ°Ã‘Â',
    'diff_today_regexp' => 'ÃÂ´ÃÂ°ÃÂ½ÃÂ°Ã‘Â(?:\\s+Ã‘Æ’)?',
    'diff_yesterday' => 'Ã‘ËœÃ‘Æ’Ã‘â€¡ÃÂµ',
    'diff_yesterday_regexp' => 'Ã‘ËœÃ‘Æ’Ã‘â€¡ÃÂµ(?:\\s+Ã‘Æ’)?',
    'diff_tomorrow' => 'Ã‘ÂÃ‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ°',
    'diff_tomorrow_regexp' => 'Ã‘ÂÃ‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ°(?:\\s+Ã‘Æ’)?',
    'diff_before_yesterday' => 'ÃÂ¿Ã‘â‚¬ÃÂµÃÂºÃ‘ËœÃ‘Æ’Ã‘â€¡ÃÂµ',
    'diff_after_tomorrow' => 'ÃÂ¿Ã‘â‚¬ÃÂµÃÂºÃÂ¾Ã‘ÂÃ‘ËœÃ‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ°',
    'formats' => [
        'LT' => 'H:mm',
        'LTS' => 'H:mm:ss',
        'L' => 'DD.MM.YYYY',
        'LL' => 'D. MMMM YYYY',
        'LLL' => 'D. MMMM YYYY H:mm',
        'LLLL' => 'dddd, D. MMMM YYYY H:mm',
    ],
    'calendar' => [
        'sameDay' => '[ÃÂ´ÃÂ°ÃÂ½ÃÂ°Ã‘Â Ã‘Æ’] LT',
        'nextDay' => '[Ã‘ÂÃ‘Æ’Ã‘â€šÃ‘â‚¬ÃÂ° Ã‘Æ’] LT',
        'nextWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0 => '[Ã‘Æ’ ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢Ã‘Æ’ Ã‘Æ’] LT',
            3 => '[Ã‘Æ’ Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´Ã‘Æ’ Ã‘Æ’] LT',
            6 => '[Ã‘Æ’ Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃ‘Æ’ Ã‘Æ’] LT',
            default => '[Ã‘Æ’] dddd [Ã‘Æ’] LT',
        },
        'lastDay' => '[Ã‘ËœÃ‘Æ’Ã‘â€¡ÃÂµ Ã‘Æ’] LT',
        'lastWeek' => static fn (CarbonInterface $date) => match ($date->dayOfWeek) {
            0 => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂµ ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂµ Ã‘Æ’] LT',
            1 => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³ ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂºÃÂ° Ã‘Æ’] LT',
            2 => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³ Ã‘Æ’Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂºÃÂ° Ã‘Æ’] LT',
            3 => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂµ Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂµ Ã‘Æ’] LT',
            4 => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³ Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂºÃÂ° Ã‘Æ’] LT',
            5 => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂ¾ÃÂ³ ÃÂ¿ÃÂµÃ‘â€šÃÂºÃÂ° Ã‘Æ’] LT',
            default => '[ÃÂ¿Ã‘â‚¬ÃÂ¾Ã‘Ë†ÃÂ»ÃÂµ Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂµ Ã‘Æ’] LT',
        },
        'sameElse' => 'L',
    ],
    'ordinal' => ':number.',
    'months' => ['Ã‘ËœÃÂ°ÃÂ½Ã‘Æ’ÃÂ°Ã‘â‚¬', 'Ã‘â€žÃÂµÃÂ±Ã‘â‚¬Ã‘Æ’ÃÂ°Ã‘â‚¬', 'ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š', 'ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂ¸ÃÂ»', 'ÃÂ¼ÃÂ°Ã‘Ëœ', 'Ã‘ËœÃ‘Æ’ÃÂ½', 'Ã‘ËœÃ‘Æ’ÃÂ»', 'ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š', 'Ã‘ÂÃÂµÃÂ¿Ã‘â€šÃÂµÃÂ¼ÃÂ±ÃÂ°Ã‘â‚¬', 'ÃÂ¾ÃÂºÃ‘â€šÃÂ¾ÃÂ±ÃÂ°Ã‘â‚¬', 'ÃÂ½ÃÂ¾ÃÂ²ÃÂµÃÂ¼ÃÂ±ÃÂ°Ã‘â‚¬', 'ÃÂ´ÃÂµÃ‘â€ ÃÂµÃÂ¼ÃÂ±ÃÂ°Ã‘â‚¬'],
    'months_short' => ['Ã‘ËœÃÂ°ÃÂ½.', 'Ã‘â€žÃÂµÃÂ±.', 'ÃÂ¼ÃÂ°Ã‘â‚¬.', 'ÃÂ°ÃÂ¿Ã‘â‚¬.', 'ÃÂ¼ÃÂ°Ã‘Ëœ', 'Ã‘ËœÃ‘Æ’ÃÂ½', 'Ã‘ËœÃ‘Æ’ÃÂ»', 'ÃÂ°ÃÂ²ÃÂ³.', 'Ã‘ÂÃÂµÃÂ¿.', 'ÃÂ¾ÃÂºÃ‘â€š.', 'ÃÂ½ÃÂ¾ÃÂ².', 'ÃÂ´ÃÂµÃ‘â€ .'],
    'weekdays' => ['ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°', 'ÃÂ¿ÃÂ¾ÃÂ½ÃÂµÃÂ´ÃÂµÃ‘â„¢ÃÂ°ÃÂº', 'Ã‘Æ’Ã‘â€šÃÂ¾Ã‘â‚¬ÃÂ°ÃÂº', 'Ã‘ÂÃ‘â‚¬ÃÂµÃÂ´ÃÂ°', 'Ã‘â€¡ÃÂµÃ‘â€šÃÂ²Ã‘â‚¬Ã‘â€šÃÂ°ÃÂº', 'ÃÂ¿ÃÂµÃ‘â€šÃÂ°ÃÂº', 'Ã‘ÂÃ‘Æ’ÃÂ±ÃÂ¾Ã‘â€šÃÂ°'],
    'weekdays_short' => ['ÃÂ½ÃÂµÃÂ´.', 'ÃÂ¿ÃÂ¾ÃÂ½.', 'Ã‘Æ’Ã‘â€šÃÂ¾.', 'Ã‘ÂÃ‘â‚¬ÃÂµ.', 'Ã‘â€¡ÃÂµÃ‘â€š.', 'ÃÂ¿ÃÂµÃ‘â€š.', 'Ã‘ÂÃ‘Æ’ÃÂ±.'],
    'weekdays_min' => ['ÃÂ½ÃÂµ', 'ÃÂ¿ÃÂ¾', 'Ã‘Æ’Ã‘â€š', 'Ã‘ÂÃ‘â‚¬', 'Ã‘â€¡ÃÂµ', 'ÃÂ¿ÃÂµ', 'Ã‘ÂÃ‘Æ’'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' ÃÂ¸ '],
    'meridiem' => ['ÃÂÃÅ“', 'ÃÅ¸ÃÅ“'],
];
