<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - FranÃƒÂ§ois B
 * - Kristoffer Snabb
 * - JD Isaacks
 * - Jens Herlevsen
 * - Nightpine
 * - Anders Nygren (litemerafrukt)
 */
return [
    'year' => ':count ÃƒÂ¥r',
    'a_year' => 'ett ÃƒÂ¥r|:count ÃƒÂ¥r',
    'y' => ':count ÃƒÂ¥r',
    'month' => ':count mÃƒÂ¥nad|:count mÃƒÂ¥nader',
    'a_month' => 'en mÃƒÂ¥nad|:count mÃƒÂ¥nader',
    'm' => ':count mÃƒÂ¥n',
    'week' => ':count vecka|:count veckor',
    'a_week' => 'en vecka|:count veckor',
    'w' => ':count v',
    'day' => ':count dag|:count dagar',
    'a_day' => 'en dag|:count dagar',
    'd' => ':count dgr',
    'hour' => ':count timme|:count timmar',
    'a_hour' => 'en timme|:count timmar',
    'h' => ':count tim',
    'minute' => ':count minut|:count minuter',
    'a_minute' => 'en minut|:count minuter',
    'min' => ':count min',
    'second' => ':count sekund|:count sekunder',
    'a_second' => 'nÃƒÂ¥gra sekunder|:count sekunder',
    's' => ':count s',
    'ago' => 'fÃƒÂ¶r :time sedan',
    'from_now' => 'om :time',
    'after' => ':time efter',
    'before' => ':time fÃƒÂ¶re',
    'diff_now' => 'nu',
    'diff_today' => 'I dag',
    'diff_yesterday' => 'i gÃƒÂ¥r',
    'diff_yesterday_regexp' => 'I gÃƒÂ¥r',
    'diff_tomorrow' => 'i morgon',
    'diff_tomorrow_regexp' => 'I morgon',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'YYYY-MM-DD',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY [kl.] HH:mm',
        'LLLL' => 'dddd D MMMM YYYY [kl.] HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[I dag] LT',
        'nextDay' => '[I morgon] LT',
        'nextWeek' => '[PÃƒÂ¥] dddd LT',
        'lastDay' => '[I gÃƒÂ¥r] LT',
        'lastWeek' => '[I] dddd[s] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number) {
        $lastDigit = $number % 10;

        return $number.(
            ((int) ($number % 100 / 10) === 1) ? 'e' : (
                ($lastDigit === 1 || $lastDigit === 2) ? 'a' : 'e'
            )
        );
    },
    'months' => ['januari', 'februari', 'mars', 'april', 'maj', 'juni', 'juli', 'augusti', 'september', 'oktober', 'november', 'december'],
    'months_short' => ['jan', 'feb', 'mar', 'apr', 'maj', 'jun', 'jul', 'aug', 'sep', 'okt', 'nov', 'dec'],
    'weekdays' => ['sÃƒÂ¶ndag', 'mÃƒÂ¥ndag', 'tisdag', 'onsdag', 'torsdag', 'fredag', 'lÃƒÂ¶rdag'],
    'weekdays_short' => ['sÃƒÂ¶n', 'mÃƒÂ¥n', 'tis', 'ons', 'tors', 'fre', 'lÃƒÂ¶r'],
    'weekdays_min' => ['sÃƒÂ¶', 'mÃƒÂ¥', 'ti', 'on', 'to', 'fr', 'lÃƒÂ¶'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => [', ', ' och '],
    'meridiem' => ['fm', 'em'],
];
