<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Orif N. Jr
 */
return [
    'year' => '{1}Ã‘ÂÃÂº Ã‘ÂÃÂ¾ÃÂ»|:count Ã‘ÂÃÂ¾ÃÂ»',
    'month' => '{1}Ã‘ÂÃÂº ÃÂ¼ÃÂ¾Ã’Â³|:count ÃÂ¼ÃÂ¾Ã’Â³',
    'week' => '{1}Ã‘ÂÃÂº Ã’Â³ÃÂ°Ã‘â€žÃ‘â€šÃÂ°|:count Ã’Â³ÃÂ°Ã‘â€žÃ‘â€šÃÂ°',
    'day' => '{1}Ã‘ÂÃÂº Ã‘â‚¬Ã“Â¯ÃÂ·|:count Ã‘â‚¬Ã“Â¯ÃÂ·',
    'hour' => '{1}Ã‘ÂÃÂº Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š|:count Ã‘ÂÃÂ¾ÃÂ°Ã‘â€š',
    'minute' => '{1}Ã‘ÂÃÂº ÃÂ´ÃÂ°Ã’â€ºÃÂ¸Ã’â€ºÃÂ°|:count ÃÂ´ÃÂ°Ã’â€ºÃÂ¸Ã’â€ºÃÂ°',
    'second' => '{1}Ã‘ÂÃÂºÃ‘â€¡ÃÂ°ÃÂ½ÃÂ´ Ã‘ÂÃÂ¾ÃÂ½ÃÂ¸Ã‘Â|:count Ã‘ÂÃÂ¾ÃÂ½ÃÂ¸Ã‘Â',
    'ago' => ':time ÃÂ¿ÃÂµÃ‘Ë†',
    'from_now' => 'ÃÂ±ÃÂ°Ã‘Å ÃÂ´ÃÂ¸ :time',
    'diff_today' => 'ÃËœÃÂ¼Ã‘â‚¬Ã“Â¯ÃÂ·',
    'diff_yesterday' => 'Ãâ€ÃÂ¸Ã‘â‚¬Ã“Â¯ÃÂ·',
    'diff_yesterday_regexp' => 'Ãâ€ÃÂ¸Ã‘â‚¬Ã“Â¯ÃÂ·(?:\\s+Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸)?',
    'diff_tomorrow' => 'ÃÅ¸ÃÂ°ÃÂ³ÃÂ¾Ã’Â³',
    'diff_tomorrow_regexp' => 'ÃÅ¸ÃÂ°ÃÂ³ÃÂ¾Ã’Â³(?:\\s+Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸)?',
    'diff_today_regexp' => 'ÃËœÃÂ¼Ã‘â‚¬Ã“Â¯ÃÂ·(?:\\s+Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸)?',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'DD/MM/YYYY',
        'LL' => 'D MMMM YYYY',
        'LLL' => 'D MMMM YYYY HH:mm',
        'LLLL' => 'dddd, D MMMM YYYY HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[ÃËœÃÂ¼Ã‘â‚¬Ã“Â¯ÃÂ· Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸] LT',
        'nextDay' => '[ÃÅ¸ÃÂ°ÃÂ³ÃÂ¾Ã’Â³ Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸] LT',
        'nextWeek' => 'dddd[ÃÂ¸] [Ã’Â³ÃÂ°Ã‘â€žÃ‘â€šÃÂ°ÃÂ¸ ÃÂ¾Ã‘ÂÃÂ½ÃÂ´ÃÂ° Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸] LT',
        'lastDay' => '[Ãâ€ÃÂ¸Ã‘â‚¬Ã“Â¯ÃÂ· Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸] LT',
        'lastWeek' => 'dddd[ÃÂ¸] [Ã’Â³ÃÂ°Ã‘â€žÃ‘â€šÃÂ°ÃÂ¸ ÃÂ³Ã‘Æ’ÃÂ·ÃÂ°Ã‘Ë†Ã‘â€šÃÂ° Ã‘ÂÃÂ¾ÃÂ°Ã‘â€šÃÂ¸] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number) {
        if ($number === 0) { // special case for zero
            return "$number-Ã„Â±ncÃ„Â±";
        }

        static $suffixes = [
            0 => '-Ã‘Æ’ÃÂ¼',
            1 => '-Ã‘Æ’ÃÂ¼',
            2 => '-Ã‘Å½ÃÂ¼',
            3 => '-Ã‘Å½ÃÂ¼',
            4 => '-Ã‘Æ’ÃÂ¼',
            5 => '-Ã‘Æ’ÃÂ¼',
            6 => '-Ã‘Æ’ÃÂ¼',
            7 => '-Ã‘Æ’ÃÂ¼',
            8 => '-Ã‘Æ’ÃÂ¼',
            9 => '-Ã‘Æ’ÃÂ¼',
            10 => '-Ã‘Æ’ÃÂ¼',
            12 => '-Ã‘Æ’ÃÂ¼',
            13 => '-Ã‘Æ’ÃÂ¼',
            20 => '-Ã‘Æ’ÃÂ¼',
            30 => '-Ã‘Å½ÃÂ¼',
            40 => '-Ã‘Æ’ÃÂ¼',
            50 => '-Ã‘Æ’ÃÂ¼',
            60 => '-Ã‘Æ’ÃÂ¼',
            70 => '-Ã‘Æ’ÃÂ¼',
            80 => '-Ã‘Æ’ÃÂ¼',
            90 => '-Ã‘Æ’ÃÂ¼',
            100 => '-Ã‘Æ’ÃÂ¼',
        ];

        return $number.($suffixes[$number] ?? $suffixes[$number % 10] ?? $suffixes[$number >= 100 ? 100 : -1] ?? '');
    },
    'meridiem' => static function ($hour) {
        if ($hour < 4) {
            return 'Ã‘Ë†ÃÂ°ÃÂ±';
        }
        if ($hour < 11) {
            return 'Ã‘ÂÃ‘Æ’ÃÂ±Ã’Â³';
        }
        if ($hour < 16) {
            return 'Ã‘â‚¬Ã“Â¯ÃÂ·';
        }
        if ($hour < 19) {
            return 'ÃÂ±ÃÂµÃÂ³ÃÂ¾Ã’Â³';
        }

        return 'Ã‘Ë†ÃÂ°ÃÂ±';
    },
    'months' => ['Ã‘ÂÃÂ½ÃÂ²ÃÂ°Ã‘â‚¬', 'Ã‘â€žÃÂµÃÂ²Ã‘â‚¬ÃÂ°ÃÂ»', 'ÃÂ¼ÃÂ°Ã‘â‚¬Ã‘â€š', 'ÃÂ°ÃÂ¿Ã‘â‚¬ÃÂµÃÂ»', 'ÃÂ¼ÃÂ°ÃÂ¹', 'ÃÂ¸Ã‘Å½ÃÂ½', 'ÃÂ¸Ã‘Å½ÃÂ»', 'ÃÂ°ÃÂ²ÃÂ³Ã‘Æ’Ã‘ÂÃ‘â€š', 'Ã‘ÂÃÂµÃÂ½Ã‘â€šÃ‘ÂÃÂ±Ã‘â‚¬', 'ÃÂ¾ÃÂºÃ‘â€šÃ‘ÂÃÂ±Ã‘â‚¬', 'ÃÂ½ÃÂ¾Ã‘ÂÃÂ±Ã‘â‚¬', 'ÃÂ´ÃÂµÃÂºÃÂ°ÃÂ±Ã‘â‚¬'],
    'months_short' => ['Ã‘ÂÃÂ½ÃÂ²', 'Ã‘â€žÃÂµÃÂ²', 'ÃÂ¼ÃÂ°Ã‘â‚¬', 'ÃÂ°ÃÂ¿Ã‘â‚¬', 'ÃÂ¼ÃÂ°ÃÂ¹', 'ÃÂ¸Ã‘Å½ÃÂ½', 'ÃÂ¸Ã‘Å½ÃÂ»', 'ÃÂ°ÃÂ²ÃÂ³', 'Ã‘ÂÃÂµÃÂ½', 'ÃÂ¾ÃÂºÃ‘â€š', 'ÃÂ½ÃÂ¾Ã‘Â', 'ÃÂ´ÃÂµÃÂº'],
    'weekdays' => ['Ã‘ÂÃÂºÃ‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂµ', 'ÃÂ´Ã‘Æ’Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂµ', 'Ã‘ÂÃÂµÃ‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂµ', 'Ã‘â€¡ÃÂ¾Ã‘â‚¬Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂµ', 'ÃÂ¿ÃÂ°ÃÂ½Ã’Â·Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂµ', 'Ã’Â·Ã‘Æ’ÃÂ¼Ã‘Å ÃÂ°', 'Ã‘Ë†ÃÂ°ÃÂ½ÃÂ±ÃÂµ'],
    'weekdays_short' => ['Ã‘ÂÃ‘Ë†ÃÂ±', 'ÃÂ´Ã‘Ë†ÃÂ±', 'Ã‘ÂÃ‘Ë†ÃÂ±', 'Ã‘â€¡Ã‘Ë†ÃÂ±', 'ÃÂ¿Ã‘Ë†ÃÂ±', 'Ã’Â·Ã‘Æ’ÃÂ¼', 'Ã‘Ë†ÃÂ½ÃÂ±'],
    'weekdays_min' => ['Ã‘ÂÃ‘Ë†', 'ÃÂ´Ã‘Ë†', 'Ã‘ÂÃ‘Ë†', 'Ã‘â€¡Ã‘Ë†', 'ÃÂ¿Ã‘Ë†', 'Ã’Â·ÃÂ¼', 'Ã‘Ë†ÃÂ±'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' ÃÂ²ÃÂ° '],
];
