<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Authors:
 * - Ghorban M. Tavakoly Pablo Saratxaga & Ghorban M. Tavakoly pablo@walon.org & gmt314@yahoo.com
 * - SuperManPHP
 * - Maksat Meredow (isadma)
 */
$transformDiff = static fn (string $input) => strtr($input, [
    'sekunt' => 'sekunt',
    'hepde' => 'hepde',
]);

return array_replace_recursive(require __DIR__.'/en.php', [
    'formats' => [
        'L' => 'DD.MM.YYYY',
    ],
    'months' => ['ÃƒÂanwar', 'Fewral', 'Mart', 'Aprel', 'MaÃƒÂ½', 'IÃƒÂ½un', 'IÃƒÂ½ul', 'Awgust', 'SentÃƒÂ½abr', 'OktÃƒÂ½abr', 'NoÃƒÂ½abr', 'Dekabr'],
    'months_short' => ['ÃƒÂan', 'Few', 'Mar', 'Apr', 'MaÃƒÂ½', 'IÃƒÂ½n', 'IÃƒÂ½l', 'Awg', 'Sen', 'Okt', 'NoÃƒÂ½', 'Dek'],
    'weekdays' => ['ÃƒÂekÃ…Å¸enbe', 'DuÃ…Å¸enbe', 'SiÃ…Å¸enbe', 'Ãƒâ€¡arÃ…Å¸enbe', 'PenÃ…Å¸enbe', 'Anna', 'Ã…Å¾enbe'],
    'weekdays_short' => ['ÃƒÂek', 'DuÃ…Å¸', 'SiÃ…Å¸', 'Ãƒâ€¡ar', 'Pen', 'Ann', 'Ã…Å¾en'],
    'weekdays_min' => ['ÃƒÂe', 'Du', 'Si', 'Ãƒâ€¡a', 'Pe', 'An', 'Ã…Å¾e'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,

    'year' => ':count ÃƒÂ½yl',
    'y' => ':count ÃƒÂ½yl',
    'a_year' => ':count ÃƒÂ½yl',

    'month' => ':count aÃƒÂ½',
    'm' => ':count aÃƒÂ½',
    'a_month' => ':count aÃƒÂ½',

    'week' => ':count hepde',
    'w' => ':count hepde',
    'a_week' => ':count hepde',

    'day' => ':count gÃƒÂ¼n',
    'd' => ':count gÃƒÂ¼n',
    'a_day' => ':count gÃƒÂ¼n',

    'hour' => ':count sagat',
    'h' => ':count sagat',
    'a_hour' => ':count sagat',

    'minute' => ':count minut',
    'min' => ':count minut',
    'a_minute' => ':count minut',

    'second' => ':count sekunt',
    's' => ':count sekunt',
    'a_second' => ':count sekunt',

    'ago' => static fn (string $time) => $transformDiff($time).' ozal',
    'from_now' => static fn (string $time) => $transformDiff($time).' soÃ…Ë†ra',
    'after' => static fn (string $time) => $transformDiff($time).' soÃ…Ë†',
    'before' => static fn (string $time) => $transformDiff($time).' ÃƒÂ¶Ã…Ë†',
]);
