<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Philippe Vaucher
 * - Tsutomu Kuroda
 * - yasinn
 */
return [
    'year' => '{1}'.'Ã˜Â¨Ã™â€°Ã˜Â± Ã™Å Ã™â€°Ã™â€ž'.'|:count '.'Ã™Å Ã™â€°Ã™â€ž',
    'month' => '{1}'.'Ã˜Â¨Ã™â€°Ã˜Â± Ã˜Â¦Ã˜Â§Ã™Å '.'|:count '.'Ã˜Â¦Ã˜Â§Ã™Å ',
    'week' => '{1}'.'Ã˜Â¨Ã™â€°Ã˜Â± ÃšÂ¾Ã›â€¢Ã™Â¾Ã˜ÂªÃ›â€¢'.'|:count '.'ÃšÂ¾Ã›â€¢Ã™Â¾Ã˜ÂªÃ›â€¢',
    'day' => '{1}'.'Ã˜Â¨Ã™â€°Ã˜Â± Ã™Æ’Ã›Ë†Ã™â€ '.'|:count '.'Ã™Æ’Ã›Ë†Ã™â€ ',
    'hour' => '{1}'.'Ã˜Â¨Ã™â€°Ã˜Â± Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª'.'|:count '.'Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª',
    'minute' => '{1}'.'Ã˜Â¨Ã™â€°Ã˜Â± Ã™â€¦Ã™â€°Ã™â€ Ã›â€¡Ã˜Âª'.'|:count '.'Ã™â€¦Ã™â€°Ã™â€ Ã›â€¡Ã˜Âª',
    'second' => '{1}'.'Ã™â€ Ã›â€¢Ãšâ€ Ãšâ€ Ã›â€¢ Ã˜Â³Ã›ÂÃ™Æ’Ã™Ë†Ã™â€ Ã˜Âª'.'|:count '.'Ã˜Â³Ã›ÂÃ™Æ’Ã™Ë†Ã™â€ Ã˜Âª',
    'ago' => ':time Ã˜Â¨Ã›â€¡Ã˜Â±Ã›â€¡Ã™â€ ',
    'from_now' => ':time Ã™Æ’Ã›ÂÃ™Å Ã™â€°Ã™â€ ',
    'diff_today' => 'Ã˜Â¨Ã›Ë†ÃšÂ¯Ã›Ë†Ã™â€ ',
    'diff_yesterday' => 'Ã˜ÂªÃ›â€ Ã™â€ Ã›Ë†ÃšÂ¯Ã›Ë†Ã™â€ ',
    'diff_tomorrow' => 'Ã˜Â¦Ã›â€¢Ã˜ÂªÃ›â€¢',
    'diff_tomorrow_regexp' => 'Ã˜Â¦Ã›â€¢Ã˜ÂªÃ›â€¢(?:\\s+Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª)?',
    'diff_today_regexp' => 'Ã˜Â¨Ã›Ë†ÃšÂ¯Ã›Ë†Ã™â€ (?:\\s+Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª)?',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'YYYY-MM-DD',
        'LL' => 'YYYY-Ã™Å Ã™â€°Ã™â€žÃ™â€°M-Ã˜Â¦Ã˜Â§Ã™Å Ã™â€ Ã™â€°ÃšÂ­D-Ã™Æ’Ã›Ë†Ã™â€ Ã™â€°',
        'LLL' => 'YYYY-Ã™Å Ã™â€°Ã™â€žÃ™â€°M-Ã˜Â¦Ã˜Â§Ã™Å Ã™â€ Ã™â€°ÃšÂ­D-Ã™Æ’Ã›Ë†Ã™â€ Ã™â€°Ã˜Å’ HH:mm',
        'LLLL' => 'ddddÃ˜Å’ YYYY-Ã™Å Ã™â€°Ã™â€žÃ™â€°M-Ã˜Â¦Ã˜Â§Ã™Å Ã™â€ Ã™â€°ÃšÂ­D-Ã™Æ’Ã›Ë†Ã™â€ Ã™â€°Ã˜Å’ HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Ã˜Â¨Ã›Ë†ÃšÂ¯Ã›Ë†Ã™â€  Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª] LT',
        'nextDay' => '[Ã˜Â¦Ã›â€¢Ã˜ÂªÃ›â€¢ Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª] LT',
        'nextWeek' => '[Ã™Æ’Ã›ÂÃ™â€žÃ›â€¢Ã˜Â±Ã™Æ’Ã™â€°] dddd [Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª] LT',
        'lastDay' => '[Ã˜ÂªÃ›â€ Ã™â€ Ã›Ë†ÃšÂ¯Ã›Ë†Ã™â€ ] LT',
        'lastWeek' => '[Ã˜Â¦Ã˜Â§Ã™â€žÃ˜Â¯Ã™â€°Ã™â€ Ã™â€šÃ™â€°] dddd [Ã˜Â³Ã˜Â§Ã˜Â¦Ã›â€¢Ã˜Âª] LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number, $period) {
        return match ($period) {
            'd', 'D', 'DDD' => $number.'-Ã™Æ’Ã›Ë†Ã™â€ Ã™â€°',
            'w', 'W' => $number.'-ÃšÂ¾Ã›â€¢Ã™Â¾Ã˜ÂªÃ›â€¢',
            default => $number,
        };
    },
    'meridiem' => static function ($hour, $minute) {
        $time = $hour * 100 + $minute;
        if ($time < 600) {
            return 'Ã™Å Ã›ÂÃ˜Â±Ã™â€°Ã™â€¦ Ã™Æ’Ã›ÂÃšâ€ Ã›â€¢';
        }
        if ($time < 900) {
            return 'Ã˜Â³Ã›â€¢ÃšÂ¾Ã›â€¢Ã˜Â±';
        }
        if ($time < 1130) {
            return 'Ãšâ€ Ã›Ë†Ã˜Â´Ã˜ÂªÃ™â€°Ã™â€  Ã˜Â¨Ã›â€¡Ã˜Â±Ã›â€¡Ã™â€ ';
        }
        if ($time < 1230) {
            return 'Ãšâ€ Ã›Ë†Ã˜Â´';
        }
        if ($time < 1800) {
            return 'Ãšâ€ Ã›Ë†Ã˜Â´Ã˜ÂªÃ™â€°Ã™â€  Ã™Æ’Ã›ÂÃ™Å Ã™â€°Ã™â€ ';
        }

        return 'Ã™Æ’Ã›â€¢Ãšâ€ ';
    },
    'months' => ['Ã™Å Ã˜Â§Ã™â€ Ã›â€¹Ã˜Â§Ã˜Â±', 'Ã™ÂÃ›ÂÃ›â€¹Ã˜Â±Ã˜Â§Ã™â€ž', 'Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Âª', 'Ã˜Â¦Ã˜Â§Ã™Â¾Ã˜Â±Ã›ÂÃ™â€ž', 'Ã™â€¦Ã˜Â§Ã™Å ', 'Ã˜Â¦Ã™â€°Ã™Å Ã›â€¡Ã™â€ ', 'Ã˜Â¦Ã™â€°Ã™Å Ã›â€¡Ã™â€ž', 'Ã˜Â¦Ã˜Â§Ã›â€¹Ã˜ÂºÃ›â€¡Ã˜Â³Ã˜Âª', 'Ã˜Â³Ã›ÂÃ™â€ Ã˜ÂªÃ›â€¢Ã˜Â¨Ã™â€°Ã˜Â±', 'Ã˜Â¦Ã›â€ Ã™Æ’Ã˜ÂªÃ›â€¢Ã˜Â¨Ã™â€°Ã˜Â±', 'Ã™â€ Ã™Ë†Ã™Å Ã˜Â§Ã˜Â¨Ã™â€°Ã˜Â±', 'Ã˜Â¯Ã›ÂÃ™Æ’Ã˜Â§Ã˜Â¨Ã™â€°Ã˜Â±'],
    'months_short' => ['Ã™Å Ã˜Â§Ã™â€ Ã›â€¹Ã˜Â§Ã˜Â±', 'Ã™ÂÃ›ÂÃ›â€¹Ã˜Â±Ã˜Â§Ã™â€ž', 'Ã™â€¦Ã˜Â§Ã˜Â±Ã˜Âª', 'Ã˜Â¦Ã˜Â§Ã™Â¾Ã˜Â±Ã›ÂÃ™â€ž', 'Ã™â€¦Ã˜Â§Ã™Å ', 'Ã˜Â¦Ã™â€°Ã™Å Ã›â€¡Ã™â€ ', 'Ã˜Â¦Ã™â€°Ã™Å Ã›â€¡Ã™â€ž', 'Ã˜Â¦Ã˜Â§Ã›â€¹Ã˜ÂºÃ›â€¡Ã˜Â³Ã˜Âª', 'Ã˜Â³Ã›ÂÃ™â€ Ã˜ÂªÃ›â€¢Ã˜Â¨Ã™â€°Ã˜Â±', 'Ã˜Â¦Ã›â€ Ã™Æ’Ã˜ÂªÃ›â€¢Ã˜Â¨Ã™â€°Ã˜Â±', 'Ã™â€ Ã™Ë†Ã™Å Ã˜Â§Ã˜Â¨Ã™â€°Ã˜Â±', 'Ã˜Â¯Ã›ÂÃ™Æ’Ã˜Â§Ã˜Â¨Ã™â€°Ã˜Â±'],
    'weekdays' => ['Ã™Å Ã›â€¢Ã™Æ’Ã˜Â´Ã›â€¢Ã™â€ Ã˜Â¨Ã›â€¢', 'Ã˜Â¯Ã›Ë†Ã˜Â´Ã›â€¢Ã™â€ Ã˜Â¨Ã›â€¢', 'Ã˜Â³Ã›â€¢Ã™Å Ã˜Â´Ã›â€¢Ã™â€ Ã˜Â¨Ã›â€¢', 'Ãšâ€ Ã˜Â§Ã˜Â±Ã˜Â´Ã›â€¢Ã™â€ Ã˜Â¨Ã›â€¢', 'Ã™Â¾Ã›â€¢Ã™Å Ã˜Â´Ã›â€¢Ã™â€ Ã˜Â¨Ã›â€¢', 'Ã˜Â¬Ã›Ë†Ã™â€¦Ã›â€¢', 'Ã˜Â´Ã›â€¢Ã™â€ Ã˜Â¨Ã›â€¢'],
    'weekdays_short' => ['Ã™Å Ã›â€¢', 'Ã˜Â¯Ã›Ë†', 'Ã˜Â³Ã›â€¢', 'Ãšâ€ Ã˜Â§', 'Ã™Â¾Ã›â€¢', 'Ã˜Â¬Ã›Ë†', 'Ã˜Â´Ã›â€¢'],
    'weekdays_min' => ['Ã™Å Ã›â€¢', 'Ã˜Â¯Ã›Ë†', 'Ã˜Â³Ã›â€¢', 'Ãšâ€ Ã˜Â§', 'Ã™Â¾Ã›â€¢', 'Ã˜Â¬Ã›Ë†', 'Ã˜Â´Ã›â€¢'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 1,
    'list' => [', ', ' Ã›â€¹Ã›â€¢ '],
];
