<?php

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/*
 * Authors:
 * - Adam
 * - monkeycon
 * - FranÃƒÂ§ois B
 * - Jason Katz-Brown
 * - Chris Lam
 * - Serhan ApaydÃ„Â±n
 * - Gary Lo
 * - JD Isaacks
 * - Chris Hemp
 * - Eddie
 * - KID
 * - shankesgk2
 * - Daniel Cheung (danvim)
 */
return [
    'year' => ':count:optional-spaceÃ¥Â¹Â´',
    'y' => ':count:optional-spaceÃ¥Â¹Â´',
    'month' => ':count:optional-spaceÃ¥â‚¬â€¹Ã¦Å“Ë†',
    'm' => ':count:optional-spaceÃ¦Å“Ë†',
    'week' => ':count:optional-spaceÃ©â‚¬Â±',
    'w' => ':count:optional-spaceÃ©â‚¬Â±',
    'day' => ':count:optional-spaceÃ¥Â¤Â©',
    'd' => ':count:optional-spaceÃ¥Â¤Â©',
    'hour' => ':count:optional-spaceÃ¥Â°ÂÃ¦â„¢â€š',
    'h' => ':count:optional-spaceÃ¥Â°ÂÃ¦â„¢â€š',
    'minute' => ':count:optional-spaceÃ¥Ë†â€ Ã©ÂËœ',
    'min' => ':count:optional-spaceÃ¥Ë†â€ Ã©ÂËœ',
    'second' => ':count:optional-spaceÃ§Â§â€™',
    'a_second' => '{1}Ã¥Â¹Â¾Ã§Â§â€™|[-Inf,Inf]:count:optional-spaceÃ§Â§â€™',
    's' => ':count:optional-spaceÃ§Â§â€™',
    'ago' => ':timeÃ¥â€°Â',
    'from_now' => ':timeÃ¥Â¾Å’',
    'after' => ':timeÃ¥Â¾Å’',
    'before' => ':timeÃ¥â€°Â',
    'diff_now' => 'Ã§ÂÂ¾Ã¥Å“Â¨',
    'diff_today' => 'Ã¤Â»Å Ã¥Â¤Â©',
    'diff_yesterday' => 'Ã¦ËœÂ¨Ã¥Â¤Â©',
    'diff_tomorrow' => 'Ã¦ËœÅ½Ã¥Â¤Â©',
    'formats' => [
        'LT' => 'HH:mm',
        'LTS' => 'HH:mm:ss',
        'L' => 'YYYY/MM/DD',
        'LL' => 'YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥',
        'LLL' => 'YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥ HH:mm',
        'LLLL' => 'YYYYÃ¥Â¹Â´MÃ¦Å“Ë†DÃ¦â€”Â¥dddd HH:mm',
    ],
    'calendar' => [
        'sameDay' => '[Ã¤Â»Å Ã¥Â¤Â©] LT',
        'nextDay' => '[Ã¦ËœÅ½Ã¥Â¤Â©] LT',
        'nextWeek' => '[Ã¤Â¸â€¹]dddd LT',
        'lastDay' => '[Ã¦ËœÂ¨Ã¥Â¤Â©] LT',
        'lastWeek' => '[Ã¤Â¸Å ]dddd LT',
        'sameElse' => 'L',
    ],
    'ordinal' => static function ($number, $period) {
        return match ($period) {
            'd', 'D', 'DDD' => $number.'Ã¦â€”Â¥',
            'M' => $number.'Ã¦Å“Ë†',
            'w', 'W' => $number.'Ã¥â€˜Â¨',
            default => $number,
        };
    },
    'meridiem' => static function ($hour, $minute) {
        $time = $hour * 100 + $minute;
        if ($time < 600) {
            return 'Ã¥â€¡Å’Ã¦â„¢Â¨';
        }
        if ($time < 900) {
            return 'Ã¦â€”Â©Ã¤Â¸Å ';
        }
        if ($time < 1130) {
            return 'Ã¤Â¸Å Ã¥ÂË†';
        }
        if ($time < 1230) {
            return 'Ã¤Â¸Â­Ã¥ÂË†';
        }
        if ($time < 1800) {
            return 'Ã¤Â¸â€¹Ã¥ÂË†';
        }

        return 'Ã¦â„¢Å¡Ã¤Â¸Å ';
    },
    'months' => ['Ã¤Â¸â‚¬Ã¦Å“Ë†', 'Ã¤ÂºÅ’Ã¦Å“Ë†', 'Ã¤Â¸â€°Ã¦Å“Ë†', 'Ã¥â€ºâ€ºÃ¦Å“Ë†', 'Ã¤Âºâ€Ã¦Å“Ë†', 'Ã¥â€¦Â­Ã¦Å“Ë†', 'Ã¤Â¸Æ’Ã¦Å“Ë†', 'Ã¥â€¦Â«Ã¦Å“Ë†', 'Ã¤Â¹ÂÃ¦Å“Ë†', 'Ã¥ÂÂÃ¦Å“Ë†', 'Ã¥ÂÂÃ¤Â¸â‚¬Ã¦Å“Ë†', 'Ã¥ÂÂÃ¤ÂºÅ’Ã¦Å“Ë†'],
    'months_short' => ['1Ã¦Å“Ë†', '2Ã¦Å“Ë†', '3Ã¦Å“Ë†', '4Ã¦Å“Ë†', '5Ã¦Å“Ë†', '6Ã¦Å“Ë†', '7Ã¦Å“Ë†', '8Ã¦Å“Ë†', '9Ã¦Å“Ë†', '10Ã¦Å“Ë†', '11Ã¦Å“Ë†', '12Ã¦Å“Ë†'],
    'weekdays' => ['Ã¦ËœÅ¸Ã¦Å“Å¸Ã¦â€”Â¥', 'Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Â¸â‚¬', 'Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤ÂºÅ’', 'Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Â¸â€°', 'Ã¦ËœÅ¸Ã¦Å“Å¸Ã¥â€ºâ€º', 'Ã¦ËœÅ¸Ã¦Å“Å¸Ã¤Âºâ€', 'Ã¦ËœÅ¸Ã¦Å“Å¸Ã¥â€¦Â­'],
    'weekdays_short' => ['Ã©â‚¬Â±Ã¦â€”Â¥', 'Ã©â‚¬Â±Ã¤Â¸â‚¬', 'Ã©â‚¬Â±Ã¤ÂºÅ’', 'Ã©â‚¬Â±Ã¤Â¸â€°', 'Ã©â‚¬Â±Ã¥â€ºâ€º', 'Ã©â‚¬Â±Ã¤Âºâ€', 'Ã©â‚¬Â±Ã¥â€¦Â­'],
    'weekdays_min' => ['Ã¦â€”Â¥', 'Ã¤Â¸â‚¬', 'Ã¤ÂºÅ’', 'Ã¤Â¸â€°', 'Ã¥â€ºâ€º', 'Ã¤Âºâ€', 'Ã¥â€¦Â­'],
    'first_day_of_week' => 1,
    'day_of_first_week_of_year' => 4,
    'list' => '',
];
