<?php

declare(strict_types=1);

/**
 * This file is part of the Carbon package.
 *
 * (c) Brian Nesbitt <brian@nesbot.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

return [
    /*
     * ISO 639-2
     */
    'ab' => [
        'isoName' => 'Abkhazian',
        'nativeName' => 'ÃÂ°Ã’Â§Ã‘ÂÃ‘Æ’ÃÂ° ÃÂ±Ã‘â€¹ÃÂ·Ã‘Ë†Ã“â„¢ÃÂ°, ÃÂ°Ã’Â§Ã‘ÂÃ‘Ë†Ã“â„¢ÃÂ°',
    ],
    'aa' => [
        'isoName' => 'Afar',
        'nativeName' => 'Afaraf',
    ],
    'af' => [
        'isoName' => 'Afrikaans',
        'nativeName' => 'Afrikaans',
    ],
    'ak' => [
        'isoName' => 'Akan',
        'nativeName' => 'Akan',
    ],
    'sq' => [
        'isoName' => 'Albanian',
        'nativeName' => 'Shqip',
    ],
    'am' => [
        'isoName' => 'Amharic',
        'nativeName' => 'Ã¡Å Â Ã¡Ë†â€ºÃ¡Ë†Â­Ã¡Å â€º',
    ],
    'ar' => [
        'isoName' => 'Arabic',
        'nativeName' => 'Ã˜Â§Ã™â€žÃ˜Â¹Ã˜Â±Ã˜Â¨Ã™Å Ã˜Â©',
    ],
    'an' => [
        'isoName' => 'Aragonese',
        'nativeName' => 'aragonÃƒÂ©s',
    ],
    'hy' => [
        'isoName' => 'Armenian',
        'nativeName' => 'Ã•â‚¬Ã•Â¡Ã•ÂµÃ•Â¥Ã–â‚¬Ã•Â¥Ã•Â¶',
    ],
    'as' => [
        'isoName' => 'Assamese',
        'nativeName' => 'Ã Â¦â€¦Ã Â¦Â¸Ã Â¦Â®Ã Â§â‚¬Ã Â¦Â¯Ã Â¦Â¼Ã Â¦Â¾',
    ],
    'av' => [
        'isoName' => 'Avaric',
        'nativeName' => 'ÃÂ°ÃÂ²ÃÂ°Ã‘â‚¬ ÃÂ¼ÃÂ°Ã‘â€ Ã“â‚¬, ÃÂ¼ÃÂ°ÃÂ³Ã“â‚¬ÃÂ°Ã‘â‚¬Ã‘Æ’ÃÂ» ÃÂ¼ÃÂ°Ã‘â€ Ã“â‚¬',
    ],
    'ae' => [
        'isoName' => 'Avestan',
        'nativeName' => 'avesta',
    ],
    'ay' => [
        'isoName' => 'Aymara',
        'nativeName' => 'aymar aru',
    ],
    'az' => [
        'isoName' => 'Azerbaijani',
        'nativeName' => 'azÃ‰â„¢rbaycan dili',
    ],
    'bm' => [
        'isoName' => 'Bambara',
        'nativeName' => 'bamanankan',
    ],
    'ba' => [
        'isoName' => 'Bashkir',
        'nativeName' => 'ÃÂ±ÃÂ°Ã‘Ë†Ã’Â¡ÃÂ¾Ã‘â‚¬Ã‘â€š Ã‘â€šÃÂµÃÂ»ÃÂµ',
    ],
    'eu' => [
        'isoName' => 'Basque',
        'nativeName' => 'euskara, euskera',
    ],
    'be' => [
        'isoName' => 'Belarusian',
        'nativeName' => 'ÃÂ±ÃÂµÃÂ»ÃÂ°Ã‘â‚¬Ã‘Æ’Ã‘ÂÃÂºÃÂ°Ã‘Â ÃÂ¼ÃÂ¾ÃÂ²ÃÂ°',
    ],
    'bn' => [
        'isoName' => 'Bengali',
        'nativeName' => 'Ã Â¦Â¬Ã Â¦Â¾Ã Â¦â€šÃ Â¦Â²Ã Â¦Â¾',
    ],
    'bh' => [
        'isoName' => 'Bihari languages',
        'nativeName' => 'Ã Â¤Â­Ã Â¥â€¹Ã Â¤Å“Ã Â¤ÂªÃ Â¥ÂÃ Â¤Â°Ã Â¥â‚¬',
    ],
    'bi' => [
        'isoName' => 'Bislama',
        'nativeName' => 'Bislama',
    ],
    'bs' => [
        'isoName' => 'Bosnian',
        'nativeName' => 'bosanski jezik',
    ],
    'br' => [
        'isoName' => 'Breton',
        'nativeName' => 'brezhoneg',
    ],
    'bg' => [
        'isoName' => 'Bulgarian',
        'nativeName' => 'ÃÂ±Ã‘Å ÃÂ»ÃÂ³ÃÂ°Ã‘â‚¬Ã‘ÂÃÂºÃÂ¸ ÃÂµÃÂ·ÃÂ¸ÃÂº',
    ],
    'my' => [
        'isoName' => 'Burmese',
        'nativeName' => 'Ã¡â‚¬â€”Ã¡â‚¬â„¢Ã¡â‚¬Â¬Ã¡â‚¬â€¦Ã¡â‚¬Â¬',
    ],
    'ca' => [
        'isoName' => 'Catalan, Valencian',
        'nativeName' => 'catalÃƒÂ , valenciÃƒÂ ',
    ],
    'ch' => [
        'isoName' => 'Chamorro',
        'nativeName' => 'Chamoru',
    ],
    'ce' => [
        'isoName' => 'Chechen',
        'nativeName' => 'ÃÂ½ÃÂ¾Ã‘â€¦Ã‘â€¡ÃÂ¸ÃÂ¹ÃÂ½ ÃÂ¼ÃÂ¾Ã‘â€šÃ‘â€š',
    ],
    'ny' => [
        'isoName' => 'Chichewa, Chewa, Nyanja',
        'nativeName' => 'chiCheÃ…Âµa, chinyanja',
    ],
    'zh' => [
        'isoName' => 'Chinese',
        'nativeName' => 'Ã¤Â¸Â­Ã¦â€“â€¡Ã‚Â (ZhÃ…ÂngwÃƒÂ©n),Ã‚Â Ã¦Â±â€°Ã¨Â¯Â­,Ã‚Â Ã¦Â¼Â¢Ã¨ÂªÅ¾',
    ],
    'cv' => [
        'isoName' => 'Chuvash',
        'nativeName' => 'Ã‘â€¡Ã“â€˜ÃÂ²ÃÂ°Ã‘Ë† Ã‘â€¡Ã“â€”ÃÂ»Ã‘â€¦ÃÂ¸',
    ],
    'kw' => [
        'isoName' => 'Cornish',
        'nativeName' => 'Kernewek',
    ],
    'co' => [
        'isoName' => 'Corsican',
        'nativeName' => 'corsu, lingua corsa',
    ],
    'cr' => [
        'isoName' => 'Cree',
        'nativeName' => 'Ã¡â€œâ‚¬Ã¡ÂÂ¦Ã¡ÂÆ’Ã¡â€Â­Ã¡ÂÂÃ¡ÂÂÃ¡ÂÂ£',
    ],
    'hr' => [
        'isoName' => 'Croatian',
        'nativeName' => 'hrvatski jezik',
    ],
    'cs' => [
        'isoName' => 'Czech',
        'nativeName' => 'Ã„ÂeÃ…Â¡tina, Ã„ÂeskÃƒÂ½ jazyk',
    ],
    'da' => [
        'isoName' => 'Danish',
        'nativeName' => 'dansk',
    ],
    'dv' => [
        'isoName' => 'Divehi, Dhivehi, Maldivian',
        'nativeName' => 'Ãžâ€¹ÃžÂ¨ÃžË†ÃžÂ¬Ãžâ‚¬ÃžÂ¨',
    ],
    'nl' => [
        'isoName' => 'Dutch, Flemish',
        'nativeName' => 'Nederlands, Vlaams',
    ],
    'dz' => [
        'isoName' => 'Dzongkha',
        'nativeName' => 'Ã Â½Â¢Ã Â¾Â«Ã Â½Â¼Ã Â½â€žÃ Â¼â€¹Ã Â½Â',
    ],
    'en' => [
        'isoName' => 'English',
        'nativeName' => 'English',
    ],
    'eo' => [
        'isoName' => 'Esperanto',
        'nativeName' => 'Esperanto',
    ],
    'et' => [
        'isoName' => 'Estonian',
        'nativeName' => 'eesti, eesti keel',
    ],
    'ee' => [
        'isoName' => 'Ewe',
        'nativeName' => 'EÃŠâ€¹egbe',
    ],
    'fo' => [
        'isoName' => 'Faroese',
        'nativeName' => 'fÃƒÂ¸royskt',
    ],
    'fj' => [
        'isoName' => 'Fijian',
        'nativeName' => 'vosa Vakaviti',
    ],
    'fi' => [
        'isoName' => 'Finnish',
        'nativeName' => 'suomi, suomen kieli',
    ],
    'fr' => [
        'isoName' => 'French',
        'nativeName' => 'franÃƒÂ§ais',
    ],
    'ff' => [
        'isoName' => 'Fulah',
        'nativeName' => 'Fulfulde, Pulaar, Pular',
    ],
    'gl' => [
        'isoName' => 'Galician',
        'nativeName' => 'Galego',
    ],
    'ka' => [
        'isoName' => 'Georgian',
        'nativeName' => 'Ã¡Æ’Â¥Ã¡Æ’ÂÃ¡Æ’Â Ã¡Æ’â€”Ã¡Æ’Â£Ã¡Æ’Å¡Ã¡Æ’Ëœ',
    ],
    'de' => [
        'isoName' => 'German',
        'nativeName' => 'Deutsch',
    ],
    'el' => [
        'isoName' => 'GreekÃ‚Â (modern)',
        'nativeName' => 'ÃŽÂµÃŽÂ»ÃŽÂ»ÃŽÂ·ÃŽÂ½ÃŽÂ¹ÃŽÂºÃŽÂ¬',
    ],
    'gn' => [
        'isoName' => 'GuaranÃƒÂ­',
        'nativeName' => 'AvaÃƒÂ±e\'Ã¡ÂºÂ½',
    ],
    'gu' => [
        'isoName' => 'Gujarati',
        'nativeName' => 'Ã Âªâ€”Ã Â«ÂÃ ÂªÅ“Ã ÂªÂ°Ã ÂªÂ¾Ã ÂªÂ¤Ã Â«â‚¬',
    ],
    'ht' => [
        'isoName' => 'Haitian, Haitian Creole',
        'nativeName' => 'KreyÃƒÂ²l ayisyen',
    ],
    'ha' => [
        'isoName' => 'Hausa',
        'nativeName' => '(Hausa) Ã™â€¡Ã™Å½Ã™Ë†Ã™ÂÃ˜Â³Ã™Å½',
    ],
    'he' => [
        'isoName' => 'HebrewÃ‚Â (modern)',
        'nativeName' => 'Ã—Â¢Ã—â€˜Ã—Â¨Ã—â„¢Ã—Âª',
    ],
    'hz' => [
        'isoName' => 'Herero',
        'nativeName' => 'Otjiherero',
    ],
    'hi' => [
        'isoName' => 'Hindi',
        'nativeName' => 'Ã Â¤Â¹Ã Â¤Â¿Ã Â¤Â¨Ã Â¥ÂÃ Â¤Â¦Ã Â¥â‚¬, Ã Â¤Â¹Ã Â¤Â¿Ã Â¤â€šÃ Â¤Â¦Ã Â¥â‚¬',
    ],
    'ho' => [
        'isoName' => 'Hiri Motu',
        'nativeName' => 'Hiri Motu',
    ],
    'hu' => [
        'isoName' => 'Hungarian',
        'nativeName' => 'magyar',
    ],
    'ia' => [
        'isoName' => 'Interlingua',
        'nativeName' => 'Interlingua',
    ],
    'id' => [
        'isoName' => 'Indonesian',
        'nativeName' => 'Bahasa Indonesia',
    ],
    'ie' => [
        'isoName' => 'Interlingue',
        'nativeName' => 'Originally calledÃ‚Â Occidental; then Interlingue after WWII',
    ],
    'ga' => [
        'isoName' => 'Irish',
        'nativeName' => 'Gaeilge',
    ],
    'ig' => [
        'isoName' => 'Igbo',
        'nativeName' => 'AsÃ¡Â»Â¥sÃ¡Â»Â¥ Igbo',
    ],
    'ik' => [
        'isoName' => 'Inupiaq',
        'nativeName' => 'IÃƒÂ±upiaq, IÃƒÂ±upiatun',
    ],
    'io' => [
        'isoName' => 'Ido',
        'nativeName' => 'Ido',
    ],
    'is' => [
        'isoName' => 'Icelandic',
        'nativeName' => 'ÃƒÂslenska',
    ],
    'it' => [
        'isoName' => 'Italian',
        'nativeName' => 'Italiano',
    ],
    'iu' => [
        'isoName' => 'Inuktitut',
        'nativeName' => 'Ã¡ÂÆ’Ã¡â€œâ€žÃ¡â€™Æ’Ã¡â€˜Å½Ã¡â€˜ÂÃ¡â€˜Â¦',
    ],
    'ja' => [
        'isoName' => 'Japanese',
        'nativeName' => 'Ã¦â€”Â¥Ã¦Å“Â¬Ã¨ÂªÅ¾Ã‚Â (Ã£ÂÂ«Ã£ÂÂ»Ã£â€šâ€œÃ£Ââ€)',
    ],
    'jv' => [
        'isoName' => 'Javanese',
        'nativeName' => 'ÃªÂ¦Â§ÃªÂ¦Â±ÃªÂ¦â€”ÃªÂ¦Â®, Basa Jawa',
    ],
    'kl' => [
        'isoName' => 'Kalaallisut, Greenlandic',
        'nativeName' => 'kalaallisut, kalaallit oqaasii',
    ],
    'kn' => [
        'isoName' => 'Kannada',
        'nativeName' => 'Ã Â²â€¢Ã Â²Â¨Ã Â³ÂÃ Â²Â¨Ã Â²Â¡',
    ],
    'kr' => [
        'isoName' => 'Kanuri',
        'nativeName' => 'Kanuri',
    ],
    'ks' => [
        'isoName' => 'Kashmiri',
        'nativeName' => 'Ã Â¤â€¢Ã Â¤Â¶Ã Â¥ÂÃ Â¤Â®Ã Â¥â‚¬Ã Â¤Â°Ã Â¥â‚¬,Ã‚Â Ã™Æ’Ã˜Â´Ã™â€¦Ã™Å Ã˜Â±Ã™Å Ã¢â‚¬Å½',
    ],
    'kk' => [
        'isoName' => 'Kazakh',
        'nativeName' => 'Ã’â€ºÃÂ°ÃÂ·ÃÂ°Ã’â€º Ã‘â€šÃ‘â€“ÃÂ»Ã‘â€“',
    ],
    'km' => [
        'isoName' => 'Central Khmer',
        'nativeName' => 'Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾ËœÃ¡Å¸â€šÃ¡Å¾Å¡, Ã¡Å¾ÂÃ¡Å¸ÂÃ¡Å¾ËœÃ¡Å¾Å¡Ã¡Å¾â€”Ã¡Å¾Â¶Ã¡Å¾Å¸Ã¡Å¾Â¶, Ã¡Å¾â€”Ã¡Å¾Â¶Ã¡Å¾Å¸Ã¡Å¾Â¶Ã¡Å¾ÂÃ¡Å¸â€™Ã¡Å¾ËœÃ¡Å¸â€šÃ¡Å¾Å¡',
    ],
    'ki' => [
        'isoName' => 'Kikuyu, Gikuyu',
        'nativeName' => 'GÃ„Â©kÃ…Â©yÃ…Â©',
    ],
    'rw' => [
        'isoName' => 'Kinyarwanda',
        'nativeName' => 'Ikinyarwanda',
    ],
    'ky' => [
        'isoName' => 'Kirghiz, Kyrgyz',
        'nativeName' => 'ÃÅ¡Ã‘â€¹Ã‘â‚¬ÃÂ³Ã‘â€¹ÃÂ·Ã‘â€¡ÃÂ°, ÃÅ¡Ã‘â€¹Ã‘â‚¬ÃÂ³Ã‘â€¹ÃÂ· Ã‘â€šÃÂ¸ÃÂ»ÃÂ¸',
    ],
    'kv' => [
        'isoName' => 'Komi',
        'nativeName' => 'ÃÂºÃÂ¾ÃÂ¼ÃÂ¸ ÃÂºÃ‘â€¹ÃÂ²',
    ],
    'kg' => [
        'isoName' => 'Kongo',
        'nativeName' => 'Kikongo',
    ],
    'ko' => [
        'isoName' => 'Korean',
        'nativeName' => 'Ã­â€¢Å“ÃªÂµÂ­Ã¬â€“Â´',
    ],
    'ku' => [
        'isoName' => 'Kurdish',
        'nativeName' => 'KurdÃƒÂ®,Ã‚Â ÃšÂ©Ã™Ë†Ã˜Â±Ã˜Â¯Ã›Å’Ã¢â‚¬Å½',
    ],
    'kj' => [
        'isoName' => 'Kuanyama, Kwanyama',
        'nativeName' => 'Kuanyama',
    ],
    'la' => [
        'isoName' => 'Latin',
        'nativeName' => 'latine, lingua latina',
    ],
    'lb' => [
        'isoName' => 'Luxembourgish, Letzeburgesch',
        'nativeName' => 'LÃƒÂ«tzebuergesch',
    ],
    'lg' => [
        'isoName' => 'Ganda',
        'nativeName' => 'Luganda',
    ],
    'li' => [
        'isoName' => 'Limburgan, Limburger, Limburgish',
        'nativeName' => 'Limburgs',
    ],
    'ln' => [
        'isoName' => 'Lingala',
        'nativeName' => 'LingÃƒÂ¡la',
    ],
    'lo' => [
        'isoName' => 'Lao',
        'nativeName' => 'Ã ÂºÅ¾Ã ÂºÂ²Ã ÂºÂªÃ ÂºÂ²Ã ÂºÂ¥Ã ÂºÂ²Ã ÂºÂ§',
    ],
    'lt' => [
        'isoName' => 'Lithuanian',
        'nativeName' => 'lietuviÃ…Â³ kalba',
    ],
    'lu' => [
        'isoName' => 'Luba-Katanga',
        'nativeName' => 'Kiluba',
    ],
    'lv' => [
        'isoName' => 'Latvian',
        'nativeName' => 'latvieÃ…Â¡u valoda',
    ],
    'gv' => [
        'isoName' => 'Manx',
        'nativeName' => 'Gaelg, Gailck',
    ],
    'mk' => [
        'isoName' => 'Macedonian',
        'nativeName' => 'ÃÂ¼ÃÂ°ÃÂºÃÂµÃÂ´ÃÂ¾ÃÂ½Ã‘ÂÃÂºÃÂ¸ Ã‘ËœÃÂ°ÃÂ·ÃÂ¸ÃÂº',
    ],
    'mg' => [
        'isoName' => 'Malagasy',
        'nativeName' => 'fiteny malagasy',
    ],
    'ms' => [
        'isoName' => 'Malay',
        'nativeName' => 'Bahasa Melayu,Ã‚Â Ã˜Â¨Ã™â€¡Ã˜Â§Ã˜Â³ Ã™â€¦Ã™â€žÃ˜Â§Ã™Å Ã™Ë†Ã¢â‚¬Å½',
    ],
    'ml' => [
        'isoName' => 'Malayalam',
        'nativeName' => 'Ã Â´Â®Ã Â´Â²Ã Â´Â¯Ã Â´Â¾Ã Â´Â³Ã Â´â€š',
    ],
    'mt' => [
        'isoName' => 'Maltese',
        'nativeName' => 'Malti',
    ],
    'mi' => [
        'isoName' => 'Maori',
        'nativeName' => 'te reo MÃ„Âori',
    ],
    'mr' => [
        'isoName' => 'Marathi',
        'nativeName' => 'Ã Â¤Â®Ã Â¤Â°Ã Â¤Â¾Ã Â¤Â Ã Â¥â‚¬',
    ],
    'mh' => [
        'isoName' => 'Marshallese',
        'nativeName' => 'Kajin MÃŒÂ§ajeÃ„Â¼',
    ],
    'mn' => [
        'isoName' => 'Mongolian',
        'nativeName' => 'ÃÅ“ÃÂ¾ÃÂ½ÃÂ³ÃÂ¾ÃÂ» Ã‘â€¦Ã‘ÂÃÂ»',
    ],
    'na' => [
        'isoName' => 'Nauru',
        'nativeName' => 'Dorerin Naoero',
    ],
    'nv' => [
        'isoName' => 'Navajo, Navaho',
        'nativeName' => 'DinÃƒÂ© bizaad',
    ],
    'nd' => [
        'isoName' => 'North Ndebele',
        'nativeName' => 'isiNdebele',
    ],
    'ne' => [
        'isoName' => 'Nepali',
        'nativeName' => 'Ã Â¤Â¨Ã Â¥â€¡Ã Â¤ÂªÃ Â¤Â¾Ã Â¤Â²Ã Â¥â‚¬',
    ],
    'ng' => [
        'isoName' => 'Ndonga',
        'nativeName' => 'Owambo',
    ],
    'nb' => [
        'isoName' => 'Norwegian BokmÃƒÂ¥l',
        'nativeName' => 'Norsk BokmÃƒÂ¥l',
    ],
    'nn' => [
        'isoName' => 'Norwegian Nynorsk',
        'nativeName' => 'Norsk Nynorsk',
    ],
    'no' => [
        'isoName' => 'Norwegian',
        'nativeName' => 'Norsk',
    ],
    'ii' => [
        'isoName' => 'Sichuan Yi, Nuosu',
        'nativeName' => 'Ãªâ€ Ë†ÃªÅ’Â Ãªâ€™Â¿ Nuosuhxop',
    ],
    'nr' => [
        'isoName' => 'South Ndebele',
        'nativeName' => 'isiNdebele',
    ],
    'oc' => [
        'isoName' => 'Occitan',
        'nativeName' => 'occitan, lenga d\'ÃƒÂ²c',
    ],
    'oj' => [
        'isoName' => 'Ojibwa',
        'nativeName' => 'Ã¡ÂÅ Ã¡â€œâ€šÃ¡â€â€˜Ã¡â€œË†Ã¡ÂÂ¯Ã¡â€™Â§Ã¡ÂÅ½Ã¡â€œÂ',
    ],
    'cu' => [
        'isoName' => 'ChurchÃ‚Â Slavic, ChurchÃ‚Â Slavonic,Ã‚Â OldÃ‚Â ChurchÃ‚Â Slavonic, OldÃ‚Â Slavonic,Ã‚Â OldÃ‚Â Bulgarian',
        'nativeName' => 'Ã‘Â©ÃÂ·Ã‘â€¹ÃÂºÃ‘Å  Ã‘ÂÃÂ»ÃÂ¾ÃÂ²Ã‘Â£ÃÂ½Ã‘Å’Ã‘ÂÃÂºÃ‘Å ',
    ],
    'om' => [
        'isoName' => 'Oromo',
        'nativeName' => 'Afaan Oromoo',
    ],
    'or' => [
        'isoName' => 'Oriya',
        'nativeName' => 'Ã Â¬â€œÃ Â¬Â¡Ã Â¬Â¼Ã Â¬Â¿Ã Â¬â€ ',
    ],
    'os' => [
        'isoName' => 'Ossetian, Ossetic',
        'nativeName' => 'ÃÂ¸Ã‘â‚¬ÃÂ¾ÃÂ½ ÃƒÂ¦ÃÂ²ÃÂ·ÃÂ°ÃÂ³',
    ],
    'pa' => [
        'isoName' => 'Panjabi, Punjabi',
        'nativeName' => 'Ã Â¨ÂªÃ Â©Â°Ã Â¨Å“Ã Â¨Â¾Ã Â¨Â¬Ã Â©â‚¬',
    ],
    'pi' => [
        'isoName' => 'Pali',
        'nativeName' => 'Ã Â¤ÂªÃ Â¤Â¾Ã Â¤Â´Ã Â¤Â¿',
    ],
    'fa' => [
        'isoName' => 'Persian',
        'nativeName' => 'Ã™ÂÃ˜Â§Ã˜Â±Ã˜Â³Ã›Å’',
    ],
    'pl' => [
        'isoName' => 'Polish',
        'nativeName' => 'jÃ„â„¢zyk polski, polszczyzna',
    ],
    'ps' => [
        'isoName' => 'Pashto, Pushto',
        'nativeName' => 'Ã™Â¾ÃšÅ¡Ã˜ÂªÃ™Ë†',
    ],
    'pt' => [
        'isoName' => 'Portuguese',
        'nativeName' => 'PortuguÃƒÂªs',
    ],
    'qu' => [
        'isoName' => 'Quechua',
        'nativeName' => 'Runa Simi, Kichwa',
    ],
    'rm' => [
        'isoName' => 'Romansh',
        'nativeName' => 'Rumantsch Grischun',
    ],
    'rn' => [
        'isoName' => 'Rundi',
        'nativeName' => 'Ikirundi',
    ],
    'ro' => [
        'isoName' => 'Romanian, Moldavian, Moldovan',
        'nativeName' => 'RomÃƒÂ¢nÃ„Æ’',
    ],
    'ru' => [
        'isoName' => 'Russian',
        'nativeName' => 'Ã‘â‚¬Ã‘Æ’Ã‘ÂÃ‘ÂÃÂºÃÂ¸ÃÂ¹',
    ],
    'sa' => [
        'isoName' => 'Sanskrit',
        'nativeName' => 'Ã Â¤Â¸Ã Â¤â€šÃ Â¤Â¸Ã Â¥ÂÃ Â¤â€¢Ã Â¥Æ’Ã Â¤Â¤Ã Â¤Â®Ã Â¥Â',
    ],
    'sc' => [
        'isoName' => 'Sardinian',
        'nativeName' => 'sardu',
    ],
    'sd' => [
        'isoName' => 'Sindhi',
        'nativeName' => 'Ã Â¤Â¸Ã Â¤Â¿Ã Â¤Â¨Ã Â¥ÂÃ Â¤Â§Ã Â¥â‚¬,Ã‚Â Ã˜Â³Ã™â€ ÃšÅ’Ã™Å Ã˜Å’ Ã˜Â³Ã™â€ Ã˜Â¯ÃšÂ¾Ã›Å’Ã¢â‚¬Å½',
    ],
    'se' => [
        'isoName' => 'Northern Sami',
        'nativeName' => 'DavvisÃƒÂ¡megiella',
    ],
    'sm' => [
        'isoName' => 'Samoan',
        'nativeName' => 'gagana fa\'a Samoa',
    ],
    'sg' => [
        'isoName' => 'Sango',
        'nativeName' => 'yÃƒÂ¢ngÃƒÂ¢ tÃƒÂ® sÃƒÂ¤ngÃƒÂ¶',
    ],
    'sr' => [
        'isoName' => 'Serbian',
        'nativeName' => 'Ã‘ÂÃ‘â‚¬ÃÂ¿Ã‘ÂÃÂºÃÂ¸ Ã‘ËœÃÂµÃÂ·ÃÂ¸ÃÂº',
    ],
    'gd' => [
        'isoName' => 'Gaelic, Scottish Gaelic',
        'nativeName' => 'GÃƒÂ idhlig',
    ],
    'sn' => [
        'isoName' => 'Shona',
        'nativeName' => 'chiShona',
    ],
    'si' => [
        'isoName' => 'Sinhala, Sinhalese',
        'nativeName' => 'Ã Â·Æ’Ã Â·â€™Ã Â¶â€šÃ Â·â€žÃ Â¶Â½',
    ],
    'sk' => [
        'isoName' => 'Slovak',
        'nativeName' => 'SlovenÃ„Âina, SlovenskÃƒÂ½ Jazyk',
    ],
    'sl' => [
        'isoName' => 'Slovenian',
        'nativeName' => 'Slovenski Jezik, SlovenÃ…Â¡Ã„Âina',
    ],
    'so' => [
        'isoName' => 'Somali',
        'nativeName' => 'Soomaaliga, af Soomaali',
    ],
    'st' => [
        'isoName' => 'Southern Sotho',
        'nativeName' => 'Sesotho',
    ],
    'es' => [
        'isoName' => 'Spanish, Castilian',
        'nativeName' => 'EspaÃƒÂ±ol',
    ],
    'su' => [
        'isoName' => 'Sundanese',
        'nativeName' => 'Basa Sunda',
    ],
    'sw' => [
        'isoName' => 'Swahili',
        'nativeName' => 'Kiswahili',
    ],
    'ss' => [
        'isoName' => 'Swati',
        'nativeName' => 'SiSwati',
    ],
    'sv' => [
        'isoName' => 'Swedish',
        'nativeName' => 'Svenska',
    ],
    'ta' => [
        'isoName' => 'Tamil',
        'nativeName' => 'Ã Â®Â¤Ã Â®Â®Ã Â®Â¿Ã Â®Â´Ã Â¯Â',
    ],
    'te' => [
        'isoName' => 'Telugu',
        'nativeName' => 'Ã Â°Â¤Ã Â±â€ Ã Â°Â²Ã Â±ÂÃ Â°â€”Ã Â±Â',
    ],
    'tg' => [
        'isoName' => 'Tajik',
        'nativeName' => 'Ã‘â€šÃÂ¾Ã’Â·ÃÂ¸ÃÂºÃ“Â£,Ã‚Â toÃƒÂ§ikÃ„Â«,Ã‚Â Ã˜ÂªÃ˜Â§Ã˜Â¬Ã›Å’ÃšÂ©Ã›Å’Ã¢â‚¬Å½',
    ],
    'th' => [
        'isoName' => 'Thai',
        'nativeName' => 'Ã Â¹â€žÃ Â¸â€”Ã Â¸Â¢',
    ],
    'ti' => [
        'isoName' => 'Tigrinya',
        'nativeName' => 'Ã¡â€°ÂµÃ¡Å’ÂÃ¡Ë†Â­Ã¡Å â€º',
    ],
    'bo' => [
        'isoName' => 'Tibetan',
        'nativeName' => 'Ã Â½â€“Ã Â½Â¼Ã Â½â€˜Ã Â¼â€¹Ã Â½Â¡Ã Â½Â²Ã Â½â€š',
    ],
    'tk' => [
        'isoName' => 'Turkmen',
        'nativeName' => 'TÃƒÂ¼rkmen, ÃÂ¢Ã’Â¯Ã‘â‚¬ÃÂºÃÂ¼ÃÂµÃÂ½',
    ],
    'tl' => [
        'isoName' => 'Tagalog',
        'nativeName' => 'Wikang Tagalog',
    ],
    'tn' => [
        'isoName' => 'Tswana',
        'nativeName' => 'Setswana',
    ],
    'to' => [
        'isoName' => 'TonganÃ‚Â (Tonga Islands)',
        'nativeName' => 'Faka Tonga',
    ],
    'tr' => [
        'isoName' => 'Turkish',
        'nativeName' => 'TÃƒÂ¼rkÃƒÂ§e',
    ],
    'ts' => [
        'isoName' => 'Tsonga',
        'nativeName' => 'Xitsonga',
    ],
    'tt' => [
        'isoName' => 'Tatar',
        'nativeName' => 'Ã‘â€šÃÂ°Ã‘â€šÃÂ°Ã‘â‚¬ Ã‘â€šÃÂµÃÂ»ÃÂµ,Ã‚Â tatar tele',
    ],
    'tw' => [
        'isoName' => 'Twi',
        'nativeName' => 'Twi',
    ],
    'ty' => [
        'isoName' => 'Tahitian',
        'nativeName' => 'Reo Tahiti',
    ],
    'ug' => [
        'isoName' => 'Uighur, Uyghur',
        'nativeName' => 'UyÃ†Â£urqÃ‰â„¢, Ã¢â‚¬Â«Ã˜Â¦Ã›â€¡Ã™Å Ã˜ÂºÃ›â€¡Ã˜Â±Ãšâ€ ',
    ],
    'uk' => [
        'isoName' => 'Ukrainian',
        'nativeName' => 'ÃÂ£ÃÂºÃ‘â‚¬ÃÂ°Ã‘â€”ÃÂ½Ã‘ÂÃ‘Å’ÃÂºÃÂ°',
    ],
    'ur' => [
        'isoName' => 'Urdu',
        'nativeName' => 'Ã˜Â§Ã˜Â±Ã˜Â¯Ã™Ë†',
    ],
    'uz' => [
        'isoName' => 'Uzbek',
        'nativeName' => 'OÃŠÂ»zbek,Ã‚Â ÃÅ½ÃÂ·ÃÂ±ÃÂµÃÂº,Ã‚Â Ã˜Â£Ã›â€¡Ã˜Â²Ã˜Â¨Ã›ÂÃ™Æ’Ã¢â‚¬Å½',
    ],
    've' => [
        'isoName' => 'Venda',
        'nativeName' => 'TshivenÃ¡Â¸â€œa',
    ],
    'vi' => [
        'isoName' => 'Vietnamese',
        'nativeName' => 'TiÃ¡ÂºÂ¿ng ViÃ¡Â»â€¡t',
    ],
    'vo' => [
        'isoName' => 'VolapÃƒÂ¼k',
        'nativeName' => 'VolapÃƒÂ¼k',
    ],
    'wa' => [
        'isoName' => 'Walloon',
        'nativeName' => 'Walon',
    ],
    'cy' => [
        'isoName' => 'Welsh',
        'nativeName' => 'Cymraeg',
    ],
    'wo' => [
        'isoName' => 'Wolof',
        'nativeName' => 'Wollof',
    ],
    'fy' => [
        'isoName' => 'Western Frisian',
        'nativeName' => 'Frysk',
    ],
    'xh' => [
        'isoName' => 'Xhosa',
        'nativeName' => 'isiXhosa',
    ],
    'yi' => [
        'isoName' => 'Yiddish',
        'nativeName' => 'Ã—â„¢Ã—â„¢Ã–Â´Ã—â€œÃ—â„¢Ã—Â©',
    ],
    'yo' => [
        'isoName' => 'Yoruba',
        'nativeName' => 'YorÃƒÂ¹bÃƒÂ¡',
    ],
    'za' => [
        'isoName' => 'Zhuang, Chuang',
        'nativeName' => 'SaÃ‰Â¯ cueÃ…â€¹Ã†â€¦, Saw cuengh',
    ],
    'zu' => [
        'isoName' => 'Zulu',
        'nativeName' => 'isiZulu',
    ],
    /*
     * Add ISO 639-3 languages available in Carbon
     */
    'agq' => [
        'isoName' => 'Aghem',
        'nativeName' => 'Aghem',
    ],
    'agr' => [
        'isoName' => 'Aguaruna',
        'nativeName' => 'Aguaruna',
    ],
    'anp' => [
        'isoName' => 'Angika',
        'nativeName' => 'Angika',
    ],
    'asa' => [
        'isoName' => 'Asu',
        'nativeName' => 'Asu',
    ],
    'ast' => [
        'isoName' => 'Asturian',
        'nativeName' => 'Asturian',
    ],
    'ayc' => [
        'isoName' => 'Southern Aymara',
        'nativeName' => 'Southern Aymara',
    ],
    'bas' => [
        'isoName' => 'Basaa',
        'nativeName' => 'Basaa',
    ],
    'bem' => [
        'isoName' => 'Bemba',
        'nativeName' => 'Bemba',
    ],
    'bez' => [
        'isoName' => 'Bena',
        'nativeName' => 'Bena',
    ],
    'bhb' => [
        'isoName' => 'Bhili',
        'nativeName' => 'Bhili',
    ],
    'bho' => [
        'isoName' => 'Bhojpuri',
        'nativeName' => 'Bhojpuri',
    ],
    'brx' => [
        'isoName' => 'Bodo',
        'nativeName' => 'Bodo',
    ],
    'byn' => [
        'isoName' => 'Bilin',
        'nativeName' => 'Bilin',
    ],
    'ccp' => [
        'isoName' => 'Chakma',
        'nativeName' => 'Chakma',
    ],
    'cgg' => [
        'isoName' => 'Chiga',
        'nativeName' => 'Chiga',
    ],
    'chr' => [
        'isoName' => 'Cherokee',
        'nativeName' => 'Cherokee',
    ],
    'cmn' => [
        'isoName' => 'Chinese',
        'nativeName' => 'Chinese',
    ],
    'crh' => [
        'isoName' => 'Crimean Turkish',
        'nativeName' => 'Crimean Turkish',
    ],
    'csb' => [
        'isoName' => 'Kashubian',
        'nativeName' => 'Kashubian',
    ],
    'dav' => [
        'isoName' => 'Taita',
        'nativeName' => 'Taita',
    ],
    'dje' => [
        'isoName' => 'Zarma',
        'nativeName' => 'Zarma',
    ],
    'doi' => [
        'isoName' => 'Dogri (macrolanguage)',
        'nativeName' => 'Dogri (macrolanguage)',
    ],
    'dsb' => [
        'isoName' => 'Lower Sorbian',
        'nativeName' => 'Lower Sorbian',
    ],
    'dua' => [
        'isoName' => 'Duala',
        'nativeName' => 'Duala',
    ],
    'dyo' => [
        'isoName' => 'Jola-Fonyi',
        'nativeName' => 'Jola-Fonyi',
    ],
    'ebu' => [
        'isoName' => 'Embu',
        'nativeName' => 'Embu',
    ],
    'ewo' => [
        'isoName' => 'Ewondo',
        'nativeName' => 'Ewondo',
    ],
    'fil' => [
        'isoName' => 'Filipino',
        'nativeName' => 'Filipino',
    ],
    'fur' => [
        'isoName' => 'Friulian',
        'nativeName' => 'Friulian',
    ],
    'gez' => [
        'isoName' => 'Geez',
        'nativeName' => 'Geez',
    ],
    'gom' => [
        'isoName' => 'Konkani, Goan',
        'nativeName' => 'Ã Â²â€¢Ã Â³Å Ã Â²â€šÃ Â²â€¢Ã Â²Â£Ã Â²Â¿',
    ],
    'gsw' => [
        'isoName' => 'Swiss German',
        'nativeName' => 'Swiss German',
    ],
    'guz' => [
        'isoName' => 'Gusii',
        'nativeName' => 'Gusii',
    ],
    'hak' => [
        'isoName' => 'Hakka Chinese',
        'nativeName' => 'Hakka Chinese',
    ],
    'haw' => [
        'isoName' => 'Hawaiian',
        'nativeName' => 'Hawaiian',
    ],
    'hif' => [
        'isoName' => 'Fiji Hindi',
        'nativeName' => 'Fiji Hindi',
    ],
    'hne' => [
        'isoName' => 'Chhattisgarhi',
        'nativeName' => 'Chhattisgarhi',
    ],
    'hsb' => [
        'isoName' => 'Upper Sorbian',
        'nativeName' => 'Upper Sorbian',
    ],
    'jgo' => [
        'isoName' => 'Ngomba',
        'nativeName' => 'Ngomba',
    ],
    'jmc' => [
        'isoName' => 'Machame',
        'nativeName' => 'Machame',
    ],
    'kab' => [
        'isoName' => 'Kabyle',
        'nativeName' => 'Kabyle',
    ],
    'kam' => [
        'isoName' => 'Kamba',
        'nativeName' => 'Kamba',
    ],
    'kde' => [
        'isoName' => 'Makonde',
        'nativeName' => 'Makonde',
    ],
    'kea' => [
        'isoName' => 'Kabuverdianu',
        'nativeName' => 'Kabuverdianu',
    ],
    'khq' => [
        'isoName' => 'Koyra Chiini',
        'nativeName' => 'Koyra Chiini',
    ],
    'kkj' => [
        'isoName' => 'Kako',
        'nativeName' => 'Kako',
    ],
    'kln' => [
        'isoName' => 'Kalenjin',
        'nativeName' => 'Kalenjin',
    ],
    'kok' => [
        'isoName' => 'Konkani',
        'nativeName' => 'Konkani',
    ],
    'ksb' => [
        'isoName' => 'Shambala',
        'nativeName' => 'Shambala',
    ],
    'ksf' => [
        'isoName' => 'Bafia',
        'nativeName' => 'Bafia',
    ],
    'ksh' => [
        'isoName' => 'Colognian',
        'nativeName' => 'Colognian',
    ],
    'lag' => [
        'isoName' => 'Langi',
        'nativeName' => 'Langi',
    ],
    'lij' => [
        'isoName' => 'Ligurian',
        'nativeName' => 'Ligurian',
    ],
    'lkt' => [
        'isoName' => 'Lakota',
        'nativeName' => 'Lakota',
    ],
    'lrc' => [
        'isoName' => 'Northern Luri',
        'nativeName' => 'Northern Luri',
    ],
    'luo' => [
        'isoName' => 'Luo',
        'nativeName' => 'Luo',
    ],
    'luy' => [
        'isoName' => 'Luyia',
        'nativeName' => 'Luyia',
    ],
    'lzh' => [
        'isoName' => 'Literary Chinese',
        'nativeName' => 'Literary Chinese',
    ],
    'mag' => [
        'isoName' => 'Magahi',
        'nativeName' => 'Magahi',
    ],
    'mai' => [
        'isoName' => 'Maithili',
        'nativeName' => 'Maithili',
    ],
    'mas' => [
        'isoName' => 'Masai',
        'nativeName' => 'Masai',
    ],
    'mer' => [
        'isoName' => 'Meru',
        'nativeName' => 'Meru',
    ],
    'mfe' => [
        'isoName' => 'Morisyen',
        'nativeName' => 'Morisyen',
    ],
    'mgh' => [
        'isoName' => 'Makhuwa-Meetto',
        'nativeName' => 'Makhuwa-Meetto',
    ],
    'mgo' => [
        'isoName' => 'MetaÃŠÂ¼',
        'nativeName' => 'MetaÃŠÂ¼',
    ],
    'mhr' => [
        'isoName' => 'Eastern Mari',
        'nativeName' => 'Eastern Mari',
    ],
    'miq' => [
        'isoName' => 'MÃƒÂ­skito',
        'nativeName' => 'MÃƒÂ­skito',
    ],
    'mjw' => [
        'isoName' => 'Karbi',
        'nativeName' => 'Karbi',
    ],
    'mni' => [
        'isoName' => 'Manipuri',
        'nativeName' => 'Manipuri',
    ],
    'mua' => [
        'isoName' => 'Mundang',
        'nativeName' => 'Mundang',
    ],
    'mzn' => [
        'isoName' => 'Mazanderani',
        'nativeName' => 'Mazanderani',
    ],
    'nan' => [
        'isoName' => 'Min Nan Chinese',
        'nativeName' => 'Min Nan Chinese',
    ],
    'naq' => [
        'isoName' => 'Nama',
        'nativeName' => 'Nama',
    ],
    'nds' => [
        'isoName' => 'Low German',
        'nativeName' => 'Low German',
    ],
    'nhn' => [
        'isoName' => 'Central Nahuatl',
        'nativeName' => 'Central Nahuatl',
    ],
    'niu' => [
        'isoName' => 'Niuean',
        'nativeName' => 'Niuean',
    ],
    'nmg' => [
        'isoName' => 'Kwasio',
        'nativeName' => 'Kwasio',
    ],
    'nnh' => [
        'isoName' => 'Ngiemboon',
        'nativeName' => 'Ngiemboon',
    ],
    'nso' => [
        'isoName' => 'Northern Sotho',
        'nativeName' => 'Northern Sotho',
    ],
    'nus' => [
        'isoName' => 'Nuer',
        'nativeName' => 'Nuer',
    ],
    'nyn' => [
        'isoName' => 'Nyankole',
        'nativeName' => 'Nyankole',
    ],
    'pap' => [
        'isoName' => 'Papiamento',
        'nativeName' => 'Papiamento',
    ],
    'prg' => [
        'isoName' => 'Prussian',
        'nativeName' => 'Prussian',
    ],
    'quz' => [
        'isoName' => 'Cusco Quechua',
        'nativeName' => 'Cusco Quechua',
    ],
    'raj' => [
        'isoName' => 'Rajasthani',
        'nativeName' => 'Rajasthani',
    ],
    'rof' => [
        'isoName' => 'Rombo',
        'nativeName' => 'Rombo',
    ],
    'rwk' => [
        'isoName' => 'Rwa',
        'nativeName' => 'Rwa',
    ],
    'sah' => [
        'isoName' => 'Sakha',
        'nativeName' => 'Sakha',
    ],
    'saq' => [
        'isoName' => 'Samburu',
        'nativeName' => 'Samburu',
    ],
    'sat' => [
        'isoName' => 'Santali',
        'nativeName' => 'Santali',
    ],
    'sbp' => [
        'isoName' => 'Sangu',
        'nativeName' => 'Sangu',
    ],
    'scr' => [
        'isoName' => 'Serbo Croatian',
        'nativeName' => 'Serbo Croatian',
    ],
    'seh' => [
        'isoName' => 'Sena',
        'nativeName' => 'Sena',
    ],
    'ses' => [
        'isoName' => 'Koyraboro Senni',
        'nativeName' => 'Koyraboro Senni',
    ],
    'sgs' => [
        'isoName' => 'Samogitian',
        'nativeName' => 'Samogitian',
    ],
    'shi' => [
        'isoName' => 'Tachelhit',
        'nativeName' => 'Tachelhit',
    ],
    'shn' => [
        'isoName' => 'Shan',
        'nativeName' => 'Shan',
    ],
    'shs' => [
        'isoName' => 'Shuswap',
        'nativeName' => 'Shuswap',
    ],
    'sid' => [
        'isoName' => 'Sidamo',
        'nativeName' => 'Sidamo',
    ],
    'smn' => [
        'isoName' => 'Inari Sami',
        'nativeName' => 'Inari Sami',
    ],
    'szl' => [
        'isoName' => 'Silesian',
        'nativeName' => 'Silesian',
    ],
    'tcy' => [
        'isoName' => 'Tulu',
        'nativeName' => 'Tulu',
    ],
    'teo' => [
        'isoName' => 'Teso',
        'nativeName' => 'Teso',
    ],
    'tet' => [
        'isoName' => 'Tetum',
        'nativeName' => 'Tetum',
    ],
    'the' => [
        'isoName' => 'Chitwania Tharu',
        'nativeName' => 'Chitwania Tharu',
    ],
    'tig' => [
        'isoName' => 'Tigre',
        'nativeName' => 'Tigre',
    ],
    'tlh' => [
        'isoName' => 'Klingon',
        'nativeName' => 'tlhIngan Hol',
    ],
    'tpi' => [
        'isoName' => 'Tok Pisin',
        'nativeName' => 'Tok Pisin',
    ],
    'twq' => [
        'isoName' => 'Tasawaq',
        'nativeName' => 'Tasawaq',
    ],
    'tzl' => [
        'isoName' => 'Talossan',
        'nativeName' => 'Talossan',
    ],
    'tzm' => [
        'isoName' => 'Tamazight, Central Atlas',
        'nativeName' => 'Ã¢ÂµÅ“Ã¢ÂµÅ½Ã¢Â´Â°Ã¢ÂµÂ£Ã¢Âµâ€°Ã¢Âµâ€“Ã¢ÂµÅ“',
    ],
    'unm' => [
        'isoName' => 'Unami',
        'nativeName' => 'Unami',
    ],
    'vai' => [
        'isoName' => 'Vai',
        'nativeName' => 'Vai',
    ],
    'vun' => [
        'isoName' => 'Vunjo',
        'nativeName' => 'Vunjo',
    ],
    'wae' => [
        'isoName' => 'Walser',
        'nativeName' => 'Walser',
    ],
    'wal' => [
        'isoName' => 'Wolaytta',
        'nativeName' => 'Wolaytta',
    ],
    'xog' => [
        'isoName' => 'Soga',
        'nativeName' => 'Soga',
    ],
    'yav' => [
        'isoName' => 'Yangben',
        'nativeName' => 'Yangben',
    ],
    'yue' => [
        'isoName' => 'Cantonese',
        'nativeName' => 'Cantonese',
    ],
    'yuw' => [
        'isoName' => 'Yau (Morobe Province)',
        'nativeName' => 'Yau (Morobe Province)',
    ],
    'zgh' => [
        'isoName' => 'Standard Moroccan Tamazight',
        'nativeName' => 'Standard Moroccan Tamazight',
    ],
];
