<?php

// https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes

return [
    // Dutch (Flemish)
    'nl' => [
        'Ã' => 'A',
        'Ã¡' => 'a',
        'Ã„' => 'A',
        'Ã¤' => 'a',
        'Ã€' => 'A',
        'Ã ' => 'a',
        'Ã‚' => 'A',
        'Ã¢' => 'a',
        'Ã‰' => 'E',
        'Ã©' => 'e',
        'Ã‹' => 'E',
        'Ã«' => 'e',
        'Ãˆ' => 'E',
        'Ã¨' => 'e',
        'ÃŠ' => 'E',
        'Ãª' => 'e',
        'Ã' => 'I',
        'Ã­' => 'i',
        'Ã' => 'I',
        'Ã¯' => 'i',
        'ÃŒ' => 'I',
        'Ã¬' => 'i',
        'ÃŽ' => 'I',
        'Ã®' => 'i',
        'Ã“' => 'O',
        'Ã³' => 'o',
        'Ã–' => 'O',
        'Ã¶' => 'o',
        'Ã’' => 'O',
        'Ã²' => 'o',
        'Ã”' => 'O',
        'Ã´' => 'o',
        'Ãš' => 'U',
        'Ãº' => 'u',
        'Ãœ' => 'U',
        'Ã¼' => 'u',
        'Ã™' => 'U',
        'Ã¹' => 'u',
        'Ã›' => 'U',
        'Ã»' => 'u',
        'Ã' => 'Y',
        'Ã½' => 'y',
        'Å¸' => 'Y',
    ],
    // Italian
    'it' => [
        'Ã ' => 'a',
        'Ã€' => 'A',
        'Ã©' => 'e',
        'Ã‰' => 'E',
        'Ã¨' => 'e',
        'Ãˆ' => 'E',
        'Ã¬' => 'i',
        'ÃŒ' => 'I',
        'Ã’' => 'O',
        'Ã²' => 'o',
        'Ã¹' => 'u',
        'Ã™' => 'U',
    ],
    // Macedonian
    'mk' => [
        'Ð' => 'A',
        'Ð‘' => 'B',
        'Ð’' => 'V',
        'Ð“' => 'G',
        'Ð”' => 'D',
        'Ðƒ' => 'Gj',
        'Ð•' => 'E',
        'Ð–' => 'Zh',
        'Ð—' => 'Z',
        'Ð…' => 'Dz',
        'Ð˜' => 'I',
        'Ðˆ' => 'J',
        'Ðš' => 'K',
        'Ð›' => 'L',
        'Ð‰' => 'Lj',
        'Ðœ' => 'M',
        'Ð' => 'N',
        'ÐŠ' => 'Nj',
        'Ðž' => 'O',
        'ÐŸ' => 'P',
        'Ð ' => 'R',
        'Ð¡' => 'S',
        'Ð¢' => 'T',
        'ÐŒ' => 'Kj',
        'Ð£' => 'U',
        'Ð¤' => 'F',
        'Ð¥' => 'H',
        'Ð¦' => 'C',
        'Ð§' => 'Ch',
        'Ð' => 'Dj',
        'Ð¨' => 'Sh',
        'Ð°' => 'a',
        'Ð±' => 'b',
        'Ð²' => 'v',
        'Ð³' => 'g',
        'Ð´' => 'd',
        'Ñ“' => 'gj',
        'Ðµ' => 'e',
        'Ð¶' => 'zh',
        'Ð·' => 'z',
        'Ñ•' => 'dz',
        'Ð¸' => 'i',
        'Ñ˜' => 'j',
        'Ðº' => 'k',
        'Ð»' => 'l',
        'Ñ™' => 'lj',
        'Ð¼' => 'm',
        'Ð½' => 'n',
        'Ñš' => 'nj',
        'Ð¾' => 'o',
        'Ð¿' => 'p',
        'Ñ€' => 'r',
        'Ñ' => 's',
        'Ñ‚' => 't',
        'Ñœ' => 'kj',
        'Ñƒ' => 'u',
        'Ñ„' => 'f',
        'Ñ…' => 'h',
        'Ñ†' => 'c',
        'Ñ‡' => 'ch',
        'ÑŸ' => 'dj',
        'Ñˆ' => 'sh',
    ],
    // Portuguese (Brazil)
    'pt' => [
        'Ã¦' => 'ae',
        'Ç½' => 'ae',
        'Ã€' => 'A',
        'Ã' => 'A',
        'Ã‚' => 'A',
        'Ãƒ' => 'A',
        'Ã…' => 'AA',
        'Çº' => 'A',
        'Ä‚' => 'A',
        'Ç' => 'A',
        'Ã†' => 'AE',
        'Ç¼' => 'AE',
        'Ã ' => 'a',
        'Ã¡' => 'a',
        'Ã¢' => 'a',
        'Ã£' => 'a',
        'Ã¥' => 'aa',
        'Ç»' => 'a',
        'Äƒ' => 'a',
        'ÇŽ' => 'a',
        'Âª' => 'a',
        'Äˆ' => 'C',
        'ÄŠ' => 'C',
        'Ã‡' => 'C',
        'Ã§' => 'c',
        'Ä‰' => 'c',
        'Ä‹' => 'c',
        'Ã' => 'Dj',
        'Ä' => 'D',
        'Ã°' => 'dj',
        'Ä‘' => 'd',
        'Ãˆ' => 'E',
        'Ã‰' => 'E',
        'ÃŠ' => 'E',
        'Ã‹' => 'E',
        'Ä”' => 'E',
        'Ä–' => 'E',
        'Ã¨' => 'e',
        'Ã©' => 'e',
        'Ãª' => 'e',
        'Ã«' => 'e',
        'Ä•' => 'e',
        'Ä—' => 'e',
        'Æ’' => 'f',
        'Äœ' => 'G',
        'Ä ' => 'G',
        'Ä' => 'g',
        'Ä¡' => 'g',
        'Ä¤' => 'H',
        'Ä¦' => 'H',
        'Ä¥' => 'h',
        'Ä§' => 'h',
        'ÃŒ' => 'I',
        'Ã' => 'I',
        'ÃŽ' => 'I',
        'Ã' => 'I',
        'Ä¨' => 'I',
        'Ä¬' => 'I',
        'Ç' => 'I',
        'Ä®' => 'I',
        'Ä²' => 'IJ',
        'Ã¬' => 'i',
        'Ã­' => 'i',
        'Ã®' => 'i',
        'Ã¯' => 'i',
        'Ä©' => 'i',
        'Ä­' => 'i',
        'Ç' => 'i',
        'Ä¯' => 'i',
        'Ä³' => 'ij',
        'Ä´' => 'J',
        'Äµ' => 'j',
        'Ä¹' => 'L',
        'Ä½' => 'L',
        'Ä¿' => 'L',
        'Äº' => 'l',
        'Ä¾' => 'l',
        'Å€' => 'l',
        'Ã‘' => 'N',
        'Ã±' => 'n',
        'Å‰' => 'n',
        'Ã’' => 'O',
        'Ã“' => 'O',
        'Ã”' => 'O',
        'Ã•' => 'O',
        'ÅŒ' => 'O',
        'ÅŽ' => 'O',
        'Ç‘' => 'O',
        'Å' => 'O',
        'Æ ' => 'O',
        'Ã˜' => 'OE',
        'Ç¾' => 'O',
        'Å’' => 'OE',
        'Ã²' => 'o',
        'Ã³' => 'o',
        'Ã´' => 'o',
        'Ãµ' => 'o',
        'Å' => 'o',
        'Å' => 'o',
        'Ç’' => 'o',
        'Å‘' => 'o',
        'Æ¡' => 'o',
        'Ã¸' => 'oe',
        'Ç¿' => 'o',
        'Âº' => 'o',
        'Å“' => 'oe',
        'Å”' => 'R',
        'Å–' => 'R',
        'Å•' => 'r',
        'Å—' => 'r',
        'Åœ' => 'S',
        'È˜' => 'S',
        'Å' => 's',
        'È™' => 's',
        'Å¿' => 's',
        'Å¢' => 'T',
        'Èš' => 'T',
        'Å¦' => 'T',
        'Ãž' => 'TH',
        'Å£' => 't',
        'È›' => 't',
        'Å§' => 't',
        'Ã¾' => 'th',
        'Ã™' => 'U',
        'Ãš' => 'U',
        'Ã›' => 'U',
        'Ãœ' => 'U',
        'Å¨' => 'U',
        'Å¬' => 'U',
        'Å°' => 'U',
        'Å²' => 'U',
        'Æ¯' => 'U',
        'Ç“' => 'U',
        'Ç•' => 'U',
        'Ç—' => 'U',
        'Ç™' => 'U',
        'Ç›' => 'U',
        'Ã¹' => 'u',
        'Ãº' => 'u',
        'Ã»' => 'u',
        'Ã¼' => 'u',
        'Å©' => 'u',
        'Å­' => 'u',
        'Å±' => 'u',
        'Å³' => 'u',
        'Æ°' => 'u',
        'Ç”' => 'u',
        'Ç–' => 'u',
        'Ç˜' => 'u',
        'Çš' => 'u',
        'Çœ' => 'u',
        'Å´' => 'W',
        'Åµ' => 'w',
        'Ã' => 'Y',
        'Å¸' => 'Y',
        'Å¶' => 'Y',
        'Ã½' => 'y',
        'Ã¿' => 'y',
        'Å·' => 'y',
    ],
    // Greek(lish) (EllÃ¡da)
    'el__greeklish' => [
        'Î‘Î¥' => 'AU',
        'Î‘ÎŽ' => 'AU',
        'Î‘Ï…' => 'Au',
        'Î‘Ï' => 'Au',
        'Î•ÎŠ' => 'EI',
        'Î•Î™' => 'EI',
        'Î•Î¹' => 'EI',
        'Î•Î¥' => 'EU',
        'Î•ÎŽ' => 'EU',
        'Î•Î¯' => 'Ei',
        'Î•Ï…' => 'Eu',
        'Î•Ï' => 'Eu',
        'ÎŸÎ™' => 'OI',
        'ÎŸÎŠ' => 'OI',
        'ÎŸÎ¥' => 'OU',
        'ÎŸÎŽ' => 'OU',
        'ÎŸÎ¹' => 'Oi',
        'ÎŸÎ¯' => 'Oi',
        'ÎŸÏ…' => 'Ou',
        'ÎŸÏ' => 'Ou',
        'Î¥Î™' => 'YI',
        'ÎŽÎ™' => 'YI',
        'Î¥Î¹' => 'Yi',
        'ÎŽÎ¹' => 'Yi',
        'Î¥ÎŠ' => 'Yi',
        'Î¥Î¯' => 'Yi',
        'Î±Ï…' => 'au',
        'Î±Ï' => 'au',
        'ÎµÎ¯' => 'ei',
        'ÎµÎ¹' => 'ei',
        'ÎµÏ…' => 'eu',
        'ÎµÏ' => 'eu',
        'Î¿Î¹' => 'oi',
        'Î¿Î¯' => 'oi',
        'Î¿Ï…' => 'ou',
        'Î¿Ï' => 'ou',
        'Ï…Î¹' => 'yi',
        'ÏÎ¹' => 'yi',
        'Ï…Î¯' => 'yi',
        'Î‘'  => 'A',
        'Î†'  => 'A',
        'Î’'  => 'B',
        'Î”'  => 'D',
        'Î•'  => 'E',
        'Îˆ'  => 'E',
        'Î¦'  => 'F',
        'Î“'  => 'G',
        'Î—'  => 'H',
        'Î‰'  => 'H',
        'Î™'  => 'I',
        'ÎŠ'  => 'I',
        'Îª'  => 'I',
        'Îš'  => 'K',
        'Îž'  => 'Ks',
        'Î›'  => 'L',
        'Îœ'  => 'M',
        'Î'  => 'N',
        'Î '  => 'N',
        'ÎŸ'  => 'O',
        'ÎŒ'  => 'O',
        'Î¨'  => 'Ps',
        'Î¡'  => 'R',
        'Î£'  => 'S',
        'Î¤'  => 'T',
        'Î˜'  => 'Th',
        'Î©'  => 'W',
        'Î'  => 'W',
        'Î§'  => 'X',
        'Ï’'  => 'Y',
        'Î¥'  => 'Y',
        'ÎŽ'  => 'Y',
        'Î«'  => 'Y',
        'Î–'  => 'Z',
        'Î±'  => 'a',
        'Î¬'  => 'a',
        'Î²'  => 'b',
        'Î´'  => 'd',
        'Îµ'  => 'e',
        'Î­'  => 'e',
        'Ï†'  => 'f',
        'Î³'  => 'g',
        'Î·'  => 'h',
        'Î®'  => 'h',
        'Î¹'  => 'i',
        'Î¯'  => 'i',
        'ÏŠ'  => 'i',
        'Î'  => 'i',
        'Îº'  => 'k',
        'Î¾'  => 'ks',
        'Î»'  => 'l',
        'Î¼'  => 'm',
        'Î½'  => 'n',
        'Î¿'  => 'o',
        'ÏŒ'  => 'o',
        'Ï€'  => 'p',
        'Ïˆ'  => 'ps',
        'Ï'  => 'r',
        'Ïƒ'  => 's',
        'Ï‚'  => 's',
        'Ï„'  => 't',
        'Ï‘'  => 'th',
        'Î¸'  => 'th',
        'Ï'  => 'v',
        'Ï‰'  => 'w',
        'ÏŽ'  => 'w',
        'Ï‡'  => 'x',
        'Ï…'  => 'y',
        'Ï'  => 'y',
        'Î°'  => 'y',
        'Ï‹'  => 'y',
        'Î¶'  => 'z',
    ],
    // Greek (EllÃ¡da)
    'el' => [
        'Î‘Î¥' => 'AU',
        'Î‘Ï…' => 'Au',
        'ÎŸÎ¥' => 'U',
        'ÎŸÏ…' => 'u',
        'Î•Î¥' => 'EF',
        'Î•Ï…' => 'Ef',
        'Î•Î™' => 'I',
        'Î•Î¹' => 'I',
        'ÎŸÎ™' => 'I',
        'ÎŸÎ¹' => 'I',
        'Î¥Î™' => 'I',
        'Î¥Î¹' => 'I',
        'Î‘ÎŽ' => 'AU',
        'Î‘Ï' => 'Au',
        'ÎŸÎŽ' => 'OU',
        'ÎŸÏ' => 'Ou',
        'Î•ÎŽ' => 'EU',
        'Î•Ï' => 'Eu',
        'Î•ÎŠ' => 'I',
        'Î•Î¯' => 'I',
        'ÎŸÎŠ' => 'I',
        'ÎŸÎ¯' => 'I',
        'ÎŽÎ™' => 'I',
        'ÎŽÎ¹' => 'I',
        'Î¥ÎŠ' => 'I',
        'Î¥Î¯' => 'I',
        'Î±Ï…' => 'au',
        'Î¿Ï…' => 'u',
        'ÎµÏ…' => 'ef',
        'ÎµÎ¹' => 'i',
        'Î¿Î¹' => 'i',
        'Ï…Î¹' => 'i',
        'Î±Ï' => 'au',
        'Î¿Ï' => 'ou',
        'ÎµÏ' => 'eu',
        'ÎµÎ¯' => 'i',
        'Î¿Î¯' => 'i',
        'ÏÎ¹' => 'i',
        'Ï…Î¯' => 'i',
        'Î±'  => 'a',
        'Î²'  => 'v',
        'Î³'  => 'gh',
        'Î´'  => 'd',
        'Îµ'  => 'e',
        'Î¶'  => 'z',
        'Î·'  => 'i',
        'Î¸'  => 'th',
        'Î¹'  => 'i',
        'Îº'  => 'k',
        'Î»'  => 'l',
        'Î¼'  => 'm',
        'Î½'  => 'n',
        'Î¾'  => 'ks',
        'Î¿'  => 'o',
        'Ï€'  => 'p',
        'Ï'  => 'r',
        'Ïƒ'  => 's',
        'Ï„'  => 't',
        'Ï…'  => 'i',
        'Ï†'  => 'f',
        'Ï‡'  => 'kh',
        'Ïˆ'  => 'ps',
        'Ï‰'  => 'o',
        'Î¬'  => 'a',
        'Î­'  => 'e',
        'Î¯'  => 'i',
        'ÏŒ'  => 'o',
        'Ï’'  => 'Y',
        'Ï'  => 'y',
        'Î®'  => 'i',
        'ÏŽ'  => 'w',
        'Ï‚'  => 's',
        'ÏŠ'  => 'i',
        'Î°'  => 'y',
        'Ï‹'  => 'y',
        'Î'  => 'i',
        'Î‘'  => 'A',
        'Î’'  => 'B',
        'Î“'  => 'G',
        'Î”'  => 'D',
        'Î•'  => 'E',
        'Î–'  => 'Z',
        'Î—'  => 'H',
        'Î˜'  => 'Th',
        'Î™'  => 'I',
        'Îš'  => 'K',
        'Î›'  => 'L',
        'Îœ'  => 'M',
        'Î'  => 'N',
        'Îž'  => 'Ks',
        'ÎŸ'  => 'O',
        'Î '  => 'P',
        'Î¡'  => 'R',
        'Î£'  => 'S',
        'Î¤'  => 'T',
        'Î¥'  => 'Y',
        'Î¦'  => 'F',
        'Î§'  => 'X',
        'Î¨'  => 'Ps',
        'Î©'  => 'O',
        'Î†'  => 'A',
        'Îˆ'  => 'E',
        'ÎŠ'  => 'I',
        'ÎŒ'  => 'O',
        'ÎŽ'  => 'Y',
        'Î‰'  => 'I',
        'Î'  => 'W',
        'Îª'  => 'I',
        'Î«'  => 'Y',
        'Ï'  => 'v',
        'Ï‘'  => 'th',
    ],
    // Hindi
    'hi' => [
        'à¤…'  => 'a',
        'à¤†'  => 'aa',
        'à¤'  => 'e',
        'à¤ˆ'  => 'ii',
        'à¤'  => 'ei',
        'à¤Ž'  => 'ae',
        'à¤'  => 'ai',
        'à¤‡'  => 'i',
        'à¤“'  => 'o',
        'à¤‘'  => 'oi',
        'à¤’'  => 'oii',
        'à¤Š'  => 'uu',
        'à¤”'  => 'ou',
        'à¤‰'  => 'u',
        'à¤¬'  => 'B',
        'à¤­'  => 'Bha',
        'à¤š'  => 'Ca',
        'à¤›'  => 'Chha',
        'à¤¡'  => 'Da',
        'à¤¢'  => 'Dha',
        'à¤«'  => 'Fa',
        'à¤«à¤¼' => 'Fi',
        'à¤—'  => 'Ga',
        'à¤˜'  => 'Gha',
        'à¤—à¤¼' => 'Ghi',
        'à¤¹'  => 'Ha',
        'à¤œ'  => 'Ja',
        'à¤'  => 'Jha',
        'à¤•'  => 'Ka',
        'à¤–'  => 'Kha',
        'à¤–à¤¼' => 'Khi',
        'à¤²'  => 'L',
        'à¤³'  => 'Li',
        'à¤Œ'  => 'Li',
        'à¤´'  => 'Lii',
        'à¥¡'  => 'Lii',
        'à¤®'  => 'Ma',
        'à¤¨'  => 'Na',
        'à¤™'  => 'Na',
        'à¤ž'  => 'Nia',
        'à¤£'  => 'Nae',
        'à¤©'  => 'Ni',
        'à¥'  => 'oms',
        'à¤ª'  => 'Pa',
        'à¤•à¤¼' => 'Qi',
        'à¤°'  => 'Ra',
        'à¤‹'  => 'Ri',
        'à¥ '  => 'Ri',
        'à¤±'  => 'Ri',
        'à¤¸'  => 'Sa',
        'à¤¶'  => 'Sha',
        'à¤·'  => 'Shha',
        'à¤Ÿ'  => 'Ta',
        'à¤¤'  => 'Ta',
        'à¤ '  => 'Tha',
        'à¤¦'  => 'Tha',
        'à¤¥'  => 'Tha',
        'à¤§'  => 'Thha',
        'à¤¡à¤¼' => 'ugDha',
        'à¤¢à¤¼' => 'ugDhha',
        'à¤µ'  => 'Va',
        'à¤¯'  => 'Ya',
        'à¤¯à¤¼' => 'Yi',
        'à¤œà¤¼' => 'Za',
    ],
    // Armenian
    'hy' => [
        'Ô±' => 'A',
        'Ô²' => 'B',
        'Ô³' => 'G',
        'Ô´' => 'D',
        'Ôµ' => 'E',
        'Ô¶' => 'Z',
        'Ô·' => 'E',
        'Ô¸' => 'Y',
        'Ô¹' => 'Th',
        'Ôº' => 'Zh',
        'Ô»' => 'I',
        'Ô¼' => 'L',
        'Ô½' => 'Kh',
        'Ô¾' => 'Ts',
        'Ô¿' => 'K',
        'Õ€' => 'H',
        'Õ' => 'Dz',
        'Õ‚' => 'Gh',
        'Õƒ' => 'Tch',
        'Õ„' => 'M',
        'Õ…' => 'Y',
        'Õ†' => 'N',
        'Õ‡' => 'Sh',
        'Õˆ' => 'Vo',
        'Õ‰' => 'Ch',
        'ÕŠ' => 'P',
        'Õ‹' => 'J',
        'ÕŒ' => 'R',
        'Õ' => 'S',
        'ÕŽ' => 'V',
        'Õ' => 'T',
        'Õ' => 'R',
        'Õ‘' => 'C',
        'Õ’' => 'u',
        'Õ“' => 'Ph',
        'Õ”' => 'Q',
        'Ö‡' => 'ev',
        'Õ•' => 'O',
        'Õ–' => 'F',
        'Õ¡' => 'a',
        'Õ¢' => 'b',
        'Õ£' => 'g',
        'Õ¤' => 'd',
        'Õ¥' => 'e',
        'Õ¦' => 'z',
        'Õ§' => 'e',
        'Õ¨' => 'y',
        'Õ©' => 'th',
        'Õª' => 'zh',
        'Õ«' => 'i',
        'Õ¬' => 'l',
        'Õ­' => 'kh',
        'Õ®' => 'ts',
        'Õ¯' => 'k',
        'Õ°' => 'h',
        'Õ±' => 'dz',
        'Õ²' => 'gh',
        'Õ³' => 'tch',
        'Õ´' => 'm',
        'Õµ' => 'y',
        'Õ¶' => 'n',
        'Õ·' => 'sh',
        'Õ¸' => 'vo',
        'Õ¹' => 'ch',
        'Õº' => 'p',
        'Õ»' => 'j',
        'Õ¼' => 'r',
        'Õ½' => 's',
        'Õ¾' => 'v',
        'Õ¿' => 't',
        'Ö€' => 'r',
        'Ö' => 'c',
        'Ö‚' => 'u',
        'Öƒ' => 'ph',
        'Ö„' => 'q',
        'Ö…' => 'o',
        'Ö†' => 'f',
    ],
    // Swedish
    'sv' => [
        'Ã„' => 'A',
        'Ã¤' => 'a',
        'Ã…' => 'A',
        'Ã¥' => 'a',
        'Ã–' => 'O',
        'Ã¶' => 'o',
    ],
    // Turkmen
    'tk' => [
        'Ã‡' => 'C',
        'Ã„' => 'A',
        'Å½' => 'Z',
        'Å‡' => 'N',
        'Ã–' => 'O',
        'Åž' => 'S',
        'Ãœ' => 'U',
        'Ã' => 'Y',
        'Ã§' => 'c',
        'Ã¤' => 'a',
        'Å¾' => 'z',
        'Åˆ' => 'n',
        'Ã¶' => 'o',
        'ÅŸ' => 's',
        'Ã¼' => 'u',
        'Ã½' => 'y',
    ],
    // Turkish
    'tr' => [
        'Åˆ' => 'n',
        'Å‡' => 'N',
        'ÅŸ' => 's',
        'Åž' => 'S',
        'Ä±' => 'i',
        'Ä°' => 'I',
        'Ã§' => 'c',
        'Ã‡' => 'C',
        'Ã¤' => 'a',
        'Ã„' => 'A',
        'Ã¼' => 'u',
        'Ãœ' => 'U',
        'Ã¶' => 'o',
        'Ã–' => 'O',
        'ÄŸ' => 'g',
        'Äž' => 'G',
        'Ã½' => 'y',
        'Ã' => 'Y',
        'Å¾' => 'z',
        'Å½' => 'Z',
    ],
    // Bulgarian
    'bg' => [
        'ÑŒÐ¾' => 'yo',
        'Ð'  => 'A',
        'Ð‘'  => 'B',
        'Ð’'  => 'V',
        'Ð“'  => 'G',
        'Ð”'  => 'D',
        'Ð•'  => 'E',
        'Ð–'  => 'Zh',
        'Ð—'  => 'Z',
        'Ð˜'  => 'I',
        'Ð™'  => 'Y',
        'Ðš'  => 'K',
        'Ð›'  => 'L',
        'Ðœ'  => 'M',
        'Ð'  => 'N',
        'Ðž'  => 'O',
        'ÐŸ'  => 'P',
        'Ð '  => 'R',
        'Ð¡'  => 'S',
        'Ð¢'  => 'T',
        'Ð£'  => 'U',
        'Ð¤'  => 'F',
        'Ð¥'  => 'H',
        'Ð¦'  => 'C',
        'Ð§'  => 'Ch',
        'Ð¨'  => 'Sh',
        'Ð©'  => 'Sht',
        'Ðª'  => 'A',
        'Ð¬'  => '',
        'Ð®'  => 'Yu',
        'Ð¯'  => 'Ya',
        'Ð°'  => 'a',
        'Ð±'  => 'b',
        'Ð²'  => 'v',
        'Ð³'  => 'g',
        'Ð´'  => 'd',
        'Ðµ'  => 'e',
        'Ð¶'  => 'zh',
        'Ð·'  => 'z',
        'Ð¸'  => 'i',
        'Ð¹'  => 'y',
        'Ðº'  => 'k',
        'Ð»'  => 'l',
        'Ð¼'  => 'm',
        'Ð½'  => 'n',
        'Ð¾'  => 'o',
        'Ð¿'  => 'p',
        'Ñ€'  => 'r',
        'Ñ'  => 's',
        'Ñ‚'  => 't',
        'Ñƒ'  => 'u',
        'Ñ„'  => 'f',
        'Ñ…'  => 'h',
        'Ñ†'  => 'c',
        'Ñ‡'  => 'ch',
        'Ñˆ'  => 'sh',
        'Ñ‰'  => 'sht',
        'ÑŠ'  => 'a',
        'ÑŒ'  => '',
        'ÑŽ'  => 'yu',
        'Ñ'  => 'ya',
    ],
    // Hungarian
    'hu' => [
        'Ã' => 'A',
        'Ä’' => 'E',
        'Ã‰' => 'E',
        'Ã' => 'I',
        'Ã“' => 'O',
        'Ã–' => 'O',
        'Å' => 'O',
        'Ãš' => 'U',
        'Ãœ' => 'U',
        'Å°' => 'U',
        'Ã¡' => 'a',
        'Ä“' => 'e',
        'Ã©' => 'e',
        'Ã­' => 'i',
        'Ã³' => 'o',
        'Ã¶' => 'o',
        'Å‘' => 'o',
        'Ãº' => 'u',
        'Ã¼' => 'u',
        'Å±' => 'u',
    ],
    // Myanmar (Burmese)
    'my' => [
        'á€”á€ºá€¯á€•á€º' => 'nub',
        'á€±á€¬á€„á€º'  => 'aung',
        'á€­á€¯á€€á€º'  => 'aik',
        'á€­á€¯á€’á€º'  => 'ok',
        'á€­á€¯á€„á€º'  => 'aing',
        'á€­á€¯á€œá€º'  => 'ol',
        'á€±á€«á€„á€º'  => 'aung',
        'á€žá€¼á€±á€¬'  => 'aw',
        'á€±á€¬á€€á€º'  => 'auk',
        'á€­á€á€º'   => 'eik',
        'á€¯á€á€º'   => 'ok',
        'á€¯á€”á€º'   => 'on',
        'á€±á€á€º'   => 'it',
        'á€¯á€’á€º'   => 'ait',
        'á€¬á€”á€º'   => 'an',
        'á€­á€”á€º'   => 'ein',
        'á€½á€á€º'   => 'ut',
        'á€±á€«á€º'   => 'aw',
        'á€½á€”á€º'   => 'un',
        'á€­á€•á€º'   => 'eik',
        'á€¯á€•á€º'   => 'ok',
        'á€½á€•á€º'   => 'ut',
        'á€­á€™á€º'   => 'ein',
        'á€¯á€™á€º'   => 'on',
        'á€±á€¬á€º'   => 'aw',
        'á€½á€™á€º'   => 'un',
        'á€€á€º'    => 'et',
        'á€±á€«'    => 'aw',
        'á€±á€¬'    => 'aw',
        'á€»á€½'    => 'ywa',
        'á€¼á€½'    => 'yw',
        'á€­á€¯'    => 'o',
        'á€¯á€¶'    => 'on',
        'á€á€º'    => 'at',
        'á€„á€º'    => 'in',
        'á€Šá€º'    => 'i',
        'á€’á€º'    => 'd',
        'á€”á€º'    => 'an',
        'á€•á€º'    => 'at',
        'á€™á€º'    => 'an',
        'á€…á€»'    => 'za',
        'á€šá€º'    => 'e',
        'á€‰á€º'    => 'in',
        'á€…á€º'    => 'it',
        'á€­á€¶'    => 'ein',
        'á€²'     => 'e',
        'á€¸'     => '',
        'á€¬'     => 'a',
        'á€«'     => 'a',
        'á€±'     => 'e',
        'á€¶'     => 'an',
        'á€­'     => 'i',
        'á€®'     => 'i',
        'á€¯'     => 'u',
        'á€°'     => 'u',
        'á€º'     => 'at',
        'á€¹'     => '',
        'á€·'     => '',
        'á€€'     => 'k',
        'á‰'     => '9',
        'á€'     => 't',
        'á€›'     => 'ya',
        'á€š'     => 'y',
        'á€™'     => 'm',
        'á€˜'     => 'ba',
        'á€—'     => 'b',
        'á€–'     => 'pa',
        'á€•'     => 'p',
        'á€”'     => 'n',
        'á€“'     => 'da',
        'á€’'     => 'd',
        'á€‘'     => 'ta',
        'á€'     => 'na',
        'á€'     => 'w',
        'á€Ž'     => 'da',
        'á€'     => 'd',
        'á€Œ'     => 'ta',
        'á€‹'     => 't',
        'á€Š'     => 'ny',
        'á€‡'     => 'z',
        'á€†'     => 'sa',
        'á€…'     => 's',
        'á€„'     => 'ng',
        'á€ƒ'     => 'ga',
        'á€‚'     => 'g',
        'á€œ'     => 'l',
        'á€ž'     => 'th',
        'áˆ'     => '8',
        'á€©'     => 'aw',
        'á€'     => 'kh',
        'á†'     => '6',
        'á…'     => '5',
        'á„'     => '4',
        'áƒ'     => '3',
        'á‚'     => '2',
        'á'     => '1',
        'á€'     => '0',
        'áŒ'     => 'hnaik',
        'á'     => 'ywae',
        'á€ª'     => 'aw',
        'á€¦'     => '-u',
        'á€Ÿ'     => 'h',
        'á€‰'     => 'u',
        'á€¤'     => '-i',
        'á€£'     => 'i',
        'á'     => '-e',
        'á€§'     => 'e',
        'á€¾'     => 'h',
        'á€½'     => 'w',
        'á€»'     => 'ya',
        'á€¼'     => 'y',
        'á€¡'     => 'a',
        'á€ '     => 'la',
        'á‡'     => '7',
    ],
    // Croatian (Hrvatska)
    'hr' => [
        'DÅ½' => 'DZ',
        'DÅ¾' => 'Dz',
        'dÅ¾' => 'dz',
        'Ç±'  => 'DZ',
        'Ç²'  => 'Dz',
        'Ç³'  => 'dz',
        'Ä²'  => 'IJ',
        'Ä³'  => 'ij',
        'Ç‡'  => 'LJ',
        'Çˆ'  => 'Lj',
        'Ç‰'  => 'lj',
        'ÇŠ'  => 'NJ',
        'Ç‹'  => 'Nj',
        'ÇŒ'  => 'nj',
        'Å¾'  => 'z',
        'Å½'  => 'Z',
        'Ä‘'  => 'dj',
        'Ä'  => 'Dj',
        'Ä'  => 'c',
        'ÄŒ'  => 'C',
        'Ä‡'  => 'c',
        'Ä†'  => 'C',
        'Å¡'  => 's',
        'Å '  => 'S',
    ],
    // Finnish
    'fi' => [
        'Ã„' => 'A',
        'Ã–' => 'O',
        'Ã¤' => 'a',
        'Ã¶' => 'o',
    ],
    // Georgian (Kartvelian)
    'ka' => [
        'áƒ' => 'a',
        'áƒ‘' => 'b',
        'áƒ’' => 'g',
        'áƒ“' => 'd',
        'áƒ”' => 'e',
        'áƒ•' => 'v',
        'áƒ–' => 'z',
        'áƒ—' => 't',
        'áƒ˜' => 'i',
        'áƒ™' => 'k',
        'áƒš' => 'l',
        'áƒ›' => 'm',
        'áƒœ' => 'n',
        'áƒ' => 'o',
        'áƒž' => 'p',
        'áƒŸ' => 'zh',
        'áƒ ' => 'r',
        'áƒ¡' => 's',
        'áƒ¢' => 't',
        'áƒ£' => 'u',
        'áƒ¤' => 'f',
        'áƒ¥' => 'q',
        'áƒ¦' => 'gh',
        'áƒ§' => 'y',
        'áƒ¨' => 'sh',
        'áƒ©' => 'ch',
        'áƒª' => 'ts',
        'áƒ«' => 'dz',
        'áƒ¬' => 'ts',
        'áƒ­' => 'ch',
        'áƒ®' => 'kh',
        'áƒ¯' => 'j',
        'áƒ°' => 'h',
    ],
    // Russian
    'ru' => [
        'Ð' => 'A',
        'Ð°' => 'a',
        'Ð‘' => 'B',
        'Ð±' => 'b',
        'Ð’' => 'V',
        'Ð²' => 'v',
        'Ð“' => 'G',
        'Ð³' => 'g',
        'Ð”' => 'D',
        'Ð´' => 'd',
        'Ð•' => 'E',
        'Ðµ' => 'e',
        'Ð' => 'Yo',
        'Ñ‘' => 'yo',
        'Ð–' => 'Zh',
        'Ð¶' => 'zh',
        'Ð—' => 'Z',
        'Ð·' => 'z',
        'Ð˜' => 'I',
        'Ð¸' => 'i',
        'Ð™' => 'Y',
        'Ð¹' => 'y',
        'Ðš' => 'K',
        'Ðº' => 'k',
        'Ð›' => 'L',
        'Ð»' => 'l',
        'Ðœ' => 'M',
        'Ð¼' => 'm',
        'Ð' => 'N',
        'Ð½' => 'n',
        'Ðž' => 'O',
        'Ð¾' => 'o',
        'ÐŸ' => 'P',
        'Ð¿' => 'p',
        'Ð ' => 'R',
        'Ñ€' => 'r',
        'Ð¡' => 'S',
        'Ñ' => 's',
        'Ð¢' => 'T',
        'Ñ‚' => 't',
        'Ð£' => 'U',
        'Ñƒ' => 'u',
        'Ð¤' => 'F',
        'Ñ„' => 'f',
        'Ð¥' => 'H',
        'Ñ…' => 'h',
        'Ð¦' => 'Ts',
        'Ñ†' => 'ts',
        'Ð§' => 'Ch',
        'Ñ‡' => 'ch',
        'Ñˆ' => 'sh',
        'Ð¨' => 'Sh',
        'Ð©' => 'Sch',
        'Ñ‰' => 'sch',
        'Ðª' => '',
        'ÑŠ' => '',
        'Ð«' => 'Y',
        'Ñ‹' => 'y',
        'Ð¬' => '',
        'ÑŒ' => '',
        'Ð­' => 'E',
        'Ñ' => 'e',
        'Ð®' => 'Yu',
        'ÑŽ' => 'yu',
        'Ð¯' => 'Ya',
        'Ñ' => 'ya',
    ],
    // Russian - GOST 7.79-2000(B)
    // -> https://en.m.wikipedia.org/wiki/Romanization_of_Russian#content-collapsible-block-1
    'ru__gost_2000_b' => [
        'Ð' => 'A',
        'Ð°' => 'a',
        'Ð‘' => 'B',
        'Ð±' => 'b',
        'Ð’' => 'V',
        'Ð²' => 'v',
        'Ð“' => 'G',
        'Ð³' => 'g',
        'Ð”' => 'D',
        'Ð´' => 'd',
        'Ð•' => 'E',
        'Ðµ' => 'e',
        'Ð' => 'Yo',
        'Ñ‘' => 'yo',
        'Ð–' => 'Zh',
        'Ð¶' => 'zh',
        'Ð—' => 'Z',
        'Ð·' => 'z',
        'Ð˜' => 'i',
        'Ð¸' => 'i',
        'Ð™' => 'i',
        'Ð¹' => 'i',
        'Ðš' => 'K',
        'Ðº' => 'k',
        'Ð›' => 'L',
        'Ð»' => 'l',
        'Ðœ' => 'M',
        'Ð¼' => 'm',
        'Ð' => 'N',
        'Ð½' => 'n',
        'Ðž' => 'O',
        'Ð¾' => 'o',
        'ÐŸ' => 'P',
        'Ð¿' => 'p',
        'Ð ' => 'R',
        'Ñ€' => 'r',
        'Ð¡' => 'S',
        'Ñ' => 's',
        'Ð¢' => 'T',
        'Ñ‚' => 't',
        'Ð£' => 'U',
        'Ñƒ' => 'u',
        'Ð¤' => 'F',
        'Ñ„' => 'f',
        'Ð¥' => 'X',
        'Ñ…' => 'x',
        'Ð¦' => 'Cz',
        'Ñ†' => 'cz',
        'Ð§' => 'Ch',
        'Ñ‡' => 'ch',
        'Ñˆ' => 'sh',
        'Ð¨' => 'Sh',
        'Ð©' => 'Shh',
        'Ñ‰' => 'shh',
        'Ðª' => '',
        'ÑŠ' => '',
        'Ð«' => 'Y\'',
        'Ñ‹' => 'y\'',
        'Ð¬' => '',
        'ÑŒ' => '',
        'Ð­' => 'E\'',
        'Ñ' => 'e\'',
        'Ð®' => 'Yu',
        'ÑŽ' => 'yu',
        'Ð¯' => 'Ya',
        'Ñ' => 'ya',
        'Ð†' => 'I',
        'Ñ–' => 'i',
        'Ñ²' => 'Fh',
        'Ñ³' => 'fh',
        'Ñ¢' => 'Ye',
        'Ñ£' => 'ye',
        'Ñ´' => 'Yh',
        'Ñµ' => 'yh',
        'Ð„' => '',
        'Ñ”' => '',
        'Ñ¤' => '',
        'Ñ¥' => '',
        'Ð…' => 'Js',
        'Ñ•' => 'js',
        'ê™Š' => '',
        'ê™‹' => '',
        'Ñ ' => '',
        'Ñ¡' => '',
        'Ñ¾' => '',
        'Ñ¿' => '',
        'Ñª' => '',
        'Ñ«' => '',
        'Ñ¦' => '',
        'Ñ§' => '',
        'Ñ¬' => '',
        'Ñ­' => '',
        'Ñ¨' => '',
        'Ñ©' => '',
        'Ñ®' => '',
        'Ñ¯' => '',
        'Ñ°' => '',
        'Ñ±' => '',
    ],
    // Russian - Passport (2013), ICAO
    // -> https://en.m.wikipedia.org/wiki/Romanization_of_Russian#content-collapsible-block-1
    'ru__passport_2013' => [
        'Ð' => 'A',
        'Ð°' => 'a',
        'Ð‘' => 'B',
        'Ð±' => 'b',
        'Ð’' => 'V',
        'Ð²' => 'v',
        'Ð“' => 'G',
        'Ð³' => 'g',
        'Ð”' => 'D',
        'Ð´' => 'd',
        'Ð•' => 'E',
        'Ðµ' => 'e',
        'Ð' => 'E',
        'Ñ‘' => 'e',
        'Ð–' => 'Zh',
        'Ð¶' => 'zh',
        'Ð—' => 'Z',
        'Ð·' => 'z',
        'Ð˜' => 'i',
        'Ð¸' => 'i',
        'Ð™' => 'i',
        'Ð¹' => 'i',
        'Ðš' => 'K',
        'Ðº' => 'k',
        'Ð›' => 'L',
        'Ð»' => 'l',
        'Ðœ' => 'M',
        'Ð¼' => 'm',
        'Ð' => 'N',
        'Ð½' => 'n',
        'Ðž' => 'O',
        'Ð¾' => 'o',
        'ÐŸ' => 'P',
        'Ð¿' => 'p',
        'Ð ' => 'R',
        'Ñ€' => 'r',
        'Ð¡' => 'S',
        'Ñ' => 's',
        'Ð¢' => 'T',
        'Ñ‚' => 't',
        'Ð£' => 'U',
        'Ñƒ' => 'u',
        'Ð¤' => 'F',
        'Ñ„' => 'f',
        'Ð¥' => 'Kh',
        'Ñ…' => 'kh',
        'Ð¦' => 'Ts',
        'Ñ†' => 'ts',
        'Ð§' => 'Ch',
        'Ñ‡' => 'ch',
        'Ñˆ' => 'sh',
        'Ð¨' => 'Sh',
        'Ð©' => 'Shch',
        'Ñ‰' => 'shch',
        'Ðª' => 'Ie',
        'ÑŠ' => 'ie',
        'Ð«' => 'Y',
        'Ñ‹' => 'y',
        'Ð¬' => '',
        'ÑŒ' => '',
        'Ð­' => 'E',
        'Ñ' => 'e',
        'Ð®' => 'Iu',
        'ÑŽ' => 'iu',
        'Ð¯' => 'Ia',
        'Ñ' => 'ia',
        'Ð†' => '',
        'Ñ–' => '',
        'Ñ²' => '',
        'Ñ³' => '',
        'Ñ¢' => '',
        'Ñ£' => '',
        'Ñ´' => '',
        'Ñµ' => '',
        'Ð„' => '',
        'Ñ”' => '',
        'Ñ¤' => '',
        'Ñ¥' => '',
        'Ð…' => '',
        'Ñ•' => '',
        'ê™Š' => '',
        'ê™‹' => '',
        'Ñ ' => '',
        'Ñ¡' => '',
        'Ñ¾' => '',
        'Ñ¿' => '',
        'Ñª' => '',
        'Ñ«' => '',
        'Ñ¦' => '',
        'Ñ§' => '',
        'Ñ¬' => '',
        'Ñ­' => '',
        'Ñ¨' => '',
        'Ñ©' => '',
        'Ñ®' => '',
        'Ñ¯' => '',
        'Ñ°' => '',
        'Ñ±' => '',
    ],
    // Ukrainian
    // -> https://zakon.rada.gov.ua/laws/show/55-2010-%D0%BF?lang=en
    'uk' => [
        'Ð“' => 'H',
        'Ð³' => 'h',
        'Ò' => 'G',
        'Ò‘' => 'g',
        'Ð„' => 'Ye',
        'Ñ”' => 'ye',
        'Ð˜' => 'Y',
        'Ð¸' => 'y',
        'Ð†' => 'I',
        'Ñ–' => 'i',
        'Ð‡' => 'Yi',
        'Ñ—' => 'yi',
        'Ð™' => 'Y',
        'Ð¹' => 'y',
        'Ð¥' => 'Kh',
        'Ñ…' => 'kh',
        'Ð¦' => 'Ts',
        'Ñ†' => 'ts',
        'Ð§' => 'Ch',
        'Ñ‡' => 'ch',
        'Ð¨' => 'Sh',
        'Ñˆ' => 'sh',
        'Ð©' => 'Shch',
        'Ñ‰' => 'shch',
    ],
    // Kazakh
    'kk' => [
        'Ó˜' => 'A',
        'Ò’' => 'G',
        'Òš' => 'Q',
        'Ò¢' => 'N',
        'Ó¨' => 'O',
        'Ò°' => 'U',
        'Ò®' => 'U',
        'Òº' => 'H',
        'Ó™' => 'a',
        'Ò“' => 'g',
        'Ò›' => 'q',
        'Ò£' => 'n',
        'Ó©' => 'o',
        'Ò±' => 'u',
        'Ò¯' => 'u',
        'Ò»' => 'h',
    ],
    // Czech
    'cs' => [
        'Ã¡' => 'a',
        'Ã' => 'A',
        'Ä' => 'c',
        'ÄŒ' => 'C',
        'Ä' => 'd',
        'ÄŽ' => 'D',
        'Ã©' => 'e',
        'Ã‰' => 'E',
        'Ä›' => 'e',
        'Äš' => 'E',
        'Ã­' => 'i',
        'Ã' => 'I',
        'Åˆ' => 'n',
        'Å‡' => 'N',
        'Ã³' => 'o',
        'Ã“' => 'O',
        'Å™' => 'r',
        'Å˜' => 'R',
        'Å¡' => 's',
        'Å ' => 'S',
        'Å¥' => 't',
        'Å¤' => 'T',
        'Ãº' => 'u',
        'Ãš' => 'U',
        'Å¯' => 'u',
        'Å®' => 'U',
        'Ã½' => 'y',
        'Ã' => 'Y',
        'Å¾' => 'z',
        'Å½' => 'Z',
    ],
    // Danish
    'da' => [
        'Ã†' => 'Ae',
        'Ã¦' => 'ae',
        'Ã˜' => 'Oe',
        'Ã¸' => 'oe',
        'Ã…' => 'Aa',
        'Ã¥' => 'aa',
        'Ã‰' => 'E',
        'Ã©' => 'e',
    ],
    // Polish
    'pl' => [
        'Ä…' => 'a',
        'Ä‡' => 'c',
        'Ä™' => 'e',
        'Å‚' => 'l',
        'Å„' => 'n',
        'Ã³' => 'o',
        'Å›' => 's',
        'Åº' => 'z',
        'Å¼' => 'z',
        'Ä„' => 'A',
        'Ä†' => 'C',
        'Ä˜' => 'E',
        'Å' => 'L',
        'Åƒ' => 'N',
        'Ã“' => 'O',
        'Åš' => 'S',
        'Å¹' => 'Z',
        'Å»' => 'Z',
    ],
    // Romanian
    'ro' => [
        'Äƒ' => 'a',
        'Ã¢' => 'a',
        'Ä‚' => 'A',
        'Ã‚' => 'A',
        'Ã®' => 'i',
        'ÃŽ' => 'I',
        'È™' => 's',
        'ÅŸ' => 's',
        'Åž' => 'S',
        'È˜' => 'S',
        'È›' => 't',
        'Å£' => 't',
        'Å¢' => 'T',
        'Èš' => 'T',
    ],
    // Esperanto
    'eo' => [
        'Ä‰' => 'cx',
        'Ä' => 'gx',
        'Ä¥' => 'hx',
        'Äµ' => 'jx',
        'Å' => 'sx',
        'Å­' => 'ux',
        'Äˆ' => 'CX',
        'Äœ' => 'GX',
        'Ä¤' => 'HX',
        'Ä´' => 'JX',
        'Åœ' => 'SX',
        'Å¬' => 'UX',
    ],
    // Estonian
    'et' => [
        'Å ' => 'S',
        'Å½' => 'Z',
        'Ã•' => 'O',
        'Ã„' => 'A',
        'Ã–' => 'O',
        'Ãœ' => 'U',
        'Å¡' => 's',
        'Å¾' => 'z',
        'Ãµ' => 'o',
        'Ã¤' => 'a',
        'Ã¶' => 'o',
        'Ã¼' => 'u',
    ],
    // Latvian
    'lv' => [
        'Ä' => 'a',
        'Ä' => 'c',
        'Ä“' => 'e',
        'Ä£' => 'g',
        'Ä«' => 'i',
        'Ä·' => 'k',
        'Ä¼' => 'l',
        'Å†' => 'n',
        'Å¡' => 's',
        'Å«' => 'u',
        'Å¾' => 'z',
        'Ä€' => 'A',
        'ÄŒ' => 'C',
        'Ä’' => 'E',
        'Ä¢' => 'G',
        'Äª' => 'i',
        'Ä¶' => 'k',
        'Ä»' => 'L',
        'Å…' => 'N',
        'Å ' => 'S',
        'Åª' => 'u',
        'Å½' => 'Z',
    ],
    // Lithuanian
    'lt' => [
        'Ä…' => 'a',
        'Ä' => 'c',
        'Ä™' => 'e',
        'Ä—' => 'e',
        'Ä¯' => 'i',
        'Å¡' => 's',
        'Å³' => 'u',
        'Å«' => 'u',
        'Å¾' => 'z',
        'Ä„' => 'A',
        'ÄŒ' => 'C',
        'Ä˜' => 'E',
        'Ä–' => 'E',
        'Ä®' => 'I',
        'Å ' => 'S',
        'Å²' => 'U',
        'Åª' => 'U',
        'Å½' => 'Z',
    ],
    // Norwegian
    'no' => [
        'Ã†' => 'AE',
        'Ã¦' => 'ae',
        'Ã˜' => 'OE',
        'Ã¸' => 'oe',
        'Ã…' => 'AA',
        'Ã¥' => 'aa',
    ],
    // Vietnamese
    'vi' => [
        'Ã' => 'A',
        'Ã€' => 'A',
        'áº¢' => 'A',
        'Ãƒ' => 'A',
        'áº ' => 'A',
        'Ä‚' => 'A',
        'áº®' => 'A',
        'áº°' => 'A',
        'áº²' => 'A',
        'áº´' => 'A',
        'áº¶' => 'A',
        'Ã‚' => 'A',
        'áº¤' => 'A',
        'áº¦' => 'A',
        'áº¨' => 'A',
        'áºª' => 'A',
        'áº¬' => 'A',
        'Ã¡' => 'a',
        'Ã ' => 'a',
        'áº£' => 'a',
        'Ã£' => 'a',
        'áº¡' => 'a',
        'Äƒ' => 'a',
        'áº¯' => 'a',
        'áº±' => 'a',
        'áº³' => 'a',
        'áºµ' => 'a',
        'áº·' => 'a',
        'Ã¢' => 'a',
        'áº¥' => 'a',
        'áº§' => 'a',
        'áº©' => 'a',
        'áº«' => 'a',
        'áº­' => 'a',
        'Ã‰' => 'E',
        'Ãˆ' => 'E',
        'áºº' => 'E',
        'áº¼' => 'E',
        'áº¸' => 'E',
        'ÃŠ' => 'E',
        'áº¾' => 'E',
        'á»€' => 'E',
        'á»‚' => 'E',
        'á»„' => 'E',
        'á»†' => 'E',
        'Ã©' => 'e',
        'Ã¨' => 'e',
        'áº»' => 'e',
        'áº½' => 'e',
        'áº¹' => 'e',
        'Ãª' => 'e',
        'áº¿' => 'e',
        'á»' => 'e',
        'á»ƒ' => 'e',
        'á»…' => 'e',
        'á»‡' => 'e',
        'Ã' => 'I',
        'ÃŒ' => 'I',
        'á»ˆ' => 'I',
        'Ä¨' => 'I',
        'á»Š' => 'I',
        'Ã­' => 'i',
        'Ã¬' => 'i',
        'á»‰' => 'i',
        'Ä©' => 'i',
        'á»‹' => 'i',
        'Ã“' => 'O',
        'Ã’' => 'O',
        'á»Ž' => 'O',
        'Ã•' => 'O',
        'á»Œ' => 'O',
        'Ã”' => 'O',
        'á»' => 'O',
        'á»’' => 'O',
        'á»”' => 'O',
        'á»–' => 'O',
        'á»˜' => 'O',
        'Æ ' => 'O',
        'á»š' => 'O',
        'á»œ' => 'O',
        'á»ž' => 'O',
        'á» ' => 'O',
        'á»¢' => 'O',
        'Ã³' => 'o',
        'Ã²' => 'o',
        'á»' => 'o',
        'Ãµ' => 'o',
        'á»' => 'o',
        'Ã´' => 'o',
        'á»‘' => 'o',
        'á»“' => 'o',
        'á»•' => 'o',
        'á»—' => 'o',
        'á»™' => 'o',
        'Æ¡' => 'o',
        'á»›' => 'o',
        'á»' => 'o',
        'á»Ÿ' => 'o',
        'á»¡' => 'o',
        'á»£' => 'o',
        'Ãš' => 'U',
        'Ã™' => 'U',
        'á»¦' => 'U',
        'Å¨' => 'U',
        'á»¤' => 'U',
        'Æ¯' => 'U',
        'á»¨' => 'U',
        'á»ª' => 'U',
        'á»¬' => 'U',
        'á»®' => 'U',
        'á»°' => 'U',
        'Ãº' => 'u',
        'Ã¹' => 'u',
        'á»§' => 'u',
        'Å©' => 'u',
        'á»¥' => 'u',
        'Æ°' => 'u',
        'á»©' => 'u',
        'á»«' => 'u',
        'á»­' => 'u',
        'á»¯' => 'u',
        'á»±' => 'u',
        'Ã' => 'Y',
        'á»²' => 'Y',
        'á»¶' => 'Y',
        'á»¸' => 'Y',
        'á»´' => 'Y',
        'Ã½' => 'y',
        'á»³' => 'y',
        'á»·' => 'y',
        'á»¹' => 'y',
        'á»µ' => 'y',
        'Ä' => 'D',
        'Ä‘' => 'd',
    ],
    // Persian (Farsi)
    'fa' => [
        'Ø§' => 'a',
        'Ø¨' => 'b',
        'Ù¾' => 'p',
        'Øª' => 't',
        'Ø«' => 's',
        'Ø¬' => 'j',
        'Ú†' => 'ch',
        'Ø­' => 'h',
        'Ø®' => 'kh',
        'Ø¯' => 'd',
        'Ø°' => 'z',
        'Ø±' => 'r',
        'Ø²' => 'z',
        'Ø³' => 's',
        'Ø´' => 'sh',
        'Øµ' => 's',
        'Ø¶' => 'z',
        'Ø·' => 't',
        'Ø¸' => 'z',
        'Ø¹' => 'a',
        'Øº' => 'gh',
        'Ù' => 'f',
        'Ù‚' => 'gh',
        'Ú©' => 'k',
        'Ú¯' => 'g',
        'Ù„' => 'l',
        'Ú˜' => 'zh',
        'Ùƒ' => 'k',
        'Ù…' => 'm',
        'Ù†' => 'n',
        'Ù‡' => 'h',
        'Ùˆ' => 'o',
        'ÛŒ' => 'y',
        'Ø¢' => 'a',
        'Ù ' => '0',
        'Ù¡' => '1',
        'Ù¢' => '2',
        'Ù£' => '3',
        'Ù¤' => '4',
        'Ù¥' => '5',
        'Ù¦' => '6',
        'Ù§' => '7',
        'Ù¨' => '8',
        'Ù©' => '9',
    ],
    // Arabic
    'ar' => [
        'Ø£' => 'a',
        'Ø¨' => 'b',
        'Øª' => 't',
        'Ø«' => 'th',
        'Ø¬' => 'g',
        'Ø­' => 'h',
        'Ø®' => 'kh',
        'Ø¯' => 'd',
        'Ø°' => 'th',
        'Ø±' => 'r',
        'Ø²' => 'z',
        'Ø³' => 's',
        'Ø´' => 'sh',
        'Øµ' => 's',
        'Ø¶' => 'd',
        'Ø·' => 't',
        'Ø¸' => 'th',
        'Ø¹' => 'aa',
        'Øº' => 'gh',
        'Ù' => 'f',
        'Ù‚' => 'k',
        'Ùƒ' => 'k',
        'Ù„' => 'l',
        'Ù…' => 'm',
        'Ù†' => 'n',
        'Ù‡' => 'h',
        'Ùˆ' => 'o',
        'ÙŠ' => 'y',
        'Ø§' => 'a',
        'Ø¥' => 'a',
        'Ø¢' => 'a',
        'Ø¤' => 'o',
        'Ø¦' => 'y',
        'Ø¡' => 'aa',
        'Ù ' => '0',
        'Ù¡' => '1',
        'Ù¢' => '2',
        'Ù£' => '3',
        'Ù¤' => '4',
        'Ù¥' => '5',
        'Ù¦' => '6',
        'Ù§' => '7',
        'Ù¨' => '8',
        'Ù©' => '9',
    ],
    // Serbian
    'sr' => [
        'Ä‘' => 'dj',
        'Å¾' => 'z',
        'Ä‡' => 'c',
        'Ä' => 'c',
        'Å¡' => 's',
        'Ä' => 'Dj',
        'Å½' => 'Z',
        'Ä†' => 'C',
        'ÄŒ' => 'C',
        'Å ' => 'S',
        'Ð°' => 'a',
        'Ð±' => 'b',
        'Ð²' => 'v',
        'Ð³' => 'g',
        'Ð´' => 'd',
        'Ñ’' => 'dj',
        'Ðµ' => 'e',
        'Ð¶' => 'z',
        'Ð·' => 'z',
        'Ð¸' => 'i',
        'Ñ˜' => 'j',
        'Ðº' => 'k',
        'Ð»' => 'l',
        'Ñ™' => 'lj',
        'Ð¼' => 'm',
        'Ð½' => 'n',
        'Ñš' => 'nj',
        'Ð¾' => 'o',
        'Ð¿' => 'p',
        'Ñ€' => 'r',
        'Ñ' => 's',
        'Ñ‚' => 't',
        'Ñ›' => 'c',
        'Ñƒ' => 'u',
        'Ñ„' => 'f',
        'Ñ…' => 'h',
        'Ñ†' => 'c',
        'Ñ‡' => 'c',
        'ÑŸ' => 'dz',
        'Ñˆ' => 's',
        'Ð' => 'A',
        'Ð‘' => 'B',
        'Ð’' => 'V',
        'Ð“' => 'G',
        'Ð”' => 'D',
        'Ð‚' => 'Dj',
        'Ð•' => 'E',
        'Ð–' => 'Z',
        'Ð—' => 'Z',
        'Ð˜' => 'I',
        'Ðˆ' => 'j',
        'Ðš' => 'K',
        'Ð›' => 'L',
        'Ð‰' => 'Lj',
        'Ðœ' => 'M',
        'Ð' => 'N',
        'ÐŠ' => 'Nj',
        'Ðž' => 'O',
        'ÐŸ' => 'P',
        'Ð ' => 'R',
        'Ð¡' => 'S',
        'Ð¢' => 'T',
        'Ð‹' => 'C',
        'Ð£' => 'U',
        'Ð¤' => 'F',
        'Ð¥' => 'H',
        'Ð¦' => 'C',
        'Ð§' => 'C',
        'Ð' => 'Dz',
        'Ð¨' => 'S',
    ],
    // Serbian - Cyrillic
    'sr__cyr' => [
        'Ð°' => 'a',
        'Ð±' => 'b',
        'Ð²' => 'v',
        'Ð³' => 'g',
        'Ð´' => 'd',
        'Ñ’' => 'dj',
        'Ðµ' => 'e',
        'Ð¶' => 'z',
        'Ð·' => 'z',
        'Ð¸' => 'i',
        'Ñ˜' => 'j',
        'Ðº' => 'k',
        'Ð»' => 'l',
        'Ñ™' => 'lj',
        'Ð¼' => 'm',
        'Ð½' => 'n',
        'Ñš' => 'nj',
        'Ð¾' => 'o',
        'Ð¿' => 'p',
        'Ñ€' => 'r',
        'Ñ' => 's',
        'Ñ‚' => 't',
        'Ñ›' => 'c',
        'Ñƒ' => 'u',
        'Ñ„' => 'f',
        'Ñ…' => 'h',
        'Ñ†' => 'c',
        'Ñ‡' => 'c',
        'ÑŸ' => 'dz',
        'Ñˆ' => 's',
        'Ð' => 'A',
        'Ð‘' => 'B',
        'Ð’' => 'V',
        'Ð“' => 'G',
        'Ð”' => 'D',
        'Ð‚' => 'Dj',
        'Ð•' => 'E',
        'Ð–' => 'Z',
        'Ð—' => 'Z',
        'Ð˜' => 'I',
        'Ðˆ' => 'j',
        'Ðš' => 'K',
        'Ð›' => 'L',
        'Ð‰' => 'Lj',
        'Ðœ' => 'M',
        'Ð' => 'N',
        'ÐŠ' => 'Nj',
        'Ðž' => 'O',
        'ÐŸ' => 'P',
        'Ð ' => 'R',
        'Ð¡' => 'S',
        'Ð¢' => 'T',
        'Ð‹' => 'C',
        'Ð£' => 'U',
        'Ð¤' => 'F',
        'Ð¥' => 'H',
        'Ð¦' => 'C',
        'Ð§' => 'C',
        'Ð' => 'Dz',
        'Ð¨' => 'S',
    ],
    // Serbian - Latin
    'sr__lat' => [
        'Ä‘' => 'dj',
        'Å¾' => 'z',
        'Ä‡' => 'c',
        'Ä' => 'c',
        'Å¡' => 's',
        'Ä' => 'Dj',
        'Å½' => 'Z',
        'Ä†' => 'C',
        'ÄŒ' => 'C',
        'Å ' => 'S',
    ],
    // Azerbaijani
    'az' => [
        'Ã§' => 'c',
        'É™' => 'e',
        'ÄŸ' => 'g',
        'Ä±' => 'i',
        'Ã¶' => 'o',
        'ÅŸ' => 's',
        'Ã¼' => 'u',
        'Ã‡' => 'C',
        'Æ' => 'E',
        'Äž' => 'G',
        'Ä°' => 'I',
        'Ã–' => 'O',
        'Åž' => 'S',
        'Ãœ' => 'U',
    ],
    // Slovak
    'sk' => [
        'Ã¡' => 'a',
        'Ã¤' => 'a',
        'Ä' => 'c',
        'Ä' => 'd',
        'Ã©' => 'e',
        'Ã­' => 'i',
        'Ä¾' => 'l',
        'Äº' => 'l',
        'Åˆ' => 'n',
        'Ã³' => 'o',
        'Ã´' => 'o',
        'Å•' => 'r',
        'Å¡' => 's',
        'Å¥' => 't',
        'Ãº' => 'u',
        'Ã½' => 'y',
        'Å¾' => 'z',
        'Ã' => 'A',
        'Ã„' => 'A',
        'ÄŒ' => 'C',
        'ÄŽ' => 'D',
        'Ã‰' => 'E',
        'Ã' => 'I',
        'Ä½' => 'L',
        'Ä¹' => 'L',
        'Å‡' => 'N',
        'Ã“' => 'O',
        'Ã”' => 'O',
        'Å”' => 'R',
        'Å ' => 'S',
        'Å¤' => 'T',
        'Ãš' => 'U',
        'Ã' => 'Y',
        'Å½' => 'Z',
    ],
    // French
    'fr' => [
        'Ã†' => 'AE',
        'Ã¦' => 'ae',
        'Å’' => 'OE',
        'Å“' => 'oe',
        'Ã¢' => 'a',
        'Ã‚' => 'A',
        'Ã ' => 'a',
        'Ã€' => 'A',
        'Ã¤' => 'a',
        'Ã„' => 'A',
        'Ã§' => 'c',
        'Ã‡' => 'C',
        'Ã©' => 'e',
        'Ã‰' => 'E',
        'Ãª' => 'e',
        'ÃŠ' => 'E',
        'Ã«' => 'e',
        'Ã‹' => 'E',
        'Ã¨' => 'e',
        'Ãˆ' => 'E',
        'Ã¯' => 'i',
        'Ã®' => 'i',
        'Ã' => 'I',
        'ÃŽ' => 'I',
        'Ã¿' => 'y',
        'Å¸' => 'Y',
        'Ã´' => 'o',
        'Ã”' => 'O',
        'Ã¶' => 'o',
        'Ã–' => 'O',
        'Ã»' => 'u',
        'Ã›' => 'U',
        'Ã¹' => 'u',
        'Ã™' => 'U',
        'Ã¼' => 'u',
        'Ãœ' => 'U',
    ],
    // Austrian (French)
    'fr_at' => [
        'ÃŸ' => 'sz',
        'áºž' => 'SZ',
        'Ã†' => 'AE',
        'Ã¦' => 'ae',
        'Å’' => 'OE',
        'Å“' => 'oe',
        'Ã¢' => 'a',
        'Ã‚' => 'A',
        'Ã ' => 'a',
        'Ã€' => 'A',
        'Ã¤' => 'a',
        'Ã„' => 'A',
        'Ã§' => 'c',
        'Ã‡' => 'C',
        'Ã©' => 'e',
        'Ã‰' => 'E',
        'Ãª' => 'e',
        'ÃŠ' => 'E',
        'Ã«' => 'e',
        'Ã‹' => 'E',
        'Ã¨' => 'e',
        'Ãˆ' => 'E',
        'Ã¯' => 'i',
        'Ã®' => 'i',
        'Ã' => 'I',
        'ÃŽ' => 'I',
        'Ã¿' => 'y',
        'Å¸' => 'Y',
        'Ã´' => 'o',
        'Ã”' => 'O',
        'Ã¶' => 'o',
        'Ã–' => 'O',
        'Ã»' => 'u',
        'Ã›' => 'U',
        'Ã¹' => 'u',
        'Ã™' => 'U',
        'Ã¼' => 'u',
        'Ãœ' => 'U',
    ],
    // Switzerland (French)
    'fr_ch' => [
        'ÃŸ' => 'ss',
        'áºž' => 'SS',
        'Ã†' => 'AE',
        'Ã¦' => 'ae',
        'Å’' => 'OE',
        'Å“' => 'oe',
        'Ã¢' => 'a',
        'Ã‚' => 'A',
        'Ã ' => 'a',
        'Ã€' => 'A',
        'Ã¤' => 'a',
        'Ã„' => 'A',
        'Ã§' => 'c',
        'Ã‡' => 'C',
        'Ã©' => 'e',
        'Ã‰' => 'E',
        'Ãª' => 'e',
        'ÃŠ' => 'E',
        'Ã«' => 'e',
        'Ã‹' => 'E',
        'Ã¨' => 'e',
        'Ãˆ' => 'E',
        'Ã¯' => 'i',
        'Ã®' => 'i',
        'Ã' => 'I',
        'ÃŽ' => 'I',
        'Ã¿' => 'y',
        'Å¸' => 'Y',
        'Ã´' => 'o',
        'Ã”' => 'O',
        'Ã¶' => 'o',
        'Ã–' => 'O',
        'Ã»' => 'u',
        'Ã›' => 'U',
        'Ã¹' => 'u',
        'Ã™' => 'U',
        'Ã¼' => 'u',
        'Ãœ' => 'U',
    ],
    // German
    'de' => [
        'Ã„' => 'Ae',
        'Ã–' => 'Oe',
        'Ãœ' => 'Ue',
        'Ã¤' => 'ae',
        'Ã¶' => 'oe',
        'Ã¼' => 'ue',
        'ÃŸ' => 'ss',
        'áºž' => 'SS',
    ],
    // Austrian (German)
    'de_at' => [
        'Ã„' => 'Ae',
        'Ã–' => 'Oe',
        'Ãœ' => 'Ue',
        'Ã¤' => 'ae',
        'Ã¶' => 'oe',
        'Ã¼' => 'ue',
        'ÃŸ' => 'sz',
        'áºž' => 'SZ',
    ],
    // Switzerland (German)
    'de_ch' => [
        'Ã„' => 'Ae',
        'Ã–' => 'Oe',
        'Ãœ' => 'Ue',
        'Ã¤' => 'ae',
        'Ã¶' => 'oe',
        'Ã¼' => 'ue',
        'ÃŸ' => 'ss',
        'áºž' => 'SS',
    ],
    // Bengali (Bangla)
    'bn' => [
        'à¦­à§à¦²'   => 'vl',
        'à¦ªà¦¶'    => 'psh',
        'à¦¬à§à¦§'   => 'bdh',
        'à¦¬à§à¦œ'   => 'bj',
        'à¦¬à§à¦¦'   => 'bd',
        'à¦¬à§à¦¬'   => 'bb',
        'à¦¬à§à¦²'   => 'bl',
        'à¦­'     => 'v',
        'à¦¬'     => 'b',
        'à¦šà§à¦ž'   => 'cNG',
        'à¦šà§à¦›'   => 'cch',
        'à¦šà§à¦š'   => 'cc',
        'à¦›'     => 'ch',
        'à¦š'     => 'c',
        'à¦§à§à¦¨'   => 'dhn',
        'à¦§à§à¦®'   => 'dhm',
        'à¦¦à§à¦˜'   => 'dgh',
        'à¦¦à§à¦§'   => 'ddh',
        'à¦¦à§à¦­'   => 'dv',
        'à¦¦à§à¦®'   => 'dm',
        'à¦¡à§à¦¡'   => 'DD',
        'à¦¢'     => 'Dh',
        'à¦§'     => 'dh',
        'à¦¦à§à¦—'   => 'dg',
        'à¦¦à§à¦¦'   => 'dd',
        'à¦¡'     => 'D',
        'à¦¦'     => 'd',
        'à¥¤'     => '.',
        'à¦˜à§à¦¨'   => 'Ghn',
        'à¦—à§à¦§'   => 'Gdh',
        'à¦—à§à¦£'   => 'GN',
        'à¦—à§à¦¨'   => 'Gn',
        'à¦—à§à¦®'   => 'Gm',
        'à¦—à§à¦²'   => 'Gl',
        'à¦œà§à¦ž'   => 'jNG',
        'à¦˜'     => 'Gh',
        'à¦—'     => 'g',
        'à¦¹à§à¦£'   => 'hN',
        'à¦¹à§à¦¨'   => 'hn',
        'à¦¹à§à¦®'   => 'hm',
        'à¦¹à§à¦²'   => 'hl',
        'à¦¹'     => 'h',
        'à¦œà§à¦'   => 'jjh',
        'à¦'     => 'jh',
        'à¦œà§à¦œ'   => 'jj',
        'à¦œ'     => 'j',
        'à¦•à§à¦·à§à¦£' => 'kxN',
        'à¦•à§à¦·à§à¦®' => 'kxm',
        'à¦•à§à¦·'   => 'ksh',
        'à¦•à¦¶'    => 'ksh',
        'à¦•à§à¦•'   => 'kk',
        'à¦•à§à¦Ÿ'   => 'kT',
        'à¦•à§à¦¤'   => 'kt',
        'à¦•à§à¦²'   => 'kl',
        'à¦•à§à¦¸'   => 'ks',
        'à¦–'     => 'kh',
        'à¦•'     => 'k',
        'à¦²à§à¦­'   => 'lv',
        'à¦²à§à¦§'   => 'ldh',
        'à¦²à¦–'    => 'lkh',
        'à¦²à¦˜'    => 'lgh',
        'à¦²à¦«'    => 'lph',
        'à¦²à§à¦•'   => 'lk',
        'à¦²à§à¦—'   => 'lg',
        'à¦²à§à¦Ÿ'   => 'lT',
        'à¦²à§à¦¡'   => 'lD',
        'à¦²à§à¦ª'   => 'lp',
        'à¦²à§à¦®'   => 'lm',
        'à¦²à§à¦²'   => 'll',
        'à¦²à§à¦¬'   => 'lb',
        'à¦²'     => 'l',
        'à¦®à§à¦¥'   => 'mth',
        'à¦®à§à¦«'   => 'mf',
        'à¦®à§à¦­'   => 'mv',
        'à¦®à¦ªà§à¦²'  => 'mpl',
        'à¦®à§à¦¨'   => 'mn',
        'à¦®à§à¦ª'   => 'mp',
        'à¦®à§à¦®'   => 'mm',
        'à¦®à§à¦²'   => 'ml',
        'à¦®à§à¦¬'   => 'mb',
        'à¦®'     => 'm',
        'à§¦'     => '0',
        'à§§'     => '1',
        'à§¨'     => '2',
        'à§©'     => '3',
        'à§ª'     => '4',
        'à§«'     => '5',
        'à§¬'     => '6',
        'à§­'     => '7',
        'à§®'     => '8',
        'à§¯'     => '9',
        'à¦™à§à¦•à§à¦·' => 'Ngkx',
        'à¦žà§à¦›'   => 'nch',
        'à¦™à§à¦˜'   => 'ngh',
        'à¦™à§à¦–'   => 'nkh',
        'à¦žà§à¦'   => 'njh',
        'à¦™à§à¦—à§Œ'  => 'ngOU',
        'à¦™à§à¦—à§ˆ'  => 'ngOI',
        'à¦žà§à¦š'   => 'nc',
        'à¦™à§à¦•'   => 'nk',
        'à¦™à§à¦·'   => 'Ngx',
        'à¦™à§à¦—'   => 'ngo',
        'à¦™à§à¦®'   => 'Ngm',
        'à¦žà§à¦œ'   => 'nj',
        'à¦¨à§à¦§'   => 'ndh',
        'à¦¨à§à¦ '   => 'nTh',
        'à¦£à§à¦ '   => 'NTh',
        'à¦¨à§à¦¥'   => 'nth',
        'à¦™à§à¦—à¦¾'  => 'nga',
        'à¦™à§à¦—à¦¿'  => 'ngi',
        'à¦™à§à¦—à§€'  => 'ngI',
        'à¦™à§à¦—à§'  => 'ngu',
        'à¦™à§à¦—à§‚'  => 'ngU',
        'à¦™à§à¦—à§‡'  => 'nge',
        'à¦™à§à¦—à§‹'  => 'ngO',
        'à¦£à§à¦¢'   => 'NDh',
        'à¦¨à¦¶'    => 'nsh',
        'à¦™à¦°'    => 'Ngr',
        'à¦žà¦°'    => 'NGr',
        'à¦‚à¦°'    => 'ngr',
        'à¦™'     => 'Ng',
        'à¦ž'     => 'NG',
        'à¦‚'     => 'ng',
        'à¦¨à§à¦¨'   => 'nn',
        'à¦£à§à¦£'   => 'NN',
        'à¦£à§à¦¨'   => 'Nn',
        'à¦¨à§à¦®'   => 'nm',
        'à¦£à§à¦®'   => 'Nm',
        'à¦¨à§à¦¦'   => 'nd',
        'à¦¨à§à¦Ÿ'   => 'nT',
        'à¦£à§à¦Ÿ'   => 'NT',
        'à¦¨à§à¦¡'   => 'nD',
        'à¦£à§à¦¡'   => 'ND',
        'à¦¨à§à¦¤'   => 'nt',
        'à¦¨à§à¦¸'   => 'ns',
        'à¦¨'     => 'n',
        'à¦£'     => 'N',
        'à§ˆ'     => 'OI',
        'à§Œ'     => 'OU',
        'à§‹'     => 'O',
        'à¦'     => 'OI',
        'à¦”'     => 'OU',
        'à¦…'     => 'o',
        'à¦“'     => 'oo',
        'à¦«à§à¦²'   => 'fl',
        'à¦ªà§à¦Ÿ'   => 'pT',
        'à¦ªà§à¦¤'   => 'pt',
        'à¦ªà§à¦¨'   => 'pn',
        'à¦ªà§à¦ª'   => 'pp',
        'à¦ªà§à¦²'   => 'pl',
        'à¦ªà§à¦¸'   => 'ps',
        'à¦«'     => 'f',
        'à¦ª'     => 'p',
        'à§ƒ'     => 'rri',
        'à¦‹'     => 'rri',
        'à¦°à¦°â€à§à¦¯' => 'rry',
        'à§à¦°à§à¦¯'  => 'ry',
        'à§à¦°à¦°'   => 'rr',
        'à§œà§à¦—'   => 'Rg',
        'à§'     => 'Rh',
        'à§œ'     => 'R',
        'à¦°'     => 'r',
        'à§à¦°'    => 'r',
        'à¦¶à§à¦›'   => 'Sch',
        'à¦·à§à¦ '   => 'ShTh',
        'à¦·à§à¦«'   => 'Shf',
        'à¦¸à§à¦•à§à¦²' => 'skl',
        'à¦¸à§à¦–'   => 'skh',
        'à¦¸à§à¦¥'   => 'sth',
        'à¦¸à§à¦«'   => 'sf',
        'à¦¶à§à¦š'   => 'Sc',
        'à¦¶à§à¦¤'   => 'St',
        'à¦¶à§à¦¨'   => 'Sn',
        'à¦¶à§à¦®'   => 'Sm',
        'à¦¶à§à¦²'   => 'Sl',
        'à¦·à§à¦•'   => 'Shk',
        'à¦·à§à¦Ÿ'   => 'ShT',
        'à¦·à§à¦£'   => 'ShN',
        'à¦·à§à¦ª'   => 'Shp',
        'à¦·à§à¦®'   => 'Shm',
        'à¦¸à§à¦ªà§à¦²' => 'spl',
        'à¦¸à§à¦•'   => 'sk',
        'à¦¸à§à¦Ÿ'   => 'sT',
        'à¦¸à§à¦¤'   => 'st',
        'à¦¸à§à¦¨'   => 'sn',
        'à¦¸à§à¦ª'   => 'sp',
        'à¦¸à§à¦®'   => 'sm',
        'à¦¸à§à¦²'   => 'sl',
        'à¦¶'     => 'S',
        'à¦·'     => 'Sh',
        'à¦¸'     => 's',
        'à§'     => 'u',
        'à¦‰'     => 'u',
        'à¦…à§à¦¯'   => 'oZ',
        'à¦¤à§à¦¥'   => 'tth',
        'à§Ž'     => 'tt',
        'à¦Ÿà§à¦Ÿ'   => 'TT',
        'à¦Ÿà§à¦®'   => 'Tm',
        'à¦ '     => 'Th',
        'à¦¤à§à¦¨'   => 'tn',
        'à¦¤à§à¦®'   => 'tm',
        'à¦¥'     => 'th',
        'à¦¤à§à¦¤'   => 'tt',
        'à¦Ÿ'     => 'T',
        'à¦¤'     => 't',
        'à¦…à§à¦¯à¦¾'  => 'AZ',
        'à¦¾'     => 'a',
        'à¦†'     => 'a',
        'à§Ÿà¦¾'    => 'ya',
        'à§Ÿ'     => 'y',
        'à¦¿'     => 'i',
        'à¦‡'     => 'i',
        'à§€'     => 'ee',
        'à¦ˆ'     => 'ee',
        'à§‚'     => 'uu',
        'à¦Š'     => 'uu',
        'à§‡'     => 'e',
        'à¦'     => 'e',
        'à¦¯'     => 'z',
        'à§à¦¯'    => 'Z',
        'à¦‡à§Ÿ'    => 'y',
        'à¦“à§Ÿ'    => 'w',
        'à§à¦¬'    => 'w',
        'à¦à¦•à§à¦¸'  => 'x',
        'à¦ƒ'     => ':',
        'à¦'     => 'nn',
        'à§â€Œ'    => '',
    ],
    // English
    'en' => [
    ],
    // Latin (+ Cyrillic ?) chars
    //
    // -> Mix of languages, but we need to keep this here, so that different languages can handle there own behavior.
    'latin' => [
        'Ëš'   => '0',
        'Â¹'   => '1',
        'Â²'   => '2',
        'Â³'   => '3',
        'â´'   => '4',
        'âµ'   => '5',
        'â¶'   => '6',
        'â·'   => '7',
        'â¸'   => '8',
        'â¹'   => '9',
        'â‚€'   => '0',
        'â‚'   => '1',
        'â‚‚'   => '2',
        'â‚ƒ'   => '3',
        'â‚„'   => '4',
        'â‚…'   => '5',
        'â‚†'   => '6',
        'â‚‡'   => '7',
        'â‚ˆ'   => '8',
        'â‚‰'   => '9',
        'à¯¦'   => '0',
        'à¯§'   => '1',
        'à¯¨'   => '2',
        'à¯©'   => '3',
        'à¯ª'   => '4',
        'à¯«'   => '5',
        'à¯¬'   => '6',
        'à¯­'   => '7',
        'à¯®'   => '8',
        'à¯¯'   => '9',
        'à¯°'   => '10',
        'à¯±'   => '100',
        'à¯²'   => '1000',
        'êœ²'   => 'AA',
        'êœ³'   => 'aa',
        'Ã†'   => 'AE',
        'Ã¦'   => 'ae',
        'Ç¼'   => 'AE',
        'Ç½'   => 'ae',
        'êœ´'   => 'AO',
        'êœµ'   => 'ao',
        'êœ¶'   => 'AU',
        'êœ·'   => 'au',
        'êœ¸'   => 'AV',
        'êœ¹'   => 'av',
        'êœº'   => 'av',
        'êœ»'   => 'av',
        'êœ¼'   => 'AY',
        'êœ½'   => 'ay',
        'È¸'   => 'db',
        'Ê£'   => 'dz',
        'Ê¥'   => 'dz',
        'Ê¤'   => 'dezh',
        'ðŸ™°'   => 'et',
        'ï¬€'   => 'ff',
        'ï¬ƒ'   => 'ffi',
        'ï¬„'   => 'ffl',
        'ï¬'   => 'fi',
        'ï¬‚'   => 'fl',
        'Ê©'   => 'feng',
        'Ä²'   => 'IJ',
        'Ä³'   => 'ij',
        'Êª'   => 'ls',
        'Ê«'   => 'lz',
        'É®'   => 'lezh',
        'È¹'   => 'qp',
        'Ê¨'   => 'tc',
        'Ê¦'   => 'ts',
        'Ê§'   => 'tesh',
        'Å’'   => 'OE',
        'Å“'   => 'oe',
        'êŽ'   => 'OO',
        'ê'   => 'oo',
        'áºž'   => 'SS',
        'ÃŸ'   => 'ss',
        'ï¬†'   => 'st',
        'ï¬…'   => 'st',
        'êœ¨'   => 'TZ',
        'êœ©'   => 'tz',
        'áµ«'   => 'ue',
        'AÎ¹'  => 'Ai',
        'Î±Î¹'  => 'ai',
        'Î•Î¹'  => 'Ei',
        'ÎµÎ¹'  => 'ei',
        'ÎŸÎ¹'  => 'Oi',
        'Î¿Î¹'  => 'oi',
        'ÎŸÏ…'  => 'Oy',
        'Î¿Ï…'  => 'oy',
        'Î¥Î¹'  => 'Yi',
        'Ï…Î¹'  => 'yi',
        'á¼€'   => 'a',
        'á¼'   => 'a',
        'á¼‚'   => 'a',
        'á¼ƒ'   => 'a',
        'á¼„'   => 'a',
        'á¼…'   => 'a',
        'á¼†'   => 'a',
        'á¼‡'   => 'a',
        'á¼ˆ'   => 'A',
        'á¼‰'   => 'A',
        'á¼Š'   => 'A',
        'á¼‹'   => 'A',
        'á¼Œ'   => 'A',
        'á¼'   => 'A',
        'á¼Ž'   => 'A',
        'á¼'   => 'A',
        'á¾°'   => 'a',
        'á¾±'   => 'a',
        'á¾²'   => 'a',
        'á¾³'   => 'a',
        'á¾´'   => 'a',
        'á¾¶'   => 'a',
        'á¾·'   => 'a',
        'á¾¸'   => 'A',
        'á¾¹'   => 'A',
        'á¾º'   => 'A',
        'á¾»'   => 'A',
        'á¾¼'   => 'A',
        'Ã„'   => 'A',
        'Ã¤'   => 'a',
        'Ã€'   => 'A',
        'Ã '   => 'a',
        'Ã'   => 'A',
        'Ã¡'   => 'a',
        'Ã‚'   => 'A',
        'Ã¢'   => 'a',
        'Ãƒ'   => 'A',
        'Ã£'   => 'a',
        'AÌ§'  => 'A',
        'aÌ§'  => 'a',
        'Ä„'   => 'A',
        'Ä…'   => 'a',
        'Èº'   => 'A',
        'â±¥'   => 'a',
        'Ã…'   => 'A',
        'Ã¥'   => 'a',
        'Çº'   => 'A',
        'Ç»'   => 'a',
        'Ä‚'   => 'A',
        'Äƒ'   => 'a',
        'Ç'   => 'A',
        'ÇŽ'   => 'a',
        'È¦'   => 'A',
        'È§'   => 'a',
        'áº '   => 'A',
        'áº¡'   => 'a',
        'Ä€'   => 'A',
        'Ä'   => 'a',
        'Âª'   => 'a',
        'Æ'   => 'B',
        'Ñ¢'   => 'E',
        'Ñ£'   => 'e',
        'Ã‡'   => 'C',
        'Ã§'   => 'c',
        'Äˆ'   => 'C',
        'Ä‰'   => 'c',
        'CÌˆ'  => 'C',
        'cÌˆ'  => 'c',
        'CÌ¨'  => 'C',
        'cÌ¨'  => 'c',
        'È»'   => 'C',
        'È¼'   => 'c',
        'ÄŒ'   => 'C',
        'Ä'   => 'c',
        'Ä†'   => 'C',
        'Ä‡'   => 'c',
        'CÌ€'  => 'C',
        'cÌ€'  => 'c',
        'ÄŠ'   => 'C',
        'Ä‹'   => 'c',
        'CÌ£'  => 'C',
        'cÌ£'  => 'c',
        'CÌ„'  => 'C',
        'cÌ„'  => 'c',
        'CÌƒ'  => 'C',
        'cÌƒ'  => 'c',
        'Ã'   => 'D',
        'Ä'   => 'D',
        'Ã°'   => 'd',
        'Ä‘'   => 'd',
        'Ãˆ'   => 'E',
        'Ã‰'   => 'E',
        'ÃŠ'   => 'E',
        'Ã‹'   => 'E',
        'Ä”'   => 'E',
        'Ä–'   => 'E',
        'È¨'   => 'E',
        'È©'   => 'e',
        'Ä˜'   => 'E',
        'Ä™'   => 'e',
        'É†'   => 'E',
        'É‡'   => 'e',
        'Äš'   => 'E',
        'Ä›'   => 'e',
        'áº¸'   => 'E',
        'áº¹'   => 'e',
        'Ä’'   => 'E',
        'Ä“'   => 'e',
        'áº¼'   => 'E',
        'áº½'   => 'e',
        'Ã¨'   => 'e',
        'Ã©'   => 'e',
        'Ãª'   => 'e',
        'Ã«'   => 'e',
        'Ä•'   => 'e',
        'Ä—'   => 'e',
        'Æ’'   => 'f',
        'Ñ²'   => 'F',
        'Ñ³'   => 'f',
        'Äœ'   => 'G',
        'Ä '   => 'G',
        'Ä'   => 'g',
        'Ä¡'   => 'g',
        'Ä¤'   => 'H',
        'Ä¦'   => 'H',
        'Ä¥'   => 'h',
        'Ä§'   => 'h',
        'ÃŒ'   => 'I',
        'Ã'   => 'I',
        'ÃŽ'   => 'I',
        'Ã'   => 'I',
        'Ä¨'   => 'I',
        'Ä¬'   => 'I',
        'Ç'   => 'I',
        'Ä®'   => 'I',
        'Ã¬'   => 'i',
        'Ã­'   => 'i',
        'Ã®'   => 'i',
        'Ã¯'   => 'i',
        'Ä©'   => 'i',
        'Ä­'   => 'i',
        'Ç'   => 'i',
        'Ä¯'   => 'i',
        'Ð†'   => 'I',
        'Ñ–'   => 'i',
        'IÌ§'  => 'I',
        'iÌ§'  => 'i',
        'Æ—'   => 'I',
        'É¨'   => 'i',
        'Ä°'   => 'I',
        'i'   => 'i',
        'á»Š'   => 'I',
        'á»‹'   => 'i',
        'Äª'   => 'I',
        'Ä«'   => 'i',
        'Ä´'   => 'J',
        'Äµ'   => 'j',
        'JÌÌ' => 'J',
        'jÌ'  => 'j',
        'JÌ€Ì€' => 'J',
        'jÌ€'  => 'j',
        'JÌˆ'  => 'J',
        'jÌˆ'  => 'j',
        'JÌ§'  => 'J',
        'jÌ§'  => 'j',
        'JÌ¨'  => 'J',
        'jÌ¨'  => 'j',
        'Éˆ'   => 'J',
        'É‰'   => 'j',
        'JÌŒ'  => 'J',
        'Ç°'   => 'j',
        'JÌ‡'  => 'J',
        'j'   => 'j',
        'JÌ£'  => 'J',
        'jÌ£'  => 'j',
        'JÌ„'  => 'J',
        'jÌ„'  => 'j',
        'JÌƒ'  => 'J',
        'jÌƒ'  => 'j',
        'Ð™' => 'i',
        'Ð¹' => 'i',
        'Ä¸'   => 'k',
        'Ä¹'   => 'L',
        'Ä½'   => 'L',
        'Ä¿'   => 'L',
        'Äº'   => 'l',
        'Ä¾'   => 'l',
        'Å€'   => 'l',
        'LÌ€'  => 'L',
        'lÌ€'  => 'l',
        'LÌ‚'  => 'L',
        'lÌ‚'  => 'l',
        'LÌˆ'  => 'L',
        'lÌˆ'  => 'l',
        'Ä»'   => 'L',
        'Ä¼'   => 'l',
        'LÌ¨'  => 'L',
        'lÌ¨'  => 'l',
        'Å'   => 'L',
        'Å‚'   => 'l',
        'È½'   => 'L',
        'Æš'   => 'l',
        'LÌ‡'  => 'L',
        'lÌ‡'  => 'l',
        'á¸¶'   => 'L',
        'á¸·'   => 'l',
        'LÌ„'  => 'L',
        'lÌ„'  => 'l',
        'LÌƒ'  => 'L',
        'lÌƒ'  => 'l',
        'Ã‘'   => 'N',
        'Ã±'   => 'n',
        'ÅŠ'   => 'N',
        'Å‹'   => 'n',
        'Å‰'   => 'n',
        'Åƒ'   => 'N',
        'Å„'   => 'n',
        'Ç¸'   => 'N',
        'Ç¹'   => 'n',
        'NÌ‚'  => 'N',
        'nÌ‚'  => 'n',
        'NÌˆ'  => 'N',
        'nÌˆ'  => 'n',
        'Å…'   => 'N',
        'Å†'   => 'n',
        'NÌ¨'  => 'N',
        'nÌ¨'  => 'n',
        'êž¤'   => 'N',
        'êž¥'   => 'n',
        'Å‡'   => 'N',
        'Åˆ'   => 'n',
        'á¹„'   => 'N',
        'á¹…'   => 'n',
        'á¹†'   => 'N',
        'á¹‡'   => 'n',
        'NÌ„'  => 'N',
        'nÌ„'  => 'n',
        'Ã–'   => 'O',
        'Ã’'   => 'O',
        'Ã“'   => 'O',
        'Ã”'   => 'O',
        'Ã•'   => 'O',
        'ÅŒ'   => 'O',
        'ÅŽ'   => 'O',
        'Ç‘'   => 'O',
        'Å'   => 'O',
        'Æ '   => 'O',
        'Ã˜'   => 'O',
        'Ç¾'   => 'O',
        'Ã¶'   => 'o',
        'Ã²'   => 'o',
        'Ã³'   => 'o',
        'Ã´'   => 'o',
        'Ãµ'   => 'o',
        'Å'   => 'o',
        'Å'   => 'o',
        'Ç’'   => 'o',
        'Å‘'   => 'o',
        'Æ¡'   => 'o',
        'Ã¸'   => 'o',
        'Ç¿'   => 'o',
        'Âº'   => 'o',
        'OÌ§'  => 'O',
        'oÌ§'  => 'o',
        'Çª'   => 'O',
        'Ç«'   => 'o',
        'ÆŸ'   => 'O',
        'Éµ'   => 'o',
        'È®'   => 'O',
        'È¯'   => 'o',
        'á»Œ'   => 'O',
        'á»'   => 'o',
        'Å”'   => 'R',
        'Å–'   => 'R',
        'Å•'   => 'r',
        'Å—'   => 'r',
        'Åœ'   => 'S',
        'È˜'   => 'S',
        'È™'   => 's',
        'Åš'   => 'S',
        'Å›'   => 's',
        'SÌ€'  => 'S',
        'sÌ€'  => 's',
        'ÅœÌ€'  => 'S',
        'Å'   => 's',
        'SÌˆ'  => 'S',
        'sÌˆ'  => 's',
        'Åž'   => 'S',
        'ÅŸ'   => 's',
        'SÌ¨'  => 'S',
        'sÌ¨'  => 's',
        'êž¨'   => 'S',
        'êž©'   => 's',
        'Å '   => 'S',
        'Å¡'   => 's',
        'á¹ '   => 'S',
        'á¹¡'   => 's',
        'á¹¢'   => 'S',
        'á¹£'   => 's',
        'SÌ„'  => 'S',
        'sÌ„'  => 's',
        'SÌƒ'  => 'S',
        'sÌƒ'  => 's',
        'Å¿'   => 's',
        'Å¢'   => 'T',
        'Èš'   => 'T',
        'Å¦'   => 'T',
        'Ãž'   => 'TH',
        'Å£'   => 't',
        'È›'   => 't',
        'Å§'   => 't',
        'Ã¾'   => 'th',
        'TÌ'  => 'T',
        'tÌ'  => 't',
        'TÌ€'  => 'T',
        'tÌ€'  => 't',
        'TÌ‚'  => 'T',
        'tÌ‚'  => 't',
        'TÌˆ'  => 'T',
        'áº—'   => 't',
        'TÌ¨'  => 'T',
        'tÌ¨'  => 't',
        'È¾'   => 'T',
        'â±¦'   => 't',
        'Å¤'   => 'T',
        'Å¥'   => 't',
        'á¹ª'   => 'T',
        'á¹«'   => 't',
        'á¹¬'   => 'T',
        'á¹­'   => 't',
        'TÌ„'  => 'T',
        'tÌ„'  => 't',
        'TÌƒ'  => 'T',
        'tÌƒ'  => 't',
        'Ãœ'   => 'U',
        'Ã™'   => 'U',
        'Ãš'   => 'U',
        'Ã›'   => 'U',
        'Å¨'   => 'U',
        'Å¬'   => 'U',
        'Å°'   => 'U',
        'Å²'   => 'U',
        'Æ¯'   => 'U',
        'Ç“'   => 'U',
        'Ç•'   => 'U',
        'Ç—'   => 'U',
        'Ç™'   => 'U',
        'Ç›'   => 'U',
        'Ã¼'   => 'u',
        'Ã¹'   => 'u',
        'Ãº'   => 'u',
        'Ã»'   => 'u',
        'Å©'   => 'u',
        'Å­'   => 'u',
        'Å±'   => 'u',
        'Å³'   => 'u',
        'Æ°'   => 'u',
        'Ç”'   => 'u',
        'Ç–'   => 'u',
        'Ç˜'   => 'u',
        'Çš'   => 'u',
        'Çœ'   => 'u',
        'UÌ§'  => 'U',
        'uÌ§'  => 'u',
        'É„'   => 'U',
        'Ê‰'   => 'u',
        'UÌ‡'  => 'U',
        'uÌ‡'  => 'u',
        'á»¤'   => 'U',
        'á»¥'   => 'u',
        'Åª'   => 'U',
        'Å«'   => 'u',
        'Æ±'   => 'U',
        'ÊŠ'   => 'u',
        'Å´'   => 'W',
        'Åµ'   => 'w',
        'áº€'   => 'W',
        'áº'   => 'w',
        'áº‚'   => 'W',
        'áºƒ'   => 'w',
        'áº„'   => 'W',
        'áº…'   => 'w',
        'Ñ´'   => 'I',
        'Ñµ'   => 'i',
        'ê™–'   => 'Ja',
        'ê™—'   => 'ja',
        'Ð„'   => 'Je',
        'Ñ”'   => 'je',
        'Ñ¤'   => 'Je',
        'Ñ¥'   => 'je',
        'Ð…'   => 'Dz',
        'Ñ•'   => 'dz',
        'ê™Š'   => 'U',
        'ê™‹'   => 'u',
        'Ñ '   => 'O',
        'Ñ¡'   => 'o',
        'Ñ¾'   => 'Ot',
        'Ñ¿'   => 'ot',
        'Ñª'   => 'U',
        'Ñ«'   => 'u',
        'Ñ¦'   => 'Ja',
        'Ñ§'   => 'ja',
        'Ñ¬'   => 'Ju',
        'Ñ­'   => 'ju',
        'Ñ¨'   => 'Ja',
        'Ñ©'   => 'Ja',
        'Ñ®'   => 'Ks',
        'Ñ¯'   => 'ks',
        'Ñ°'   => 'Ps',
        'Ñ±'   => 'ps',
        'Ð¥'   => 'X',
        'Ñ…'   => 'x',
        'Ã'   => 'Y',
        'Å¸'   => 'Y',
        'Å¶'   => 'Y',
        'Ã½'   => 'y',
        'Ã¿'   => 'y',
        'Å·'   => 'y',
        'á»²'   => 'Y',
        'á»³'   => 'y',
        'YÌ§'  => 'Y',
        'yÌ§'  => 'y',
        'YÌ¨'  => 'Y',
        'yÌ¨'  => 'y',
        'ÉŽ'   => 'Y',
        'É'   => 'y',
        'YÌŒ'  => 'Y',
        'yÌŒ'  => 'y',
        'áºŽ'   => 'Y',
        'áº'   => 'y',
        'á»´'   => 'Y',
        'á»µ'   => 'y',
        'È²'   => 'Y',
        'È³'   => 'y',
        'á»¸'   => 'Y',
        'á»¹'   => 'y',
        'Ð©' => 'Shh',
        'Ñ‰' => 'shh',
        'Å¹'   => 'Z',
        'Åº'   => 'z',
        'ZÌ€'  => 'Z',
        'zÌ€'  => 'z',
        'áº'   => 'Z',
        'áº‘'   => 'z',
        'ZÌˆ'  => 'Z',
        'zÌˆ'  => 'z',
        'ZÌ§'  => 'Z',
        'zÌ§'  => 'z',
        'ZÌ¨'  => 'Z',
        'zÌ¨'  => 'z',
        'Æµ'   => 'Z',
        'Æ¶'   => 'z',
        'Å½'   => 'Z',
        'Å¾'   => 'z',
        'Å»'   => 'Z',
        'Å¼'   => 'z',
        'áº’'   => 'Z',
        'áº“'   => 'z',
        'ZÌ„'  => 'Z',
        'zÌ„'  => 'z',
        'ZÌƒ'  => 'Z',
        'zÌƒ'  => 'z',
    ],
    // whitespace chars
    ' ' => [
        "\xc2\xa0"     => ' ', // 'NO-BREAK SPACE'
        "\xe1\x9a\x80" => ' ', // 'OGHAM SPACE MARK'
        "\xe2\x80\x80" => ' ', // 'EN QUAD'
        "\xe2\x80\x81" => ' ', // 'EM QUAD'
        "\xe2\x80\x82" => ' ', // 'EN SPACE'
        "\xe2\x80\x83" => ' ', // 'EM SPACE'
        "\xe2\x80\x84" => ' ', // 'THREE-PER-EM SPACE'
        "\xe2\x80\x85" => ' ', // 'FOUR-PER-EM SPACE'
        "\xe2\x80\x86" => ' ', // 'SIX-PER-EM SPACE'
        "\xe2\x80\x87" => ' ', // 'FIGURE SPACE'
        "\xe2\x80\x88" => ' ', // 'PUNCTUATION SPACE'
        "\xe2\x80\x89" => ' ', // 'THIN SPACE'
        "\xe2\x80\x8a" => ' ', // 'HAIR SPACE'
        "\xe2\x80\xa8" => ' ', // 'LINE SEPARATOR'
        "\xe2\x80\xa9" => ' ', // 'PARAGRAPH SEPARATOR'
        "\xe2\x80\x8b" => ' ', // 'ZERO WIDTH SPACE'
        "\xe2\x80\xaf" => ' ', // 'NARROW NO-BREAK SPACE'
        "\xe2\x81\x9f" => ' ', // 'MEDIUM MATHEMATICAL SPACE'
        "\xe3\x80\x80" => ' ', // 'IDEOGRAPHIC SPACE'
        "\xef\xbe\xa0" => ' ', // 'HALFWIDTH HANGUL FILLER'
    ],
    // commonly used in Word documents
    'msword' => [
        "\xc2\xab"     => '<<', // Â« (U+00AB) in UTF-8
        "\xc2\xbb"     => '>>', // Â» (U+00BB) in UTF-8
        "\xe2\x80\x98" => "'", // â€˜ (U+2018) in UTF-8
        "\xe2\x80\x99" => "'", // â€™ (U+2019) in UTF-8
        "\xe2\x80\x9a" => "'", // â€š (U+201A) in UTF-8
        "\xe2\x80\x9b" => "'", // â€› (U+201B) in UTF-8
        "\xe2\x80\x9c" => '"', // â€œ (U+201C) in UTF-8
        "\xe2\x80\x9d" => '"', // â€ (U+201D) in UTF-8
        "\xe2\x80\x9e" => '"', // â€ž (U+201E) in UTF-8
        "\xe2\x80\x9f" => '"', // â€Ÿ (U+201F) in UTF-8
        "\xe2\x80\xb9" => "'", // â€¹ (U+2039) in UTF-8
        "\xe2\x80\xba" => "'", // â€º (U+203A) in UTF-8
        "\xe2\x80\x93" => '-', // â€“ (U+2013) in UTF-8
        "\xe2\x80\x94" => '-', // â€” (U+2014) in UTF-8
        "\xe2\x80\xa6" => '...', // â€¦ (U+2026) in UTF-8
    ],
    // Currency
    //
    // url => https://en.wikipedia.org/wiki/Currency_symbol
    'currency_short' => [
        'â‚¬'  => 'EUR',
        '$'  => '$',
        'â‚¢'  => 'Cr',
        'â‚£'  => 'Fr.',
        'Â£'  => 'PS',
        'â‚¤'  => 'L.',
        'â„³'  => 'M',
        'â‚¥'  => 'mil',
        'â‚¦'  => 'N',
        'â‚§'  => 'Pts',
        'â‚¨'  => 'Rs',
        'à¶»à·”' => 'LKR',
        'à®°à¯‚' => 'LKR',
        'à¯¹'  => 'Rs',
        'à¤°à¥‚' => 'NPR',
        'â‚¹'  => 'Rs',
        'à«±'  => 'Rs',
        'â‚©'  => 'W',
        'â‚ª'  => 'NS',
        'â‚¸'  => 'KZT',
        'â‚«'  => 'D',
        'Ö'  => 'AMD',
        'â‚­'  => 'K',
        'â‚º'  => 'TL',
        'â‚¼'  => 'AZN',
        'â‚®'  => 'T',
        'â‚¯'  => 'Dr',
        'â‚²'  => 'PYG',
        'â‚¾'  => 'GEL',
        'â‚³'  => 'ARA',
        'â‚´'  => 'UAH',
        'â‚½'  => 'RUB',
        'â‚µ'  => 'GHS',
        'â‚¡'  => 'CL',
        'Â¢'  => 'c',
        'Â¥'  => 'YEN',
        'å††'  => 'JPY',
        'à§³'  => 'BDT',
        'å…ƒ'  => 'CNY',
        'ï·¼'  => 'SAR',
        'áŸ›'  => 'KR',
        'â‚ '  => 'ECU',
        'Â¤'  => '$?',
        'à¸¿'  => 'THB',
        'Ø‹'  => 'AFN',
    ],
];
